/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.animations.DeepLurkerAnimation;
import wardentools.entity.custom.DeepLurkerEntity;

@OnlyIn(value=Dist.CLIENT)
public class DeepLurker
extends HierarchicalModel<DeepLurkerEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"deeplurker"), "main");
    private final ModelParts parts;

    public DeepLurker(ModelPart root) {
        ModelPart FULL = root.getChild("FULL");
        ModelPart LOW_BODY = FULL.getChild("LOW_BODY");
        ModelPart ARM_R = LOW_BODY.getChild("ARM_R");
        ModelPart foreArmR = ARM_R.getChild("foreArmR");
        ModelPart ARM_L = LOW_BODY.getChild("ARM_L");
        ModelPart foreArmL = ARM_L.getChild("foreArmL");
        ModelPart LegR = LOW_BODY.getChild("LegR");
        ModelPart LegL = LOW_BODY.getChild("LegL");
        ModelPart HEAD = FULL.getChild("HEAD");
        ModelPart earL = HEAD.getChild("earL");
        ModelPart earR = HEAD.getChild("earR");
        ModelPart earR_r1 = earR.getChild("earR_r1");
        ModelPart body = LOW_BODY.getChild("body");
        this.parts = new ModelParts(FULL, LOW_BODY, ARM_R, foreArmR, ARM_L, foreArmL, LegR, LegL, HEAD, earL, earR, earR_r1, body);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partdefinition = meshDefinition.getRoot();
        PartDefinition FULL = partdefinition.addOrReplaceChild("FULL", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)18.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition LOW_BODY = FULL.addOrReplaceChild("LOW_BODY", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)1.0f, (float)0.0f));
        PartDefinition ARM_R = LOW_BODY.addOrReplaceChild("ARM_R", CubeListBuilder.create().texOffs(6, 2).addBox(0.0f, -1.0f, -1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)1.0f, (float)-2.0f));
        PartDefinition foreArmR = ARM_R.addOrReplaceChild("foreArmR", CubeListBuilder.create().texOffs(7, 2).addBox(0.0f, -1.0f, 0.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)0.0f, (float)-1.0f));
        PartDefinition ARM_L = LOW_BODY.addOrReplaceChild("ARM_L", CubeListBuilder.create().texOffs(6, 2).addBox(-1.0f, -1.0f, 0.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)2.0f));
        PartDefinition foreArmL = ARM_L.addOrReplaceChild("foreArmL", CubeListBuilder.create().texOffs(7, 2).addBox(-1.0f, -1.0f, 0.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)0.0f, (float)0.0f));
        PartDefinition LegR = LOW_BODY.addOrReplaceChild("LegR", CubeListBuilder.create().texOffs(7, 0).addBox(0.0f, 0.0f, 0.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 21).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)4.0f, (float)-3.0f));
        PartDefinition LegL = LOW_BODY.addOrReplaceChild("LegL", CubeListBuilder.create().texOffs(7, 0).addBox(0.0f, 0.0f, 0.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 21).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)4.0f, (float)2.0f));
        PartDefinition HEAD = FULL.addOrReplaceChild("HEAD", CubeListBuilder.create().texOffs(0, 19).addBox(-3.0f, -5.0f, -4.0f, 4.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)0.0f, (float)0.0f));
        PartDefinition earL = HEAD.addOrReplaceChild("earL", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -3.0f, -1.0f, 1.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-4.0f, (float)3.0f));
        PartDefinition earR = HEAD.addOrReplaceChild("earR", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)-3.0f));
        PartDefinition earR_r1 = earR.addOrReplaceChild("earR_r1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, -5.0f, -1.0f, 1.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition body = LOW_BODY.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 9).addBox(-3.0f, -3.0f, -2.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int i) {
        this.parts.FULL().render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
    }

    @NotNull
    public ModelPart root() {
        return this.parts.FULL();
    }

    public void setupAnim(DeepLurkerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.scaredAnimationState, DeepLurkerAnimation.scared, ageInTicks);
        this.animate(entity.calmAnimationState, DeepLurkerAnimation.calm1, ageInTicks);
        this.animateWalk(DeepLurkerAnimation.walking, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        this.parts.HEAD().yRot += netHeadYaw * ((float)Math.PI / 180);
        this.parts.HEAD().zRot += headPitch * ((float)Math.PI / 180);
    }

    private record ModelParts(ModelPart FULL, ModelPart LOW_BODY, ModelPart ARM_R, ModelPart foreArmR, ModelPart ARM_L, ModelPart foreArmL, ModelPart LegR, ModelPart LegL, ModelPart HEAD, ModelPart earL, ModelPart earR, ModelPart earR_r1, ModelPart body) {
    }
}

