/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils.goal;

import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import wardentools.entity.custom.ContagionIncarnationEntity;

public class IncarnationAttackGoal
extends Goal {
    protected final ContagionIncarnationEntity incarnation;
    private final double speedModifier;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 40;
    private long lastCanUseCheck;
    private static final int COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20;

    public IncarnationAttackGoal(ContagionIncarnationEntity incarnation, double speedModifier) {
        this.incarnation = incarnation;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.internalCanUse() && this.incarnation.getSonicStrikeTick() == 0;
    }

    public boolean internalCanUse() {
        long i = this.incarnation.level().getGameTime();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.incarnation.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive()) {
            return false;
        }
        this.path = this.incarnation.getNavigation().createPath((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.incarnation.isWithinMeleeAttackRange(livingentity);
    }

    public boolean canContinueToUse() {
        return this.internalCanContinueToUse() && this.incarnation.getSonicStrikeTick() == 0;
    }

    public boolean internalCanContinueToUse() {
        LivingEntity entity = this.incarnation.getTarget();
        if (entity == null) {
            return false;
        }
        if (!entity.isAlive()) {
            return false;
        }
        if (!this.incarnation.isWithinRestriction(entity.blockPosition())) {
            return false;
        }
        return !(entity instanceof Player) || !entity.isSpectator() && !((Player)entity).isCreative();
    }

    public void start() {
        this.incarnation.getNavigation().moveTo(this.path, this.speedModifier);
        this.incarnation.setAggressive(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void stop() {
        LivingEntity livingentity = this.incarnation.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
            this.incarnation.setTarget(null);
        }
        this.incarnation.setAggressive(false);
        this.incarnation.getNavigation().stop();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity livingentity = this.incarnation.getTarget();
        if (livingentity != null) {
            this.incarnation.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if (this.incarnation.getSensing().hasLineOfSight((Entity)livingentity) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.incarnation.getRandom().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.getX();
                this.pathedTargetY = livingentity.getY();
                this.pathedTargetZ = livingentity.getZ();
                this.ticksUntilNextPathRecalculation = 4 + this.incarnation.getRandom().nextInt(7);
                double distanceToTarget = this.incarnation.distanceTo((Entity)livingentity);
                if (distanceToTarget > 32.0) {
                    this.ticksUntilNextPathRecalculation += 40;
                } else if (distanceToTarget > 16.0) {
                    this.ticksUntilNextPathRecalculation += 20;
                }
                if (!this.incarnation.getNavigation().moveTo((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 20;
                }
                this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingentity);
        }
    }

    protected void checkAndPerformAttack(LivingEntity entity) {
        if (this.canPerformAttack(entity)) {
            this.resetAttackCooldown();
            this.incarnation.swing(InteractionHand.MAIN_HAND);
            this.incarnation.swingWithClosestHand();
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(40);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(LivingEntity entity) {
        return this.isTimeToAttack() && this.incarnation.isWithinMeleeAttackRange(entity) && this.incarnation.getSensing().hasLineOfSight((Entity)entity);
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.adjustedTickDelay(40);
    }
}

