/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils.goal;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import wardentools.entity.custom.NoctilureEntity;

public class JoinOwnerGoal
extends Goal {
    private int tickCount = 0;
    private static final int maxTickCount = 1000;
    private final NoctilureEntity noctilure;
    private static final double MAX_DISTANCE_TO_MOVE = 40.0;

    public JoinOwnerGoal(NoctilureEntity noctilure) {
        this.noctilure = noctilure;
    }

    public void start() {
        this.tickCount = 0;
        this.noctilure.resetRandomFlyingLogic();
        if (this.noctilure.getOwnerUUID() == null) {
            this.noctilure.setWantsToJoinOwner(false);
            return;
        }
    }

    public boolean canUse() {
        return this.noctilure.getWantsToJoinOwner() && this.noctilure.getOwnerUUID() != null;
    }

    public boolean canContinueToUse() {
        return this.tickCount <= 1000 && super.canContinueToUse();
    }

    public void tick() {
        if (this.noctilure.level().isClientSide) {
            return;
        }
        ++this.tickCount;
        if (this.noctilure.getOwnerUUID() == null) {
            this.stop();
            return;
        }
        Player player = this.noctilure.level().getPlayerByUUID(this.noctilure.getOwnerUUID());
        if (player == null) {
            this.stop();
            return;
        }
        this.noctilure.getLookControl().setLookAt((Entity)player);
        if (this.noctilure.closerThan((Entity)player, 2.0)) {
            this.stop();
        }
        if (this.tickCount % 20 == 0) {
            this.setTargetOrCancel();
        }
    }

    public void stop() {
        this.tickCount = 0;
        this.landIfGroundCloseEnough();
        this.noctilure.setWantsToJoinOwner(false);
        super.stop();
    }

    private void setTargetOrCancel() {
        if (this.noctilure.getOwnerUUID() == null) {
            this.stop();
            return;
        }
        Player player = this.noctilure.level().getPlayerByUUID(this.noctilure.getOwnerUUID());
        if (player == null) {
            this.noctilure.setWantsToJoinOwner(false);
            return;
        }
        if (this.noctilure.closerThan((Entity)player, 40.0)) {
            this.noctilure.setIsFlying(true);
            this.noctilure.setNoGravity(true);
            this.noctilure.updateMovementLogic();
            if (!this.noctilure.getNavigation().moveTo((Entity)player, 1.0)) {
                this.noctilure.teleportTo(player.getX(), player.getY(), player.getZ());
                this.stop();
            }
        } else {
            this.noctilure.teleportTo(player.getX(), player.getY(), player.getZ());
            this.stop();
        }
    }

    private void landIfGroundCloseEnough() {
        if (this.noctilure.getHeightAboveGround() < 2.0) {
            this.noctilure.setWantsToLand(true);
        }
    }
}

