/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils.goal;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import wardentools.entity.custom.NoctilureEntity;

public class RandomFlyGoal
extends Goal {
    private final NoctilureEntity noctilure;
    private float angle;
    private float distance;
    private float height;
    private float clockwise;
    private float circleWidness;

    public RandomFlyGoal(NoctilureEntity noctilure) {
        this.noctilure = noctilure;
    }

    public void start() {
        this.distance = 100.0f + this.noctilure.getRandom().nextFloat() * 10.0f;
        this.height = (float)this.noctilure.getY();
        this.clockwise = this.noctilure.getRandom().nextBoolean() ? 1.0f : -1.0f;
        this.circleWidness = 0.01f + this.noctilure.getRandom().nextFloat() * 0.02f;
    }

    public void tick() {
        if (this.noctilure.horizontalCollision) {
            this.noctilure.setYRot(this.noctilure.getYRot() + 180.0f);
            this.noctilure.yBodyRot = this.noctilure.getYRot();
            this.noctilure.setDeltaMovement(this.noctilure.getDeltaMovement().add(0.0, 0.5, 0.0));
            this.clockwise = -this.clockwise;
        }
        if (this.noctilure.getRandom().nextInt(1000) == 0) {
            this.start();
        }
        this.angle += this.clockwise * this.circleWidness;
        double x = this.noctilure.getX() + (double)(this.distance * Mth.cos((float)this.angle));
        double z = this.noctilure.getZ() + (double)(this.distance * Mth.sin((float)this.angle));
        double y = this.height;
        this.noctilure.setDeltaMovement(new Vec3(x - this.noctilure.getX(), y - this.noctilure.getY(), z - this.noctilure.getZ()).normalize().scale(0.1600000113248825));
        this.noctilure.setYRot((float)(Mth.atan2((double)(z - this.noctilure.getZ()), (double)(x - this.noctilure.getX())) * 57.29577951308232) - 90.0f);
        this.noctilure.yBodyRot = this.noctilure.getYRot();
    }

    public boolean canUse() {
        return this.noctilure.getIsFlying() && !this.noctilure.getWantsToTakeOff() && !this.noctilure.getWantsToLand() && !this.noctilure.isVehicle() && !this.noctilure.getWantsToJoinOwner();
    }

    public void stop() {
        super.stop();
    }
}

