/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import wardentools.entity.custom.ContagionIncarnationEntity;

public class TurnTowardsTargetGoal
extends Goal {
    private static final float ANGLE_THRESHOLD = 10.0f;
    private static final double PUSH_STRENGTH = 0.15;
    private final ContagionIncarnationEntity incarnation;
    private final double speed;
    private int stuckTicks = 0;
    private static final int MAX_STUCK_TICKS = 40;

    public TurnTowardsTargetGoal(ContagionIncarnationEntity incarnation, double speed) {
        this.incarnation = incarnation;
        this.speed = speed;
    }

    public boolean canUse() {
        return this.incarnation.horizontalCollision && this.incarnation.getTarget() != null;
    }

    public boolean canContinueToUse() {
        return (this.incarnation.horizontalCollision || this.angleTowardTarget() > 10.0f) && this.incarnation.getTarget() != null && this.stuckTicks < 40;
    }

    public void start() {
        super.start();
        this.stuckTicks = 0;
    }

    public void tick() {
        float angleDifference;
        super.tick();
        float targetAngle = this.angleTowardTarget();
        float currentYaw = this.incarnation.getYRot();
        for (angleDifference = targetAngle - currentYaw; angleDifference > 180.0f; angleDifference -= 360.0f) {
        }
        while (angleDifference < -180.0f) {
            angleDifference += 360.0f;
        }
        if (Math.abs(angleDifference) > 10.0f) {
            float turnAmount = (float)(this.speed * (double)Math.signum(angleDifference));
            this.incarnation.setYRot(currentYaw + turnAmount);
            this.incarnation.yRotO = this.incarnation.getYRot();
        }
        if (this.incarnation.horizontalCollision) {
            this.pushAwayFromWall();
            ++this.stuckTicks;
        }
    }

    private void pushAwayFromWall() {
        AABB boundingBox = this.incarnation.getBoundingBox();
        Vec3 entityPos = this.incarnation.position();
        int minX = (int)Math.floor(boundingBox.minX);
        int maxX = (int)Math.ceil(boundingBox.maxX);
        int minY = (int)Math.floor(boundingBox.minY);
        int maxY = (int)Math.ceil(boundingBox.maxY);
        int minZ = (int)Math.floor(boundingBox.minZ);
        int maxZ = (int)Math.ceil(boundingBox.maxZ);
        Vec3 pushDirection = Vec3.ZERO;
        int collisionCount = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.incarnation.level().getBlockState(pos);
                    if (state.isAir() || !state.isSolidRender((BlockGetter)this.incarnation.level(), pos)) continue;
                    Vec3 blockCenter = Vec3.atCenterOf((Vec3i)pos);
                    Vec3 awayFromBlock = entityPos.subtract(blockCenter).normalize();
                    awayFromBlock = new Vec3(awayFromBlock.x, 0.0, awayFromBlock.z).normalize();
                    pushDirection = pushDirection.add(awayFromBlock);
                    ++collisionCount;
                }
            }
        }
        if (collisionCount > 0) {
            pushDirection = pushDirection.normalize().scale(0.15);
            Vec3 currentDelta = this.incarnation.getDeltaMovement();
            this.incarnation.setDeltaMovement(currentDelta.x + pushDirection.x, currentDelta.y, currentDelta.z + pushDirection.z);
        }
    }

    private float angleTowardTarget() {
        if (this.incarnation.getTarget() == null) {
            return 0.0f;
        }
        double dx = this.incarnation.getTarget().getX() - this.incarnation.getX();
        double dz = this.incarnation.getTarget().getZ() - this.incarnation.getZ();
        return (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
    }
}

