/*
 * Decompiled with CFR 0.152.
 */
package wardentools.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import wardentools.worldgen.structure.ModStructures;
import wardentools.worldgen.structure.StructureUtils;

public class AncientCitadelMap
extends Item {
    public AncientCitadelMap(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        BlockPos playerPos;
        ServerLevel serverLevel;
        BlockPos structurePos;
        ItemStack itemstack = player.getItemInHand(hand);
        if (!level.isClientSide() && (structurePos = StructureUtils.findNearestStructure(serverLevel = (ServerLevel)level, ModStructures.ANCIENT_CITADEL, playerPos = player.blockPosition())) != null) {
            ItemStack mapStack = MapItem.create((Level)serverLevel, (int)structurePos.getX(), (int)structurePos.getZ(), (byte)2, (boolean)true, (boolean)true);
            MapItem.renderBiomePreviewMap((ServerLevel)serverLevel, (ItemStack)mapStack);
            MapItemSavedData.addTargetDecoration((ItemStack)mapStack, (BlockPos)structurePos, (String)"+", (Holder)MapDecorationTypes.RED_X);
            player.setItemInHand(hand, mapStack);
            return InteractionResultHolder.success((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }
}

