/*
 * Decompiled with CFR 0.152.
 */
package wardentools.items;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;
import wardentools.items.ItemRegistry;
import wardentools.misc.CustomDamageType;

public class ScytheItem
extends Item {
    public ScytheItem(Item.Properties properties) {
        super(properties.component(DataComponents.TOOL, (Object)ScytheItem.createToolProperties()));
    }

    private static Tool createToolProperties() {
        return new Tool(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.MINEABLE_WITH_HOE, (float)1.5f)), 1.0f, 2);
    }

    public static ItemAttributeModifiers createAttributes(int attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean isValidRepairItem(ItemStack stack, @NotNull ItemStack stack1) {
        return stack.is((Item)ItemRegistry.DEEPINGOTS.get()) || stack1.is((Item)ItemRegistry.DEEPINGOTS.get());
    }

    public boolean canAttackBlock(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public boolean hurtEnemy(ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity user) {
        Holder.Reference sweepingHolder = target.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SWEEPING_EDGE);
        int sweeping = stack.getEnchantmentLevel((Holder)sweepingHolder);
        if (sweeping > 0) {
            float extraDamage = 1.5f * (float)sweeping;
            target.hurt(user.damageSources().playerAttack((Player)user), extraDamage);
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            if (!player.isCreative() && !player.isSpectator()) {
                this.hurtUser(user, 0.25f);
            }
        } else {
            this.hurtUser(user, 0.25f);
        }
        stack.hurtAndBreak(1, user, EquipmentSlot.MAINHAND);
        return true;
    }

    private void hurtUser(@NotNull LivingEntity user, float damage) {
        Holder.Reference corruptedDamageTypeHolder = user.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(CustomDamageType.CORRUPTED_KEY);
        user.hurt(new DamageSource((Holder)corruptedDamageTypeHolder), damage);
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        return 15;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return true;
    }

    public boolean supportsEnchantment(@NotNull ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.SWEEPING_EDGE) || enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.LOOTING);
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility itemAbility) {
        return false;
    }
}

