/*
 * Decompiled with CFR 0.152.
 */
package wardentools.sounds;

import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.JukeboxSong;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModSounds {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"wardentools");
    public static final Supplier<SoundEvent> CONTAGION_INCARNATION_SCREAM = ModSounds.registerSoundEvents("contagion_incarnation_scream");
    public static final Supplier<SoundEvent> CONTAGION_INCARNATION_CRAWL = ModSounds.registerSoundEvents("contagion_incarnation_crawl");
    public static final Supplier<SoundEvent> CONTAGION_INCARNATION_AMBIENT = ModSounds.registerSoundEvents("contagion_incarnation_ambient");
    public static final Supplier<SoundEvent> CONTAGION_INCARNATION_DEATH = ModSounds.registerSoundEvents("contagion_incarnation_death");
    public static final Supplier<SoundEvent> NOCTILURE_AMBIENT = ModSounds.registerSoundEvents("noctilure_ambient");
    public static final Supplier<SoundEvent> NOCTILURE_DEATH = ModSounds.registerSoundEvents("noctilure_death");
    public static final Supplier<SoundEvent> SHADOW_AMBIENT = ModSounds.registerSoundEvents("shadow_ambient");
    public static final Supplier<SoundEvent> SHADOW_DEATH = ModSounds.registerSoundEvents("shadow_death");
    public static final Supplier<SoundEvent> PARASYTE_DEATH = ModSounds.registerSoundEvents("parasyte_death");
    public static final Supplier<SoundEvent> PARASYTE_HURT = ModSounds.registerSoundEvents("parasyte_hurt");
    public static final Supplier<SoundEvent> PARASYTE_STEP = ModSounds.registerSoundEvents("parasyte_step");
    public static final Supplier<SoundEvent> DEEP_LURKER_HURT = ModSounds.registerSoundEvents("deeplurker_hurt");
    public static final Supplier<SoundEvent> DEEP_LURKER_DEATH = ModSounds.registerSoundEvents("deeplurker_death");
    public static final Supplier<SoundEvent> PALE_WANDERER_DEATH = ModSounds.registerSoundEvents("pale_wanderer_death");
    public static final Supplier<SoundEvent> PALE_WANDERER_HURT = ModSounds.registerSoundEvents("pale_wanderer_hurt");
    public static final Supplier<SoundEvent> PROTECTOR_AMBIENT = ModSounds.registerSoundEvents("protector_ambient");
    public static final Supplier<SoundEvent> PROTECTOR_DEATH = ModSounds.registerSoundEvents("protector_death");
    public static final Supplier<SoundEvent> ANCIENT_LABORATORY_GATE_CLOSING = ModSounds.registerSoundEvents("ancient_laboratory_gate_closing");
    public static final Supplier<SoundEvent> CONTAGION_INCARNATION_EMERGE = ModSounds.registerSoundEvents("contagion_incarnation_emerge");
    public static final Supplier<SoundEvent> SONIC_STRIKE = ModSounds.registerSoundEvents("sonic_strike");
    public static final Supplier<SoundEvent> SHOCKWAVE_THUNDER = ModSounds.registerSoundEvents("shockwave_thunder");
    public static final Supplier<SoundEvent> WHISTLE = ModSounds.registerSoundEvents("whistle");
    public static final Supplier<SoundEvent> WIND_WHISPERS = ModSounds.registerSoundEvents("wind_whispers");
    public static final Supplier<SoundEvent> VINYL_START = ModSounds.registerSoundEvents("vinyl_start");
    public static final Supplier<SoundEvent> VINYL_END = ModSounds.registerSoundEvents("vinyl_end");
    public static final Supplier<SoundEvent> VINYL_SCRATCH = ModSounds.registerSoundEvents("vinyl_scratch");
    public static final Supplier<SoundEvent> HEART_BEAT = ModSounds.registerSoundEvents("heart_beat");
    public static final Supplier<SoundEvent> CRYSTAL_GOLEM_AMBIENT = ModSounds.registerSoundEvents("crystal_golem_ambient");
    public static final Supplier<SoundEvent> CRYSTAL_GOLEM_TURNING_ON = ModSounds.registerSoundEvents("crystal_golem_turning_on");
    public static final Supplier<SoundEvent> CRYSTAL_GOLEM_TURNING_OFF = ModSounds.registerSoundEvents("crystal_golem_turning_off");
    public static final Supplier<SoundEvent> CRYSTAL_GOLEM_HURT = ModSounds.registerSoundEvents("crystal_golem_hurt");
    public static final Supplier<SoundEvent> CRYSTAL_GOLEM_DEATH = ModSounds.registerSoundEvents("crystal_golem_death");
    public static final Supplier<SoundEvent> CRYSTAL_GOLEM_STEP = ModSounds.registerSoundEvents("crystal_golem_step");
    public static final Supplier<SoundEvent> CRYSTAL_GOLEM_AGGRESSION = ModSounds.registerSoundEvents("crystal_golem_aggression");
    public static final Supplier<SoundEvent> LASER_CHARGE = ModSounds.registerSoundEvents("laser_charge");
    public static final Supplier<SoundEvent> LASER_SHOOT = ModSounds.registerSoundEvents("laser_shoot");
    public static final Supplier<SoundEvent> INFUSER_CHARGING = ModSounds.registerSoundEvents("infuser_charging");
    public static final Supplier<SoundEvent> DEEP_FOREST = ModSounds.registerSoundEvents("deep_forest_music");
    public static final Supplier<SoundEvent> WHITE_FOREST = ModSounds.registerSoundEvents("white_forest_music");
    public static final Supplier<SoundEvent> INCARNATION_THEME = ModSounds.registerSoundEvents("incarnation_theme");
    public static final Supplier<SoundEvent> ABYSS_THEME = ModSounds.registerSoundEvents("abyss_theme");
    public static final Supplier<SoundEvent> REFLECTION = ModSounds.registerSoundEvents("reflection_of_the_past_music");

    public static Holder.Reference<SoundEvent> getDeepForestMusicDisc() {
        return BuiltInRegistries.SOUND_EVENT.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)DEEP_FOREST.get().getLocation()));
    }

    public static Holder.Reference<SoundEvent> getWhiteForestMusicDisc() {
        return BuiltInRegistries.SOUND_EVENT.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)WHITE_FOREST.get().getLocation()));
    }

    public static Holder.Reference<SoundEvent> getIncarnationThemeMusicDisc() {
        return BuiltInRegistries.SOUND_EVENT.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)INCARNATION_THEME.get().getLocation()));
    }

    public static Holder.Reference<SoundEvent> getAbyssThemeMusicDisc() {
        return BuiltInRegistries.SOUND_EVENT.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ABYSS_THEME.get().getLocation()));
    }

    public static Holder.Reference<SoundEvent> getReflectionMusicDisc() {
        return BuiltInRegistries.SOUND_EVENT.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)REFLECTION.get().getLocation()));
    }

    private static ResourceKey<JukeboxSong> createSong(String name) {
        return ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)name));
    }

    private static Supplier<SoundEvent> registerSoundEvents(String name) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)name);
        return SOUND_EVENTS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)id));
    }

    public static void register(IEventBus eventBus) {
        SOUND_EVENTS.register(eventBus);
    }
}

