/*
 * Decompiled with CFR 0.152.
 */
package wardentools.weather;

import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;
import wardentools.block.BlockRegistry;
import wardentools.fluid.ModFluidTypes;
import wardentools.weather.AbyssWeatherEventClient;
import wardentools.worldgen.dimension.ModDimensions;

@EventBusSubscriber(modid="wardentools", value={Dist.CLIENT})
public class AbyssFogEvent {
    private static final int RADIUS_FOR_UNDER_SKY_CHECK = 15;

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        Player player;
        Entity entity = event.getCamera().getEntity();
        if (entity instanceof Player && (player = (Player)entity).level().dimension() == ModDimensions.ABYSS_LEVEL_KEY) {
            if (event.getCamera().getFluidInCamera() == FogType.LAVA || event.getCamera().getFluidInCamera() == FogType.POWDER_SNOW || event.getCamera().getFluidInCamera() == FogType.WATER || AbyssFogEvent.isInLiquidCorruption(event.getCamera())) {
                return;
            }
            event.setFarPlaneDistance(AbyssWeatherEventClient.CLIENT_WEATHER.currentFogDistance());
            event.setNearPlaneDistance(AbyssWeatherEventClient.CLIENT_WEATHER.currentFogDistance() * 0.5f);
            event.setCanceled(true);
        }
    }

    private static boolean isInLiquidCorruption(Camera cam) {
        FluidState fluidstate = cam.getEntity().level().getFluidState(cam.getEntity().blockPosition());
        BlockPos blockpos = cam.getEntity().blockPosition();
        Vec3 pos = cam.getPosition();
        if (cam.getEntity().level().getBlockState(blockpos).is((Block)BlockRegistry.LIQUID_CORRUPTION_BLOCK.get()) && cam.getEntity().level().getBlockState(blockpos.above()).is((Block)BlockRegistry.LIQUID_CORRUPTION_BLOCK.get())) {
            return true;
        }
        return fluidstate.getFluidType() == ModFluidTypes.LIQUID_CORRUPTION.get() && pos.y < (double)((float)(blockpos.getY() + 1) + fluidstate.getHeight((BlockGetter)cam.getEntity().level(), blockpos));
    }

    public static boolean isPlayerOutside(Player player) {
        if (player.blockPosition().getY() < 30) {
            return false;
        }
        Level level = player.level();
        BlockPos playerPos = player.blockPosition();
        return AbyssFogEvent.underSkySquareRadiusCheck(player, 15) || AbyssFogEvent.underSkySquareRadiusCheck(player, 7) || AbyssFogEvent.underOpenSky(level, playerPos);
    }

    public static boolean underSkySquareRadiusCheck(Player player, int radius) {
        BlockPos playerPos;
        Level level = player.level();
        return AbyssFogEvent.underOpenSky(level, (playerPos = player.blockPosition()).offset(radius, 0, 0)) || AbyssFogEvent.underOpenSky(level, playerPos.offset(-radius, 0, 0)) || AbyssFogEvent.underOpenSky(level, playerPos.offset(0, 0, radius)) || AbyssFogEvent.underOpenSky(level, playerPos.offset(0, 0, -radius));
    }

    public static boolean underOpenSky(Level level, BlockPos pos) {
        for (int y = pos.getY(); y < Math.min(level.getMaxBuildHeight(), pos.getY() + 40); ++y) {
            BlockPos posAbove = new BlockPos(pos.getX(), y, pos.getZ());
            if (!level.getBlockState(posAbove).isCollisionShapeFullBlock((BlockGetter)level, posAbove)) continue;
            return false;
        }
        return true;
    }
}

