/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.features.custom.sculk;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import wardentools.worldgen.features.custom.sculk.AbyssSculkPatchConfiguration;
import wardentools.worldgen.features.custom.sculk.SculkTendrilsEmergence;
import wardentools.worldgen.features.custom.sculk.SculkTendrilsEmergenceConfiguration;
import wardentools.worldgen.structure.StructureUtils;

public class AbyssSculkPatch
extends Feature<AbyssSculkPatchConfiguration> {
    private static final SculkTendrilsEmergenceConfiguration TENDRIL_CONFIG = new SculkTendrilsEmergenceConfiguration(15, 0.4f, 5, 0.7f, 0.3f, true);

    public AbyssSculkPatch(Codec<AbyssSculkPatchConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<AbyssSculkPatchConfiguration> context) {
        int j;
        int i;
        BlockPos origin;
        WorldGenLevel level = context.level();
        if (StructureUtils.isInsideAnyCrystalTemple(level, origin = context.origin())) {
            return false;
        }
        if (!this.canSpreadFrom((LevelAccessor)level, origin)) {
            return false;
        }
        AbyssSculkPatchConfiguration config = (AbyssSculkPatchConfiguration)context.config();
        RandomSource random = context.random();
        SculkSpreader sculkSpreader = SculkSpreader.createWorldGenSpreader();
        int radius = config.spreadRounds() + config.growthRounds();
        for (int r = 0; r < radius; ++r) {
            for (i = 0; i < config.chargeCount(); ++i) {
                sculkSpreader.addCursors(origin, config.amountPerCharge());
            }
            boolean in = r < config.spreadRounds();
            for (j = 0; j < config.spreadAttempts(); ++j) {
                sculkSpreader.updateCursors((LevelAccessor)level, origin, random, in);
            }
            sculkSpreader.clear();
        }
        BlockPos below = origin.below();
        if (random.nextFloat() <= config.catalystChance() && level.getBlockState(below).isCollisionShapeFullBlock((BlockGetter)level, below)) {
            if (config.canHaveTendril()) {
                this.placeTendril(origin, level, random);
            } else {
                level.setBlock(origin, Blocks.SCULK_CATALYST.defaultBlockState(), 3);
            }
        }
        i = config.extraRareGrowths().sample(random);
        for (j = 0; j < i; ++j) {
            BlockPos offset = origin.offset(random.nextInt(5) - 2, 0, random.nextInt(5) - 2);
            if (!level.getBlockState(offset).isAir() || !level.getBlockState(offset.below()).isFaceSturdy((BlockGetter)level, offset.below(), Direction.UP)) continue;
            level.setBlock(offset, (BlockState)Blocks.SCULK_SHRIEKER.defaultBlockState().setValue((Property)SculkShriekerBlock.CAN_SUMMON, (Comparable)Boolean.valueOf(true)), 3);
        }
        return true;
    }

    private void placeTendril(BlockPos pos, WorldGenLevel level, RandomSource random) {
        ConfiguredFeature emergence = new ConfiguredFeature((Feature)new SculkTendrilsEmergence(SculkTendrilsEmergenceConfiguration.CODEC), (FeatureConfiguration)TENDRIL_CONFIG);
        ChunkSource chunkSource = level.getChunkSource();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            emergence.place(level, chunkCache.getGenerator(), random, pos);
        }
    }

    private boolean canSpreadFrom(LevelAccessor level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof SculkBehaviour) {
            return true;
        }
        if (!(state.isAir() || state.is(Blocks.WATER) && state.getFluidState().isSource())) {
            return false;
        }
        Stream directions = Direction.stream();
        Objects.requireNonNull(pos);
        return directions.map(arg_0 -> ((BlockPos)pos).relative(arg_0)).anyMatch(pos1 -> level.getBlockState(pos1).isCollisionShapeFullBlock((BlockGetter)level, pos1));
    }
}

