/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import doggytalents.client.entity.model.SyncedAccessoryModel;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class PropellerHatModel
extends SyncedAccessoryModel {
    public ModelPart propellar;
    public ModelPart spinna;

    public PropellerHatModel(ModelPart root) {
        super(root);
    }

    @Override
    protected void populatePart(ModelPart box) {
        this.head = Optional.of(box.getChild("head"));
        this.realHead = Optional.of(((ModelPart)this.head.get()).getChild("real_head"));
        this.propellar = ((ModelPart)this.realHead.get()).getChild("propellar");
        this.spinna = this.propellar.getChild("spin");
    }

    @Override
    public void setupAnim(Dog entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.spinna.yRot = 24.0f * ageInTicks % 360.0f * ((float)Math.PI / 180);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.5f, (float)-7.0f));
        PartDefinition real_head = head.addOrReplaceChild("real_head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition propellar = real_head.addOrReplaceChild("propellar", CubeListBuilder.create().texOffs(2, 36).addBox(-2.25f, -14.75f, -9.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)).texOffs(0, 46).addBox(-3.5f, -13.5f, -11.0f, 7.0f, 1.0f, 4.0f, new CubeDeformation(-0.05f)).texOffs(2, 41).addBox(-3.25f, -14.05f, -8.85f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)).texOffs(2, 41).mirror().addBox(1.25f, -14.025f, -8.85f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)).mirror(false).texOffs(2, 41).mirror().addBox(1.25f, -14.05f, -6.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)).mirror(false).texOffs(2, 41).addBox(-3.25f, -14.05f, -6.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)).texOffs(11, 36).addBox(0.25f, -14.75f, -9.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)).texOffs(2, 36).addBox(0.25f, -14.7f, -6.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)).texOffs(11, 36).addBox(-2.25f, -14.75f, -6.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)10.5f, (float)7.0f));
        PartDefinition spin = propellar.addOrReplaceChild("spin", CubeListBuilder.create().texOffs(20, 43).addBox(-2.9667f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(-0.8f)).texOffs(20, 36).addBox(-0.9667f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.7f)).texOffs(20, 43).mirror().addBox(-1.0667f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(-0.8f)).mirror(false), PartPose.offset((float)0.0167f, (float)-16.4f, (float)-6.8f));
        PartDefinition bone2 = propellar.addOrReplaceChild("bone2", CubeListBuilder.create().texOffs(20, 36).addBox(-0.75f, -15.75f, -9.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.8f)), PartPose.offset((float)-0.2f, (float)-1.4f, (float)1.2f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

