/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import doggytalents.client.ClientSetup;
import doggytalents.client.backward_imitate.EntityRenderer_1_21_9;
import doggytalents.client.entity.model.misc.DogPlushieModel;
import doggytalents.common.entity.misc.DogPlushie;
import doggytalents.common.lib.Resources;
import doggytalents.common.util.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.joml.Quaternionfc;

public class DogPlushieRenderer
extends EntityRenderer_1_21_9<DogPlushie> {
    private DogPlushieModel model;

    public DogPlushieRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new DogPlushieModel(ctx.bakeLayer(ClientSetup.DOG_PLUSHIE));
    }

    @Override
    public ResourceLocation getTextureLocation(DogPlushie plushie) {
        return plushie.getDogVariant().texture();
    }

    private RenderType getRenderType(DogPlushie plushie, boolean overlay) {
        if (overlay) {
            ResourceLocation collar_res = plushie.getCollarThicc() ? Resources.COLLAR_THICC : Resources.COLLAR_DEFAULT;
            return RenderType.entityTranslucent((ResourceLocation)collar_res);
        }
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(plushie));
    }

    @Override
    public void submit(DogPlushie piano, float p_114486_, float p_114487_, PoseStack stack, EntityRenderer_1_21_9.RenderContext_1_21_9<DogPlushie> context_1_21_9, int light) {
        stack.pushPose();
        stack.scale(-0.6f, -0.6f, 0.6f);
        stack.translate(0.0f, -1.05f, 0.0f);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Mth.wrapDegrees((float)piano.getYRot())));
        RenderType renderType_1_21_9 = this.getRenderType(piano, false);
        this.submitModel(context_1_21_9, this.model, renderType_1_21_9, stack, light, OverlayTexture.NO_OVERLAY, -1);
        int color = piano.getCollarColor();
        float[] arr = Util.rgbIntToFloatArray(color);
        renderType_1_21_9 = this.getRenderType(piano, true);
        this.submitModel(context_1_21_9, this.model, renderType_1_21_9, stack, light, OverlayTexture.NO_OVERLAY, ARGB.colorFromFloat((float)1.0f, (float)arr[0], (float)arr[1], (float)arr[2]));
        stack.popPose();
    }
}

