/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.widget;

import doggytalents.DoggyItems;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.common.item.AccessoryItem;
import doggytalents.common.item.DyeableAccessoryItem;
import doggytalents.common.lib.Resources;
import doggytalents.common.util.ItemUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AccessoryStatusHover
extends AbstractWidget {
    private ItemStack logoIcon = ItemStack.EMPTY;
    private ItemStack modelIcon = ItemStack.EMPTY;
    private DogModel.AccessoryState state;

    public AccessoryStatusHover(int x, int y, DogModel.AccessoryState state) {
        super(x, y, 20, 20, (Component)Component.empty());
        DyeableAccessoryItem collar = DoggyItems.WOOL_COLLAR.get();
        AccessoryItem reflector = DoggyItems.DIVINE_RETRIBUTON.get();
        this.logoIcon = new ItemStack((ItemLike)collar);
        this.modelIcon = new ItemStack((ItemLike)reflector);
        ItemUtil.setDyeColorForStack(this.logoIcon, -5231066);
        if (state == null) {
            state = DogModel.AccessoryState.HAVE_NOT_TESTED;
        } else {
            this.state = state;
        }
        this.setTooltip(this.getAccTooltip());
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        ItemStack render_icon = this.logoIcon;
        if (this.state == DogModel.AccessoryState.MODEL_ONLY) {
            render_icon = this.modelIcon;
        }
        if (render_icon == ItemStack.EMPTY) {
            return;
        }
        graphics.renderItem(render_icon, this.getX() + 1, this.getY() + 1);
        int iX = this.getIconXState();
        ScreenUtil.blit_21_3(graphics, Resources.STYLE_ADD_REMOVE, this.getX() + 11, this.getY() + 11, iX, 0, 9, 9);
    }

    private int getIconXState() {
        switch (this.state) {
            case HAVE_NOT_TESTED: {
                return 33;
            }
            case NON_COMPATIBLE: {
                return 44;
            }
            case RECOMMENDED: {
                return 55;
            }
            case SOME_WILL_FIT: 
            case MODEL_ONLY: {
                return 22;
            }
        }
        return 33;
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    private Tooltip getAccTooltip() {
        int id = 0;
        switch (this.state) {
            case HAVE_NOT_TESTED: {
                id = 0;
                break;
            }
            case NON_COMPATIBLE: {
                id = 1;
                break;
            }
            case RECOMMENDED: {
                id = 2;
                break;
            }
            case SOME_WILL_FIT: {
                id = 3;
                break;
            }
            case MODEL_ONLY: {
                id = 4;
                break;
            }
        }
        return Tooltip.create((Component)Component.translatable((String)("doggui.style.skins.accessory_state." + id)));
    }
}

