/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.DogSounds;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.LangUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.damagesource.DamageSource;
import org.apache.commons.lang3.tuple.Pair;

public class DogMoodManager {
    private final Dog dog;
    private int happiness = 0;
    private int toUpdateTimestamp = 0;
    private static final List<Supplier<SoundEvent>> minor_ambient = List.of(DogSounds.ANGRY_BARK3, DogSounds.ANGRY_BARK2, DogSounds.ANGRY_BARK1, DogSounds.CUTE_GROWL1, DogSounds.CUTE_GROWL3, DogSounds.PUGLIN_GROWL3, DogSounds.CUTE_PANTING);
    private static final List<Supplier<SoundEvent>> perfect_neutral_ambient = List.of(DogSounds.CLASSIC_BARK1, DogSounds.CLASSIC_BARK2, DogSounds.CLASSIC_BARK3, DogSounds.CLASSIC_PANTING);
    private static final WeightedList<Supplier<SoundEvent>> augmented_neutral_ambient = WeightedList.of((Weighted[])new Weighted[]{new Weighted(DogSounds.GRUMPY_BARK2, 6), new Weighted(DogSounds.GRUMPY_BARK3, 6), new Weighted(DogSounds.CUTE_BARK1, 4), new Weighted(DogSounds.CUTE_BARK3, 4), new Weighted(DogSounds.PUGLIN_BARK2, 1)});
    private static final List<Supplier<SoundEvent>> major_ambient = List.of(DogSounds.SAD_BARK1, DogSounds.PUGLIN_BARK2, DogSounds.PUGLIN_BARK3, DogSounds.GRUMPY_BARK1, DogSounds.CUTE_BARK2, DogSounds.CUTE_BARK1, DogSounds.CUTE_BARK3, DogSounds.GRUMPY_BARK2, DogSounds.GRUMPY_BARK3);
    private float recordedHealth = 0.0f;
    private int lastHurt = 0;
    private boolean chainHurt = false;
    private static final List<Supplier<SoundEvent>> forte_hurt = List.of(DogSounds.ANGRY_HURT3, DogSounds.ANGRY_HURT2, DogSounds.GRUMPY_HURT1, DogSounds.CLASSIC_HURT1, DogSounds.CLASSIC_HURT2, DogSounds.CLASSIC_HURT3, DogSounds.BIG_HURT3, DogSounds.CUTE_HURT3);
    private static final List<Supplier<SoundEvent>> piano_hurt = List.of(DogSounds.BIG_HURT1, DogSounds.SAD_HURT1, DogSounds.PUGLIN_HURT1, DogSounds.PUGLIN_HURT2);
    private static final List<Supplier<SoundEvent>> tremolo_hurt = List.of(DogSounds.CLASSIC_HURT1, DogSounds.CLASSIC_HURT2, DogSounds.CLASSIC_HURT3, DogSounds.CUTE_HURT3);
    private static final List<Supplier<SoundEvent>> death_sounds_non_tremolo = List.of(DogSounds.ANGRY_HURT1, DogSounds.CLASSIC_DEATH, DogSounds.SAD_DEATH);
    private static final List<Supplier<SoundEvent>> death_sounds = List.of(DogSounds.CLASSIC_DEATH, DogSounds.SAD_DEATH);
    private static final List<Supplier<SoundEvent>> injured_ambient = List.of(DogSounds.CLASSIC_WHINE, DogSounds.SAD_WHINE, DogSounds.CUTE_PANTING);
    private static final List<Supplier<SoundEvent>> serious_growl = List.of(DogSounds.ANGRY_GROWL2, DogSounds.ANGRY_GROWL3, DogSounds.PUGLIN_GROWL1, DogSounds.GRUMPY_GROWL3);
    private static final List<Supplier<SoundEvent>> sneeze_sounds = List.of(DogSounds.SAD_BARK3, DogSounds.SAD_HURT3_ALT);
    private static final WeightedList<Supplier<SoundEvent>> greet_whine = WeightedList.of((Weighted[])new Weighted[]{new Weighted(DogSounds.CLASSIC_WHINE, 3), new Weighted(DogSounds.SAD_WHINE, 3), new Weighted(DogSounds.PUGLIN_WHINE, 1), new Weighted(DogSounds.CUTE_WHINE, 1)});
    private static final List<Supplier<SoundEvent>> jealous_sound = List.of(DogSounds.CUTE_WHINE, DogSounds.ANGRY_WHINE, DogSounds.BIG_WHINE);
    private static final List<Supplier<SoundEvent>> down_the_hole = List.of(DogSounds.CUTE_BARK1, DogSounds.GRUMPY_BARK1, DogSounds.SAD_BARK1);
    private static final List<Supplier<SoundEvent>> aww_sound = List.of(DogSounds.CUTE_HURT1_ALT, DogSounds.CLASSIC_WHINE, DogSounds.SAD_HURT2_ALT);
    private static final List<Supplier<SoundEvent>> whine_attention = List.of(DogSounds.PUGLIN_WHINE, DogSounds.SAD_WHINE, DogSounds.ANGRY_WHINE);
    private static final List<Supplier<SoundEvent>> protest_sound = List.of(DogSounds.GRUMPY_GROWL1, DogSounds.CUTE_GROWL2, DogSounds.GRUMPY_WHINE, DogSounds.CUTE_WHINE);
    private static final List<Supplier<SoundEvent>> petting_ambient = List.of(DogSounds.BIG_WHINE, DogSounds.BIG_PANTING, DogSounds.ANGRY_PANTING, DogSounds.CLASSIC_PANTING);
    private static final List<Supplier<SoundEvent>> sniffer_dog_forte = List.of(DogSounds.SAD_GROWL2, DogSounds.GRUMPY_HURT2_ALT);
    private static final List<Supplier<SoundEvent>> sniffer_dog_piano = List.of(DogSounds.CLASSIC_BARK1, DogSounds.CLASSIC_BARK2, DogSounds.CLASSIC_BARK3);
    private static Set<SoundEvent> force_interruptible_sounds = null;

    public DogMoodManager(Dog dog) {
        this.dog = dog;
    }

    public void tickServer() {
        if (this.dog.tickCount >= this.toUpdateTimestamp) {
            this.toUpdateTimestamp = this.dog.tickCount + this.getUpdateInterval();
            this.happiness = this.getNextMood();
        }
    }

    private int getNextMood() {
        float away_from_normal = 0.04f;
        int ret = 0;
        if (this.dog.getRandom().nextFloat() <= 0.04f) {
            ret = this.dog.getRandom().nextBoolean() ? 1 : -1;
            int non_normal_time = this.getUpdateInterval() * this.getNonNormalTime();
            this.toUpdateTimestamp = this.dog.tickCount + non_normal_time;
        }
        return ret;
    }

    public int getNonNormalTime() {
        float split = 0.8f;
        int split_map = 6;
        int max_time = 15;
        float r = this.dog.getRandom().nextFloat();
        if (r < 0.8f) {
            int ret = Mth.floor((float)(r / 0.8f * 6.0f));
            return 1 + Mth.clamp((int)ret, (int)0, (int)15);
        }
        int ret = 6 + Mth.floor((float)((r - 0.8f) / 0.19999999f * 9.0f));
        return 1 + Mth.clamp((int)ret, (int)0, (int)15);
    }

    public int getHappiness() {
        return this.happiness;
    }

    public int getUpdateInterval() {
        return 400;
    }

    public SoundEvent getAmbientSound() {
        boolean is_aug;
        if (this.dog.level().isClientSide) {
            return DogSounds.CLASSIC_BARK1.get();
        }
        int current_diff = this.happiness;
        List<Supplier<SoundEvent>> selected_list = perfect_neutral_ambient;
        if (current_diff != 0) {
            float non_neutral_chance = current_diff < 0 ? 0.5f : 0.9f;
            float r = this.dog.getRandom().nextFloat();
            if (r < non_neutral_chance) {
                selected_list = current_diff > 0 ? major_ambient : minor_ambient;
            }
        }
        float aug_chance = 0.1f;
        if (this.happiness < 0) {
            aug_chance = 0.01f;
        } else if (this.happiness > 0) {
            aug_chance = 0.5f;
        }
        boolean bl = is_aug = selected_list == perfect_neutral_ambient && this.dog.getRandom().nextFloat() <= aug_chance;
        if (is_aug) {
            return (SoundEvent)((Supplier)augmented_neutral_ambient.getRandom(this.dog.getRandom()).get()).get();
        }
        return LangUtil.getRandomItem(this.dog.getRandom(), selected_list).get().get();
    }

    public void onStartHurting(float current_health) {
        this.recordedHealth = this.dog.getHealth();
        this.chainHurt = this.dog.tickCount - this.lastHurt <= 16;
        this.lastHurt = this.dog.tickCount;
    }

    public SoundEvent getHurtSound(DamageSource source) {
        boolean chain_hurt;
        List<Supplier<SoundEvent>> hurt_list = piano_hurt;
        if (this.recordedHealth - this.dog.getHealth() >= 4.0f) {
            hurt_list = forte_hurt;
        }
        if (chain_hurt = this.chainHurt) {
            hurt_list = tremolo_hurt;
        }
        return LangUtil.getRandomItem(this.dog.getRandom(), hurt_list).get().get();
    }

    public SoundEvent getLowHealthWhine() {
        return DogSounds.CLASSIC_WHINE.get();
    }

    public SoundEvent getDeathSound() {
        return LangUtil.getRandomItem(this.dog.getRandom(), this.chainHurt ? death_sounds : death_sounds_non_tremolo).get().get();
    }

    public SoundEvent getInjuredAmbient() {
        return LangUtil.getRandomItem(this.dog.getRandom(), injured_ambient).get().get();
    }

    public SoundEvent getSeriousGrowl() {
        return LangUtil.getRandomItem(this.dog.getRandom(), serious_growl).get().get();
    }

    public SoundEvent getSniffSound() {
        return DogSounds.SAD_PANTING.get();
    }

    public SoundEvent getSneezeSound() {
        return LangUtil.getRandomItem(this.dog.getRandom(), sneeze_sounds).get().get();
    }

    public SoundEvent getGreetWhine() {
        return (SoundEvent)((Supplier)greet_whine.getRandom(this.dog.getRandom()).get()).get();
    }

    public SoundEvent getJealousSound() {
        return LangUtil.getRandomItem(this.dog.getRandom(), jealous_sound).get().get();
    }

    public SoundEvent getDownTheHoleSound() {
        return LangUtil.getRandomItem(this.dog.getRandom(), down_the_hole).get().get();
    }

    public SoundEvent getAwwSound() {
        return LangUtil.getRandomItem(this.dog.getRandom(), aww_sound).get().get();
    }

    public SoundEvent getWhineAttentionSound() {
        return LangUtil.getRandomItem(this.dog.getRandom(), whine_attention).get().get();
    }

    public SoundEvent getProtestSound() {
        return LangUtil.getRandomItem(this.dog.getRandom(), protest_sound).get().get();
    }

    public Pair<SoundEvent, Boolean> getPettingAmbient() {
        float r = this.dog.getRandom().nextFloat();
        SoundEvent sound = null;
        sound = r <= 0.2f ? DogSounds.CLASSIC_WHINE.get() : LangUtil.getRandomItem(this.dog.getRandom(), petting_ambient).get().get();
        boolean is_classic = sound == DogSounds.CLASSIC_PANTING.get() || sound == DogSounds.CLASSIC_WHINE.get();
        return Pair.of((Object)sound, (Object)is_classic);
    }

    public SoundEvent getSnifferDogForteSound() {
        return LangUtil.getRandomItem(this.dog.getRandom(), sniffer_dog_forte).get().get();
    }

    public SoundEvent getSnifferDogPianoSound() {
        return LangUtil.getRandomItem(this.dog.getRandom(), sniffer_dog_piano).get().get();
    }

    public boolean isForceInteruptibleSound(SoundEvent sound) {
        if (force_interruptible_sounds == null) {
            force_interruptible_sounds = new HashSet<SoundEvent>(List.of(DogSounds.CUTE_PANTING.get(), DogSounds.SAD_WHINE.get()));
        }
        return force_interruptible_sounds.contains(sound);
    }
}

