/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.accessory;

import doggytalents.DoggyAccessoryTypes;
import doggytalents.DoggyItems;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.render.AccessoryModelManager;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.AccessoryModelRenderEntries;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.IAccessoryHasModel;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BunnyEars
extends Accessory
implements IAccessoryHasModel {
    public BunnyEars(Supplier<? extends ItemLike> itemIn) {
        super(DoggyAccessoryTypes.HORN, itemIn);
    }

    @Override
    public AccessoryModelManager.Entry getRenderEntry() {
        return AccessoryModelRenderEntries.BUNNY_EARS;
    }

    @Override
    public AccessoryInstance getDefault() {
        return new Inst(this);
    }

    public static class Inst
    extends AccessoryInstance
    implements IDogAlteration {
        public Inst(Accessory typeIn) {
            super(typeIn);
        }

        @Override
        public void doAdditionalAttackEffects(AbstractDog dogIn, Entity target) {
            if (target == null || target.isAlive()) {
                return;
            }
            this.mayDropCandy(dogIn, target);
        }

        public void mayDropCandy(AbstractDog dog, Entity target) {
            float r = dog.getRandom().nextFloat();
            float chance = 0.15f;
            if (r > 0.15f) {
                return;
            }
            Item item = DoggyItems.EASTER_EGG_CANDY.get();
            dog.spawnAtLocation((ServerLevel)dog.level(), new ItemStack((ItemLike)item), 0.0f);
        }
    }
}

