/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogProtestSitOrderGoal
extends Goal {
    private final int MIN_TOLERABLE_SPAM_TIME = 3;
    private Dog dog;
    private int lastOrderedToSitTick0;
    private int spamTime = 0;
    private int spamTimeMax = 3;
    private int stopAnimTick;
    private int animTick = 0;

    public DogProtestSitOrderGoal(Dog dog) {
        this.dog = dog;
        this.spamTimeMax = 3 + dog.getRandom().nextInt(4);
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.updateDetectSpamSit();
        if (!this.dog.onGround()) {
            return false;
        }
        if (this.dog.isVehicle()) {
            return false;
        }
        if (this.spamTime >= this.spamTimeMax) {
            this.spamTime = 0;
            return true;
        }
        return false;
    }

    public void start() {
        this.dog.setAnim(DogAnimation.PROTEST);
        if (!this.dog.isInSittingPose()) {
            this.dog.setSitAnim(DogAnimation.NONE);
        }
        this.dog.setProtesting(true);
        this.dog.setOrderedToSit(true);
        this.stopAnimTick = this.dog.tickCount + DogAnimation.PROTEST.getLengthTicks();
        this.animTick = 0;
    }

    public void tick() {
        LivingEntity owner = this.dog.getOwner();
        if (owner == null) {
            return;
        }
        if (owner.distanceToSqr((Entity)this.dog) > 25.0) {
            return;
        }
        this.dog.getLookControl().setLookAt((Entity)owner, 10.0f, (float)this.dog.getMaxHeadXRot());
        ++this.animTick;
        if (this.animTick == 32) {
            SoundEvent sound = this.dog.dogMood.getProtestSound();
            this.dog.dogSoundManager.playInterruptible(sound, this.dog.getSoundVolume(), this.dog.getVoicePitch());
        }
    }

    public void stop() {
        if (this.dog.getAnim() == DogAnimation.PROTEST) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        if (this.dog.getSitAnim() == DogAnimation.NONE) {
            this.dog.setSitAnim(null);
        }
        this.dog.setProtesting(false);
        this.spamTimeMax = 3 + this.dog.getRandom().nextInt(4);
        this.dog.dogSoundManager.interuptPlaying();
    }

    public boolean canContinueToUse() {
        return this.dog.isOrderedToSit() && this.dog.tickCount <= this.stopAnimTick;
    }

    private void updateDetectSpamSit() {
        if (this.dog.lastOrderedToSitTick != this.lastOrderedToSitTick0) {
            int interval = Math.abs(this.dog.lastOrderedToSitTick - this.lastOrderedToSitTick0);
            this.spamTime = interval <= this.getSpamInterval() ? ++this.spamTime : 0;
            this.lastOrderedToSitTick0 = this.dog.lastOrderedToSitTick;
        }
    }

    private int getSpamInterval() {
        return 45;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

