/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.HoverTextAppender_1_21_5;
import doggytalents.client.screen.CanineTrackerScreen;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CanineTrackerItem
extends Item
implements HoverTextAppender_1_21_5 {
    public CanineTrackerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (!worldIn.isClientSide) {
            if (stack.getItem() instanceof CanineTrackerItem && ItemUtil.hasTag(stack)) {
                ItemUtil.clearTag(stack);
            }
        } else if (!ItemUtil.hasTag(stack)) {
            CanineTrackerScreen.open();
        }
        return InteractionResult.FAIL;
    }

    public Component getName(ItemStack stack) {
        Component text;
        if (ItemUtil.hasTag(stack) && (text = this.getStatusText(ItemUtil.getTag(stack))) != null) {
            return text;
        }
        return Component.translatable((String)this.getDescriptionId());
    }

    @Nullable
    private Component getStatusText(CompoundTag_1_21_5 tag) {
        if (tag == null) {
            return null;
        }
        if (!tag.contains("name", 8)) {
            return null;
        }
        MutableComponent ret = Component.translatable((String)"item.doggytalents.radar.status", (Object[])new Object[]{tag.getString("name")});
        int ret_color = -5586;
        if (tag.contains("locateColor", 3)) {
            int tag_color = tag.getInt("locateColor");
            ret_color = tag_color != 0 ? tag_color : ret_color;
        }
        return ret.withStyle(Style.EMPTY.withColor(ret_color));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flags) {
        String desc_id = this.getDescriptionId() + ".description";
        components.add((Component)Component.translatable((String)desc_id).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
    }
}

