/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.texture.DogSkinData;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogTextureData;
import doggytalents.common.util.DogUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;

public class DogTexturePacket
extends DogPacket<DogTextureData> {
    @Override
    public void encode(DogTextureData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeUtf(data.hash);
    }

    @Override
    public DogTextureData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        String texture = buf.readUtf(128);
        return new DogTextureData(entityId, texture);
    }

    @Override
    public void handleDog(Dog dogIn, DogTextureData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        if (!dogIn.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        if (!DogUtil.vertifySkinData(data.hash)) {
            return;
        }
        dogIn.setDogSkinData(new DogSkinData(data.hash, DogSkinData.Version.VERSION_0));
    }
}

