/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyItems;
import doggytalents.DoggyTalents;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogSleepOnManager;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.PlayerUtil;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BedDogTalent
extends TalentInstance {
    private long cooldownDealine = 0L;

    public BedDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    public void onSuccessfulSleep(AbstractDog dog) {
        float base_threshold;
        Level level = dog.level();
        this.cooldownDealine = level.getDayTime() + (long)this.getCooldownTicks();
        float set_hunger = dog.getDogHunger();
        if (set_hunger > (base_threshold = (float)this.getBaseMinHungerForSleep()) && (set_hunger -= (float)this.getHungerCostPerSleep()) < base_threshold) {
            set_hunger = base_threshold;
        }
        dog.setDogHunger(set_hunger);
    }

    public boolean isOnCooldown(AbstractDog dog) {
        Level level = dog.level();
        return level.getDayTime() < this.cooldownDealine;
    }

    public int getCooldownDaysLeft(AbstractDog dog) {
        Level level = dog.level();
        long time_till = this.cooldownDealine - level.getDayTime();
        if (time_till <= 0L) {
            return 0;
        }
        return Mth.ceil((float)((float)time_till / 24000.0f));
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        this.cooldownDealine = compound.getLong("cooldown_end");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.putLong("cooldown_end", this.cooldownDealine);
    }

    @Override
    public boolean allowDetrain(AbstractDog dog) {
        return !this.isOnCooldown(dog);
    }

    public static void useBedDog(Level level, Player player) {
        if (level.isClientSide) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30, filter_dog -> filter_dog.isDoingFine());
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        if (dog.getDogLevel(DoggyTalents.BED_DOG) <= 0) {
            return;
        }
        DogSleepOnManager.StartSleepOnDogResult result = DogSleepOnManager.getServer(level.getServer()).setOrRequestSleepOn(dog, player);
        BedDogTalent.proccessResult(result, dog, player);
        if (result.isFailMsg(DogSleepOnManager.DogSleepOnFailMessage.NO_POS)) {
            PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 10);
        }
    }

    private static void proccessResult(DogSleepOnManager.StartSleepOnDogResult result, Dog dog, Player player) {
        if (result.ok() || result.other()) {
            return;
        }
        if (result.isFailMsg(DogSleepOnManager.DogSleepOnFailMessage.COOLDOWN)) {
            BedDogTalent.sendCooldownMsg(dog, player);
            return;
        }
        PlayerUtil.sendSystemMessage((LivingEntity)player, result.failMsg().getMsg(dog));
    }

    private static void sendCooldownMsg(Dog dog, Player player) {
        Optional<BedDogTalent> inst_optional = dog.getTalent(DoggyTalents.BED_DOG.get(), BedDogTalent.class);
        if (!inst_optional.isPresent()) {
            return;
        }
        BedDogTalent inst = inst_optional.get();
        PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"talent.doggytalents.bed_dog.fail.cooldown", (Object[])new Object[]{dog.getName().getString(), Integer.toString(inst.getCooldownDaysLeft(dog))}));
    }

    public static DogSleepOnManager.StartSleepOnDogResult isSleepCondition(Dog dog, BedDogTalent inst) {
        if (dog.getDogHunger() < (float)inst.getMinHungerForSleep()) {
            return DogSleepOnManager.DogSleepOnFailMessage.DOG_LOW_HUNGER.asResult();
        }
        if (inst.isOnCooldown(dog)) {
            return DogSleepOnManager.DogSleepOnFailMessage.COOLDOWN.asResult();
        }
        return DogSleepOnManager.StartSleepOnDogResult.OK;
    }

    public int getHungerCostPerSleep() {
        int level = this.level();
        if (level <= 3) {
            return 40;
        }
        if (level == 4) {
            return 30;
        }
        return 0;
    }

    public int getMinHungerForSleep() {
        return this.getHungerCostPerSleep() + this.getBaseMinHungerForSleep();
    }

    public int getBaseMinHungerForSleep() {
        return 20;
    }

    public int getCooldownTicks() {
        int level = this.level();
        if (level <= 3) {
            return 72000;
        }
        if (level == 4) {
            return 48000;
        }
        return 0;
    }
}

