/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.InteractionResultHolder;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.EntityUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class HellHoundTalent
extends TalentInstance {
    private final int SEARCH_RANGE = 3;
    private int tickUntilSearch = 0;
    private int fireResistTickLeft = 60;
    private int fireResistHealCooldown = 0;
    private int meltCooldown = 30;
    private int meltingModeDuration = 0;

    public HellHoundTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public InteractionResultHolder<Float> calculateFallDistance(AbstractDog dogIn, float distance) {
        if (this.level() >= 5 && dogIn.isInLava()) {
            return InteractionResultHolder.success(Float.valueOf(0.0f));
        }
        return super.calculateFallDistance(dogIn, distance);
    }

    @Override
    public InteractionResultHolder<Integer> setFire(AbstractDog dogIn, int ticks) {
        if (dogIn.isOnFire()) {
            return InteractionResultHolder.pass(ticks);
        }
        return InteractionResultHolder.success(Mth.floor((float)((float)ticks * this.getFireDecreasePercentage())));
    }

    private float getFireDecreasePercentage() {
        if (this.level() <= 0 || this.level() >= 5) {
            return 1.0f;
        }
        switch (this.level()) {
            default: {
                return 1.0f;
            }
            case 1: {
                return 0.9f;
            }
            case 2: {
                return 0.8f;
            }
            case 3: {
                return 0.5f;
            }
            case 4: 
        }
        return 0.25f;
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        if (this.level() >= 5) {
            props.setFireImmune();
        }
    }

    @Override
    public DogInteractionResult isInvulnerableTo(AbstractDog dogIn, DamageSource source) {
        if (source.is(DamageTypeTags.IS_FIRE)) {
            return this.level() >= 5 ? DogInteractionResult.SUCCESS : DogInteractionResult.PASS;
        }
        if (source.is(DamageTypeTags.IS_FREEZING)) {
            return this.level() >= 5 ? DogInteractionResult.SUCCESS : DogInteractionResult.PASS;
        }
        return DogInteractionResult.PASS;
    }

    @Override
    public void doInitialAttackEffects(AbstractDog dogIn, Entity entity) {
        if (this.level() >= 5) {
            EntityUtil.setSecondsOnFire(entity, 15);
        } else if (this.level() >= 4) {
            EntityUtil.setSecondsOnFire(entity, 4);
        }
    }

    @Override
    public DogInteractionResult canResistPushFromFluidType(FluidType type) {
        if (type != NeoForgeMod.LAVA_TYPE.value()) {
            return DogInteractionResult.PASS;
        }
        if (this.level() >= 5) {
            return DogInteractionResult.SUCCESS;
        }
        return DogInteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<Float> gettingAttackedFrom(AbstractDog dog, DamageSource source, float damage) {
        if (!source.is(DamageTypeTags.IS_FIRE)) {
            return InteractionResultHolder.pass(Float.valueOf(damage));
        }
        int resistValue = this.getResistValue(source);
        this.fireResistHealCooldown = 80;
        this.fireResistTickLeft = Math.min(this.fireResistTickLeft, resistValue);
        if (this.fireResistTickLeft > 0) {
            return InteractionResultHolder.fail(Float.valueOf(0.0f));
        }
        this.fireResistTickLeft = resistValue;
        return InteractionResultHolder.pass(Float.valueOf(this.getFireDamageReduced(source, damage)));
    }

    private float getFireDamageReduced(DamageSource source, float amount) {
        if (source.is(DamageTypes.LAVA)) {
            if (this.level() >= 4) {
                return 1.0f;
            }
            if (this.level() >= 3) {
                return 2.0f;
            }
            return Math.max(0.0f, 1.0f - (float)this.level() * 0.25f) * amount;
        }
        return 1.0f;
    }

    private int getMaxAccumulate() {
        if (this.level() <= 2) {
            return this.level() + 1;
        }
        if (this.level() <= 3) {
            return this.level() + 3;
        }
        return this.level() + 10;
    }

    private int getResistValue(DamageSource source) {
        if (this.level() >= 4) {
            return this.getMaxAccumulate() * 20;
        }
        if (source.is(DamageTypes.LAVA)) {
            return this.getMaxAccumulate() * 10;
        }
        if (source.is(DamageTypes.IN_FIRE)) {
            return this.getMaxAccumulate() * 15;
        }
        return this.getMaxAccumulate() * 20;
    }

    public boolean canGenerateHeat() {
        return this.level() >= 4;
    }

    @Override
    public DogInteractionResult shouldNotAfraidOfFire(AbstractDog dog) {
        if (this.level() < 3) {
            return DogInteractionResult.PASS;
        }
        return DogInteractionResult.SUCCESS;
    }

    @Override
    public DogInteractionResult stillIdleOrSitWhenHurt(AbstractDog dog, DamageSource source, float amount) {
        if (this.level() >= 4 && source.is(DamageTypeTags.IS_FIRE)) {
            return DogInteractionResult.SUCCESS;
        }
        if (source.is(DamageTypes.ON_FIRE)) {
            return DogInteractionResult.SUCCESS;
        }
        return DogInteractionResult.PASS;
    }

    @Override
    public void tick(AbstractDog d) {
        if (d.level().isClientSide) {
            return;
        }
        if (this.level() < 5) {
            this.updateResistValues();
            return;
        }
        if (!(d instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)d;
        if (dog != null && dog.isShakingLava() && (double)dog.getTimeDogIsShaking() > 0.8 && --this.tickUntilSearch <= 0) {
            this.tickUntilSearch = 10;
            this.fireSpreadToEnermies(dog);
        }
        this.meltPoweredSnowIfFreeze(dog);
    }

    private void updateResistValues() {
        if (this.fireResistHealCooldown > 0) {
            --this.fireResistHealCooldown;
        }
        if (this.fireResistHealCooldown <= 0) {
            this.fireResistTickLeft = 60;
            return;
        }
        if (this.fireResistTickLeft > 0) {
            --this.fireResistTickLeft;
        }
    }

    private void fireSpreadToEnermies(AbstractDog dog) {
        List targets = dog.level().getEntitiesOfClass(LivingEntity.class, dog.getBoundingBox().inflate(3.0, 2.0, 3.0));
        for (LivingEntity x : targets) {
            if (!(x instanceof Enemy)) continue;
            EntityUtil.setSecondsOnFire((Entity)x, 5);
        }
    }

    private void meltPoweredSnowIfFreeze(AbstractDog dog) {
        if (this.meltCooldown > 0) {
            --this.meltCooldown;
        }
        if (dog.isInPowderSnow) {
            this.meltingModeDuration = 100;
        } else if (this.meltingModeDuration > 0) {
            --this.meltingModeDuration;
        }
        if (!dog.isInPowderSnow && this.meltingModeDuration <= 0) {
            return;
        }
        if (dog.isVehicle()) {
            return;
        }
        if (this.meltCooldown > 0) {
            return;
        }
        this.meltCooldown = 30;
        AABB bb = dog.getBoundingBox().inflate(1.0);
        Iterable block_itr = BlockPos.betweenClosed((BlockPos)BlockPos.containing((double)bb.minX, (double)bb.minY, (double)bb.minZ), (BlockPos)BlockPos.containing((double)bb.maxX, (double)bb.maxY, (double)bb.maxZ));
        boolean melted = false;
        for (BlockPos pos : block_itr) {
            BlockState state = dog.level().getBlockState(pos);
            if (!state.is(Blocks.POWDER_SNOW)) continue;
            melted = true;
            dog.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
        if (melted) {
            dog.playSound(SoundEvents.FIRE_EXTINGUISH, 0.5f, 2.6f + dog.getRandom().nextFloat() - dog.getRandom().nextFloat() * 0.8f);
            Level level = dog.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, dog.getX(), dog.getY(), dog.getZ(), 30, (double)dog.getBbWidth(), (double)0.8f, (double)dog.getBbWidth(), 0.1);
            }
        }
    }
}

