/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.InteractionResultHolder;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.InferTypeContext;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.config.ConfigHandler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.pathfinder.PathType;

public class SwimmerDogTalent
extends TalentInstance {
    public SwimmerDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        LivingEntity control;
        if (abstractDog.level().isClientSide) {
            return;
        }
        if (this.level() >= 5 && abstractDog.isVehicle() && (control = abstractDog.getControllingPassenger()) != null && control.isInWater() && ((Boolean)ConfigHandler.SERVER.SWIMMER_DOG_RIDER_WATER_VISION.get()).booleanValue()) {
            control.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 40, 0, true, false));
        }
    }

    @Override
    public DogInteractionResult canBeRiddenInWater(AbstractDog dogIn) {
        return this.level() >= 2 ? DogInteractionResult.SUCCESS : DogInteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<Integer> decreaseAirSupply(AbstractDog dogIn, int air) {
        if (this.level() > 0 && dogIn.getRandom().nextInt(this.level() + 1) > 0) {
            return InteractionResultHolder.success(air);
        }
        return InteractionResultHolder.pass(air);
    }

    @Override
    public InteractionResultHolder<Integer> determineNextAir(AbstractDog dogIn, int currentAir) {
        if (this.level() > 0) {
            return InteractionResultHolder.pass(currentAir + this.level());
        }
        return InteractionResultHolder.pass(currentAir);
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setCanSwimUnderwater();
        if (this.level() >= 5) {
            props.setCanBreatheUnderwater();
        }
        if (this.level() > 1) {
            props.addBonusSwimSpeed(Mth.clamp((int)this.level(), (int)2, (int)5) * 2);
        }
        if (this.level() >= 2) {
            props.setResistWaterPush();
        }
    }

    @Override
    public InteractionResultHolder<PathType> inferType(AbstractDog dog, PathType type, InferTypeContext context) {
        if (this.level() < this.getTalent().getMaxLevel() && type == PathType.WATER && this.checkOverrideWalkableForWater(context)) {
            return InteractionResultHolder.success(PathType.WALKABLE);
        }
        return super.inferType(dog, type, context);
    }

    public boolean checkOverrideWalkableForWater(InferTypeContext context) {
        if (!context.teleport()) {
            return true;
        }
        LivingEntity owner = context.owner().orElse(null);
        if (owner == null) {
            return false;
        }
        return owner.isInWater();
    }
}

