/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.dog;

import doggytalents.api.anim.DogAnimation;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.backward_imitate.DogRenderState_21_3;
import doggytalents.client.backward_imitate.IBaseDogModel_21_3;
import doggytalents.client.backward_imitate.ModelUtil_1_21_9;
import doggytalents.client.entity.model.animation.DogAnimationRegistry;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.client.entity.model.dog.DogPoseSetups;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.entity.anim.DogAnimationState;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.util.Util;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_7184;
import net.minecraft.class_9848;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class DogModel
extends class_583<DogRenderState_21_3>
implements IBaseDogModel_21_3 {
    public static final float[] MANE_LYING_OFF = new float[]{0.0f, 6.0f, 1.0f};
    public static final float[] MANE_SITTING_OFF = new float[]{0.0f, 2.0f, 0.0f};
    public static final float[] TAIL_LYING_OFF = new float[]{0.0f, 6.0f, 0.0f};
    public static final float[] TAIL_SITTING_OFF = new float[]{0.0f, 9.0f, -2.0f};
    public static final Vector3f DEFAULT_ROOT_PIVOT = new Vector3f(0.0f, 15.0f, 0.0f);
    public class_630 head;
    public class_630 realHead;
    public class_630 body;
    public class_630 mane;
    public class_630 legBackRight;
    public class_630 legBackLeft;
    public class_630 legFrontRight;
    public class_630 legFrontLeft;
    public class_630 tail;
    public class_630 realTail;
    public class_630 root;
    public Optional<class_630> earLeft;
    public Optional<class_630> earRight;
    Vector3f vecObj = new Vector3f();
    private float headXRot0 = 0.0f;
    private float headYRot0 = 0.0f;
    private float realHeadZRot0 = 0.0f;
    private AccessoryState accessoryState = AccessoryState.HAVE_NOT_TESTED;
    protected float wetShade = 1.0f;
    public boolean young;

    public DogModel(class_630 box) {
        super(box);
        this.initDogModel(box);
    }

    public DogModel(class_630 box, Function<class_2960, class_1921> renderType) {
        super(box, renderType);
        this.initDogModel(box);
    }

    protected void initDogModel(class_630 box) {
        this.populateMandatoryParts(box);
        this.addOptionalParts(box);
        this.correctInitalPose();
    }

    private final void populateMandatoryParts(class_630 box) {
        this.root = box;
        this.head = box.method_32086("head");
        this.realHead = this.head.method_32086("real_head");
        this.body = box.method_32086("body");
        this.mane = box.method_32086("upper_body");
        this.legBackRight = box.method_32086("right_hind_leg");
        this.legBackLeft = box.method_32086("left_hind_leg");
        this.legFrontRight = box.method_32086("right_front_leg");
        this.legFrontLeft = box.method_32086("left_front_leg");
        this.tail = box.method_32086("tail");
        this.realTail = this.tail.method_32086("real_tail");
    }

    protected void addOptionalParts(class_630 box) {
        this.earLeft = this.getChildIfPresent(this.realHead, "left_ear");
        this.earRight = this.getChildIfPresent(this.realHead, "right_ear");
    }

    protected Optional<class_630> getChildIfPresent(class_630 box, String name) {
        if (!box.method_41919(name)) {
            return Optional.empty();
        }
        return Optional.of(box.method_32086(name));
    }

    protected void correctInitalPose() {
        class_5603 tailPose = this.tail.method_41921();
        float tailX = tailPose.comp_2997();
        float tailY = tailPose.comp_2998();
        float tailZ = tailPose.comp_2999();
        this.tail.method_41918(class_5603.method_32090((float)tailX, (float)tailY, (float)tailZ));
    }

    public static class_5607 createBodyLayer() {
        return DogModel.createBodyLayerInternal(class_5605.field_27715);
    }

    private static class_5607 createBodyLayerInternal(class_5605 scale) {
        class_5609 var0 = new class_5609();
        class_5610 var1 = var0.method_32111();
        float var2 = 13.5f;
        class_5610 var3 = var1.method_32117("head", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)13.5f, (float)-7.0f));
        class_5610 real_head = var3.method_32117("real_head", class_5606.method_32108().method_32101(0, 0).method_32098(-3.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, scale).method_32101(0, 10).method_32098(-1.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, scale), class_5603.field_27701);
        real_head.method_32117("right_ear", class_5606.method_32108().method_32101(16, 14).method_32098(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new class_5605(0.0f)), class_5603.method_32090((float)-2.0f, (float)-3.0f, (float)0.5f));
        real_head.method_32117("left_ear", class_5606.method_32108().method_32101(16, 14).method_32098(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new class_5605(0.0f)), class_5603.method_32090((float)2.0f, (float)-3.0f, (float)0.5f));
        var1.method_32117("body", class_5606.method_32108().method_32101(18, 14).method_32098(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, scale), class_5603.method_32091((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        var1.method_32117("upper_body", class_5606.method_32108().method_32101(21, 0).method_32098(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, scale), class_5603.method_32091((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        class_5606 var4 = class_5606.method_32108().method_32101(0, 18).method_32098(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale);
        var1.method_32117("right_hind_leg", var4, class_5603.method_32090((float)-1.5f, (float)16.0f, (float)7.0f));
        var1.method_32117("left_hind_leg", var4, class_5603.method_32090((float)1.5f, (float)16.0f, (float)7.0f));
        var1.method_32117("right_front_leg", var4, class_5603.method_32090((float)-1.5f, (float)16.0f, (float)-4.0f));
        var1.method_32117("left_front_leg", var4, class_5603.method_32090((float)1.5f, (float)16.0f, (float)-4.0f));
        class_5610 var5 = var1.method_32117("tail", class_5606.method_32108(), class_5603.method_32091((float)0.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        var5.method_32117("real_tail", class_5606.method_32108().method_32101(9, 18).method_32098(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale), class_5603.field_27701);
        return class_5607.method_32110((class_5609)var0, (int)64, (int)32);
    }

    public void prepareMobModel(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        boolean stand_pose;
        this.resetAllPose();
        DogPose pose = dog.getDogPose();
        DogAnimation anim = dog.getAnim();
        if (anim != DogAnimation.NONE) {
            if (anim.freeHead() && pose.canBeg) {
                this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
            }
            return;
        }
        boolean bl = stand_pose = !DogPoseSetups.setupPose(pose, this, dog, limbSwing, limbSwingAmount, partialTickTime);
        if (stand_pose) {
            this.setUpStandPose(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
        if (pose.canShake) {
            this.translateShakingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
        if (pose.canBeg) {
            this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
    }

    public void setUpStandPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.animateStandWalking(dog, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void animateStandWalking(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        float w = class_3532.method_15362((float)(limbSwing * 0.6662f));
        float w1 = class_3532.method_15362((float)(limbSwing * 0.6662f + (float)Math.PI));
        float swing = class_3532.method_15363((float)limbSwingAmount, (float)0.0f, (float)1.0f);
        float modifier = 2.5f;
        this.body.field_3654 += this.getAnimateWalkingValue(w, swing, modifier * -5.0f * ((float)Math.PI / 180));
        this.body.field_3656 += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.body.field_3655 += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.mane.field_3654 += this.getAnimateWalkingValue(w, swing, modifier * 2.5f * ((float)Math.PI / 180));
        this.mane.field_3656 += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.head.field_3656 += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.tail.field_3656 += this.getAnimateWalkingValue(w, swing, 0.5f * modifier);
        this.tail.field_3655 += this.getAnimateWalkingValue(w, swing, -0.5f * modifier);
        if (this.earRight.isPresent()) {
            this.earRight.get().field_3654 += this.getAnimateWalkingValue(w, swing, -0.6981317f);
            this.earRight.get().field_3674 += this.getAnimateWalkingValue(w, swing, -0.47996554f);
            this.earRight.get().field_3656 += this.getAnimateWalkingValue(w, swing, 0.5f);
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().field_3654 += this.getAnimateWalkingValue(w, swing, -0.6981317f);
            this.earLeft.get().field_3674 += this.getAnimateWalkingValue(w, swing, 0.47996554f);
            this.earLeft.get().field_3656 += this.getAnimateWalkingValue(w, swing, 0.5f);
        }
        this.legBackRight.field_3654 += w * 1.4f * limbSwingAmount;
        this.legBackLeft.field_3654 += w1 * 1.4f * limbSwingAmount;
        this.legFrontRight.field_3654 += w1 * 1.4f * limbSwingAmount;
        this.legFrontLeft.field_3654 += w * 1.4f * limbSwingAmount;
    }

    private float getAnimateWalkingValue(float w, float swingAmount, float amplitude) {
        int sign = class_3532.method_17822((double)amplitude);
        amplitude = Math.abs(amplitude);
        return (float)sign * Math.abs(amplitude * swingAmount * w);
    }

    public void translateShakingDog(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.mane.field_3674 = dog.getShakeAngle(partialTickTime, -0.08f);
        this.body.field_3674 = dog.getShakeAngle(partialTickTime, -0.16f);
        this.realTail.field_3674 = dog.getShakeAngle(partialTickTime, -0.2f);
    }

    public void translateBeggingDog(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.realHead.field_3674 = dog.getInterestedAngle(partialTickTime) + dog.getShakeAngle(partialTickTime, 0.0f);
    }

    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        DogPose pose = dog.getDogPose();
        DogAnimationManager animationManager = dog.animationManager;
        if (dog.isDogInAnimDebug() && dog.getAnim().isNone()) {
            this.setDogUpDebugAnim(dog);
            return;
        }
        if (pose.freeHead) {
            this.head.field_3654 += headPitch * ((float)Math.PI / 180);
            this.head.field_3675 = this.head.field_3675 + netHeadYaw * (dog.method_6172() && dog.isLying() ? 0.005f : (float)Math.PI / 180);
        }
        if (pose.freeTail) {
            this.tail.field_3654 = dog.getTailRotation();
            this.tail.field_3675 = dog.getWagAngle(limbSwing, limbSwingAmount, ageInTicks);
        }
        DogAnimationState animState = animationManager.animationState;
        DogAnimation anim = dog.getAnim();
        if (anim == DogAnimation.NONE) {
            return;
        }
        class_7184 sequence = this.getAnimationSequence(anim);
        if (sequence == null) {
            return;
        }
        if (pose.freeHead && anim.freeHead()) {
            this.headXRot0 = this.head.field_3654;
            this.headYRot0 = this.head.field_3675;
            this.realHeadZRot0 = this.realHead.field_3674;
        } else if (pose.freeHead && anim.freeHeadXRotOnly()) {
            this.headXRot0 = this.head.field_3654;
        }
        anim.rootRotation().ifPresent(x -> this.root.field_3675 += x.floatValue() * ((float)Math.PI / 180));
        if (animState.isStarted()) {
            animState.updateTime(ageInTicks, anim.getSpeedModifier());
            DogKeyframeAnimations.animate(this, dog, sequence, animState.getAccumulatedTimeMillis(), 1.0f, this.vecObj);
        }
    }

    private void setDogUpDebugAnim(Dog dog) {
        this.resetAllPose();
        DogAnimationManager.DogAnimDebugState debug_state = dog.getDogAnimDebugState();
        DogAnimation dog_anim = debug_state.anim();
        class_7184 sequence = DogAnimationRegistry.getSequence(dog_anim);
        if (sequence == null) {
            return;
        }
        long timestamp_millis = Util.tickMayWithPartialToMillis(debug_state.timestamp());
        DogKeyframeAnimations.animate(this, dog, sequence, timestamp_millis, 1.0f, this.vecObj);
    }

    protected class_7184 getAnimationSequence(DogAnimation anim) {
        return DogAnimationRegistry.getSequence(anim);
    }

    public void resetAllPose() {
        this.root.method_32088().forEach(x -> x.method_41923());
        this.realHead.method_41923();
        this.realTail.method_41923();
        this.earLeft.ifPresent(ear -> ear.method_41923());
        this.earRight.ifPresent(ear -> ear.method_41923());
    }

    public void copyFrom(DogModel dogModel) {
        ModelUtil_1_21_9.copyModelPartFrom(this.root, dogModel.root);
        ModelUtil_1_21_9.copyModelPartFrom(this.head, dogModel.head);
        ModelUtil_1_21_9.copyModelPartFrom(this.realHead, dogModel.realHead);
        ModelUtil_1_21_9.copyModelPartFrom(this.body, dogModel.body);
        ModelUtil_1_21_9.copyModelPartFrom(this.mane, dogModel.mane);
        ModelUtil_1_21_9.copyModelPartFrom(this.legBackRight, dogModel.legBackRight);
        ModelUtil_1_21_9.copyModelPartFrom(this.legBackLeft, dogModel.legBackLeft);
        ModelUtil_1_21_9.copyModelPartFrom(this.legFrontRight, dogModel.legFrontRight);
        ModelUtil_1_21_9.copyModelPartFrom(this.legFrontLeft, dogModel.legFrontLeft);
        ModelUtil_1_21_9.copyModelPartFrom(this.tail, dogModel.tail);
        ModelUtil_1_21_9.copyModelPartFrom(this.realTail, dogModel.realTail);
    }

    public void resetPart(class_630 part, Dog dog) {
        if (part == this.tail && dog.getAnim().freeTail()) {
            this.tail.method_41923();
            this.tail.field_3654 = dog.getTailRotation();
            return;
        }
        if (part == this.head && dog.getAnim().freeHead() && dog.getDogPose().freeHead) {
            this.head.method_41923();
            this.head.field_3654 = this.headXRot0;
            this.head.field_3675 = this.headYRot0;
            this.realHead.method_41923();
            this.realHead.field_3674 = this.realHeadZRot0;
            return;
        }
        if (part == this.head && dog.getAnim().convertHeadZRot()) {
            this.head.method_41923();
            this.head.field_3654 = this.headXRot0;
            return;
        }
        part.method_41923();
    }

    public void adjustAnimatedPart(class_630 part, Dog dog) {
        if (part == this.tail && dog.getAnim().freeTail() && part.field_3654 > 3.0f) {
            part.field_3654 = 3.0f;
        }
        if (part == this.head && part.field_3674 != 0.0f && dog.getAnim().convertHeadZRot()) {
            this.realHead.field_3674 = part.field_3674;
            part.field_3674 = 0.0f;
        }
    }

    public Optional<class_630> searchForPartWithName(String name) {
        return DogKeyframeAnimations.searchForPartWithName(this.root, name);
    }

    public boolean useDefaultModelForAccessories() {
        return false;
    }

    public boolean acessoryShouldRender(Dog dog, AccessoryInstance inst) {
        return true;
    }

    public boolean armorShouldRender(Dog dog) {
        return true;
    }

    public boolean incapShouldRender(Dog dog) {
        return true;
    }

    public boolean scaleBabyDog() {
        return true;
    }

    public boolean renderDogWetShade() {
        return true;
    }

    public boolean warnAccessory(Dog dog, Accessory inst) {
        return false;
    }

    @Nullable
    public Vector3f getCustomRootPivotPoint() {
        return null;
    }

    public boolean hasDefaultScale() {
        return false;
    }

    public float getDefaultScale() {
        return 1.0f;
    }

    public AccessoryState getAccessoryState() {
        return this.accessoryState;
    }

    public DogModel setAccessoryState(AccessoryState state) {
        if (state == null) {
            state = AccessoryState.HAVE_NOT_TESTED;
        }
        this.accessoryState = state;
        return this;
    }

    public void setVisible(boolean visible) {
        this.head.field_3665 = visible;
        this.body.field_3665 = visible;
        this.legBackRight.field_3665 = visible;
        this.legBackLeft.field_3665 = visible;
        this.legFrontRight.field_3665 = visible;
        this.legFrontLeft.field_3665 = visible;
        this.tail.field_3665 = visible;
        this.mane.field_3665 = visible;
    }

    @Override
    public void copyPropertiesTo(IBaseDogModel_21_3 model) {
        IBaseDogModel_21_3.super.copyPropertiesTo(model);
        if (!this.scaleBabyDog()) {
            model.setDogYoung(false);
        }
    }

    public void setWetShade(float shade) {
        this.wetShade = shade;
    }

    public void resetWetShade() {
        this.wetShade = 1.0f;
    }

    public void method_62100(class_4587 stack, class_4588 vertex_consumer, int light, int overlay, int color_overlay) {
        if (this.renderDogWetShade()) {
            int wet_color = class_9848.method_61318((float)1.0f, (float)this.wetShade, (float)this.wetShade, (float)this.wetShade);
            color_overlay = class_9848.method_61322((int)color_overlay, (int)wet_color);
        }
        DogModelRenderContext ctx = DogModelRenderContext.forDogModelRendering(this, vertex_consumer, light, overlay, color_overlay, this.getDogModelAdditionalHeadRenderer());
        DogModel.renderDogModelFromRootWithPivot(stack, ctx);
    }

    protected Optional<AddtionalHeadRenderer> getDogModelAdditionalHeadRenderer() {
        return Optional.empty();
    }

    private Optional<class_630> getDogModelBabyHead() {
        return this.doScaleBabyHead() ? Optional.of(this.head) : Optional.empty();
    }

    protected boolean doScaleBabyHead() {
        return this.young && this.scaleBabyDog();
    }

    public static void renderDogModelFromRootWithPivot(class_4587 stack, DogModelRenderContext ctx) {
        class_630 root = ctx.root();
        Vector3f pivot = ctx.pivot();
        Optional<class_630> head_baby = ctx.headBaby();
        DogRenderPartContext part_ctx = ctx.renderPartContext().orElse(null);
        AddtionalHeadRenderer addtional_head = ctx.additionalHeadRenderer().orElse(null);
        stack.method_22903();
        DogModel.applyRootTransformWithPivotedRotation(root, stack, pivot);
        RootRotationTranslationStash stashed_root = RootRotationTranslationStash.stash(root);
        if (head_baby.isPresent()) {
            class_630 head = head_baby.get();
            boolean headVisible0 = head.field_3665;
            head.field_3665 = false;
            stack.method_22903();
            if (part_ctx != null) {
                part_ctx.renderPart(stack, root);
            }
            stack.method_22909();
            head.field_3665 = headVisible0;
            stack.method_22903();
            stack.method_22905(2.0f, 2.0f, 2.0f);
            stack.method_22904(0.0, -0.5, 0.15);
            if (part_ctx != null) {
                part_ctx.renderPart(stack, head);
            }
            if (addtional_head != null) {
                addtional_head.render(stack, ctx.renderPartContext());
            }
            stack.method_22909();
        } else {
            if (part_ctx != null) {
                part_ctx.renderPart(stack, root);
            }
            if (addtional_head != null) {
                addtional_head.render(stack, ctx.renderPartContext());
            }
        }
        stack.method_22909();
        stashed_root.restore(root);
    }

    private static void applyRootTransformWithPivotedRotation(class_630 root, class_4587 stack, Vector3f pivot) {
        stack.method_46416(root.field_3657 / 16.0f, root.field_3656 / 16.0f, root.field_3655 / 16.0f);
        stack.method_46416(pivot.x / 16.0f, pivot.y / 16.0f, pivot.z / 16.0f);
        if (root.field_3654 != 0.0f || root.field_3675 != 0.0f || root.field_3674 != 0.0f) {
            stack.method_22907((Quaternionfc)new Quaternionf().rotationZYX(root.field_3674, root.field_3675, root.field_3654));
        }
        stack.method_46416(-pivot.x / 16.0f, -pivot.y / 16.0f, -pivot.z / 16.0f);
    }

    public void setupAnim(DogRenderState_21_3 render_state) {
        Dog dog = render_state.dog;
        float walk_anim_time = render_state.field_53450;
        float walk_anim_speed = render_state.field_53451;
        float yrot = render_state.field_53447;
        float xrot = render_state.field_53448;
        float ticks_with_partial = render_state.field_53328;
        this.young = dog.method_6109();
        render_state.runDefferedSetupAndInvalidate_1_21_9();
        this.prepareMobModel(dog, walk_anim_time, walk_anim_speed, render_state.partialTick);
        this.setupAnim(dog, walk_anim_time, walk_anim_speed, ticks_with_partial, yrot, xrot);
    }

    @Override
    public void setDogYoung(boolean val) {
        this.young = val;
    }

    @Override
    public boolean getDogYoung() {
        return this.young;
    }

    public static enum AccessoryState {
        NON_COMPATIBLE,
        SOME_WILL_FIT,
        HAVE_NOT_TESTED,
        RECOMMENDED,
        MODEL_ONLY;

    }

    public record DogModelRenderContext(class_630 root, Vector3f pivot, Optional<class_630> headBaby, Optional<DogRenderPartContext> renderPartContext, Optional<AddtionalHeadRenderer> additionalHeadRenderer) {
        public static DogModelRenderContext forDogModelRendering(DogModel model, class_4588 vertex_consumer, int light, int overlay, int color_overlay, Optional<AddtionalHeadRenderer> addtionalHeadRenderer) {
            Vector3f pivot = DEFAULT_ROOT_PIVOT;
            Vector3f custom_pivot = model.getCustomRootPivotPoint();
            if (custom_pivot != null) {
                pivot = custom_pivot;
            }
            DogRenderPartContext render_part_ctx = new DogRenderPartContext(vertex_consumer, light, overlay, color_overlay);
            return new DogModelRenderContext(model.root, pivot, model.getDogModelBabyHead(), Optional.of(render_part_ctx), addtionalHeadRenderer);
        }
    }

    public record DogRenderPartContext(class_4588 vertex_consumer, int light, int overlay, int color_overlay) {
        public void renderPart(class_4587 stack, class_630 part) {
            part.method_22699(stack, this.vertex_consumer(), this.light(), this.overlay(), this.color_overlay());
        }

        public void renderGlowingPart(class_4587 stack, class_630 part) {
            part.method_22699(stack, this.vertex_consumer(), 0xF000F0, this.overlay(), this.color_overlay());
        }
    }

    @FunctionalInterface
    public static interface AddtionalHeadRenderer {
        public void render(class_4587 var1, Optional<DogRenderPartContext> var2);
    }

    private record RootRotationTranslationStash(float x, float y, float z, float xRot, float yRot, float zRot) {
        public static RootRotationTranslationStash stash(class_630 root) {
            RootRotationTranslationStash ret = new RootRotationTranslationStash(root.field_3657, root.field_3656, root.field_3655, root.field_3654, root.field_3675, root.field_3674);
            root.field_3657 = 0.0f;
            root.field_3656 = 0.0f;
            root.field_3655 = 0.0f;
            root.field_3654 = 0.0f;
            root.field_3675 = 0.0f;
            root.field_3674 = 0.0f;
            return ret;
        }

        public void restore(class_630 root) {
            root.field_3657 = this.x;
            root.field_3656 = this.y;
            root.field_3655 = this.z;
            root.field_3654 = this.xRot;
            root.field_3675 = this.yRot;
            root.field_3674 = this.zRot;
        }
    }
}

