/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import doggytalents.client.ClientSetup;
import doggytalents.client.DogTextureManager;
import doggytalents.client.backward_imitate.DogRenderState_21_3;
import doggytalents.client.backward_imitate.RenderUtil_1_21_9;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.model.dog.NullDogModel;
import doggytalents.client.entity.render.CollarRenderManager;
import doggytalents.client.entity.render.layer.LayerFactory;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_10042;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_746;
import net.minecraft.class_927;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class DogRenderer
extends class_927<Dog, DogRenderState_21_3, DogModel> {
    private static final int TXTCLR_DIFFOWNER = 1464486474;
    private static final int TXTCLR_HEALTH_70_100 = 720707;
    private static final int TXTCLR_HEALTH_30_70 = 15727189;
    private static final int TXTCLR_HEALTH_0_30 = 0xFF3636;
    private static final int TXTCLR_HEALTH_BKG = 0x4A4A4A;
    private static final int TXCLR_SEPERATOR = -6184543;
    private DogModel defaultModel;
    private NullDogModel nullDogModel;
    private List<class_3887<DogRenderState_21_3, DogModel>> originalDogLayers = List.of();

    public DogRenderer(class_5617.class_5618 ctx) {
        super(ctx, null, 0.5f);
        DogModelRegistry.resolve(ctx);
        this.defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();
        for (LayerFactory<DogRenderState_21_3, DogModel> layer : CollarRenderManager.getLayers()) {
            this.method_4046(layer.createLayer((class_3883<DogRenderState_21_3, DogModel>)this, ctx));
        }
        this.originalDogLayers = new ArrayList<class_3887<DogRenderState_21_3, DogModel>>(this.field_4738);
        this.nullDogModel = new NullDogModel(ctx.method_32167(ClientSetup.DOG_NULL));
        this.field_4737 = this.nullDogModel;
    }

    public void submit(DogRenderState_21_3 dog_render_state, class_4587 matrixStackIn, class_11659 node_collector_1_21_9, class_12075 camera_state_1_21_9) {
        Dog dog = dog_render_state.dog;
        float partialTicks = dog_render_state.partialTick;
        DogSkin skin = dog.getClientSkin();
        this.field_4737 = skin.useCustomModel() ? dog.getClientSkin().getCustomModel().getValue() : this.defaultModel;
        dog_render_state.defferedSetup_1_21_9 = () -> {
            ((DogModel)this.field_4737).resetWetShade();
            if (dog.isDogSoaked() && !dog.dogVariant().preventWetShade()) {
                float f = dog.getShadingWhileWet(partialTicks);
                ((DogModel)this.field_4737).setWetShade(f);
            }
        };
        super.method_4054((class_10042)dog_render_state, matrixStackIn, node_collector_1_21_9, camera_state_1_21_9);
        this.field_4737 = this.nullDogModel;
    }

    private class_2561 getNameUnknown(Dog dogIn) {
        return class_2561.method_43471((String)(dogIn.getOwnerUUID() != null ? "entity.doggytalents.dog.unknown_owner" : "entity.doggytalents.dog.untamed"));
    }

    public class_2960 getTextureLocation(DogRenderState_21_3 render_state) {
        return DogTextureManager.INSTANCE.getTexture(render_state.dog);
    }

    protected void scaleDog(Dog dogIn, DogRenderState_21_3 state, float partialTickTime) {
        DogModel model;
        float size = dogIn.method_6109() ? 0.5f : dogIn.getDogSize().getScale();
        this.field_4673 = size * 0.5f;
        DogSkin skin = dogIn.getClientSkin();
        if (skin.useCustomModel() && (model = skin.getCustomModel().getValue()).hasDefaultScale()) {
            float default_scale = model.getDefaultScale();
            state.field_53453 *= default_scale;
            this.field_4673 *= default_scale;
        }
    }

    protected boolean shouldShowName(Dog dog, double distance_to_camera_sqr) {
        if (((Boolean)ConfigHandler.CLIENT.ALWAYS_RENDER_DOG_NAME.get()).booleanValue() && !dog.method_5782() && dog.method_16914()) {
            return true;
        }
        return super.method_4071((class_1308)dog, distance_to_camera_sqr);
    }

    protected void submitNameTag(DogRenderState_21_3 render_state, class_4587 stack, class_11659 node_collector_1_21_9, class_12075 camera_state_1_21_9) {
        boolean isDiffOwner;
        RenderUtil_1_21_9.RenderContext_1_21_9 render_context_1_21_9 = new RenderUtil_1_21_9.RenderContext_1_21_9(node_collector_1_21_9, camera_state_1_21_9, render_state);
        class_2561 text = render_state.dog.method_5797();
        if (text == null) {
            return;
        }
        Dog dog = render_state.dog;
        double d0 = this.field_4676.method_23168((class_1297)dog);
        class_746 player = class_310.method_1551().field_1724;
        boolean renderDiffOwnerName = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_DIFFOWNER_NAME_DIFFERENT) != false && dog != this.field_4676.field_4678;
        boolean bl = isDiffOwner = player == null || !Objects.equals(player.method_5667(), dog.getOwnerUUID());
        if (isDiffOwner && ((Boolean)ConfigHandler.CLIENT.DONT_RENDER_DIFFOWNER_NAME.get()).booleanValue()) {
            return;
        }
        if (d0 <= 4096.0) {
            this.renderMainName(dog, text, stack, render_context_1_21_9, renderDiffOwnerName && isDiffOwner, isDiffOwner, !isDiffOwner && WhistleItem.isHoldingDutyWhistle((class_1309)player));
        }
        if (d0 <= 4096.0) {
            this.renderExtraInfo(dog, text, stack, render_context_1_21_9, d0, renderDiffOwnerName && isDiffOwner, isDiffOwner);
        }
    }

    private void renderMainName(Dog dog, class_2561 text, class_4587 stack, RenderUtil_1_21_9.RenderContext_1_21_9 renderContext_1_21_9, boolean diffOwnerRender, boolean isDiffOwner, boolean renderDogOnDuty) {
        text = this.modifyMainText(dog, text, diffOwnerRender, renderDogOnDuty);
        this.renderDogText(dog, text, 0.0, 0.025f, stack, renderContext_1_21_9, diffOwnerRender, isDiffOwner);
    }

    private int getBkgTextColorWithOpacity(boolean diffOwnerRender) {
        boolean color = false;
        float bkg_opacity = 0.0f;
        if (!diffOwnerRender) {
            bkg_opacity = class_310.method_1551().field_1690.method_19343(0.25f);
        }
        int alpha = (int)(bkg_opacity * 255.0f) << 24;
        return alpha | 0;
    }

    private void renderDogText(Dog dog, class_2561 text, double y_offset_from_default, float scale, class_4587 stack, RenderUtil_1_21_9.RenderContext_1_21_9 renderContext_1_21_9, boolean render_diffowner, boolean is_diffowner) {
        boolean dog_not_sneaking = !dog.method_21751();
        double render_y_offset = (double)(dog.method_17682() + 0.5f) + y_offset_from_default;
        stack.method_22903();
        stack.method_22904(0.0, render_y_offset, 0.0);
        stack.method_22907((Quaternionfc)renderContext_1_21_9.cameraState().field_63081);
        stack.method_22905(scale, -scale, scale);
        Matrix4f pose = stack.method_23760().method_23761();
        class_327 font = this.method_3932();
        float tX = -font.method_27525((class_5348)text) / 2;
        float tY = 0.0f;
        boolean bkg_see_through = dog_not_sneaking && !is_diffowner && (Boolean)ConfigHandler.CLIENT.SHOW_DOG_NAME_THRU_WALL.get() != false;
        class_327.class_6415 bkg_display_mode = bkg_see_through ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993;
        int bkg_color = this.getBkgTextColorWithOpacity(render_diffowner);
        int bkg_txtcolor = 0x20FFFFFF;
        RenderUtil_1_21_9.submitNameTagRaw(renderContext_1_21_9, text, tX, tY, bkg_txtcolor, pose, bkg_display_mode, bkg_color);
        stack.method_22904(0.0, 0.0, 0.1);
        boolean draw_fg_text = dog_not_sneaking;
        if (draw_fg_text) {
            class_327.class_6415 fg_display_mode = class_327.class_6415.field_33993;
            int fg_color = 0;
            int fg_txtcolor = -1;
            RenderUtil_1_21_9.submitNameTagRaw(renderContext_1_21_9, text, tX, tY, fg_txtcolor, pose, fg_display_mode, fg_color);
        }
        stack.method_22909();
    }

    private void renderExtraInfo(Dog dog, class_2561 text, class_4587 stack, RenderUtil_1_21_9.RenderContext_1_21_9 renderContext_1_21_9, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        this.renderInfoDogText(dog, text, stack, renderContext_1_21_9, d0, diffOwnerRender, isDiffOwner);
        this.renderSecondaryInfoDogText(dog, text, stack, renderContext_1_21_9, d0, diffOwnerRender, isDiffOwner);
    }

    private void renderInfoDogText(Dog dog, class_2561 text, class_4587 stack, RenderUtil_1_21_9.RenderContext_1_21_9 renderContext_1_21_9, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        boolean renderHealthInNameActivated = this.field_4676.field_4686.method_19331().method_5715() && (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_HEALTH_IN_NAME) != false;
        String seperator = (String)ConfigHandler.CLIENT.DOG_INFO_SEPERATOR.get();
        class_5250 seperator_c1 = this.createC1WithColor(seperator, -6184543);
        class_5250 extra_info_c1 = class_2561.method_43471((String)dog.getMode().getTip());
        Optional<class_2561> hunger_c1_optional = this.getHungerC1(dog, renderHealthInNameActivated);
        Optional<class_2561> gender_c1_optional = this.getGenderC1(dog);
        if (hunger_c1_optional.isPresent()) {
            extra_info_c1.method_10852((class_2561)seperator_c1);
            class_2561 hunger_c1 = hunger_c1_optional.get();
            extra_info_c1.method_10852(hunger_c1);
        }
        if (gender_c1_optional.isPresent()) {
            extra_info_c1.method_10852((class_2561)seperator_c1);
            class_2561 gender_c1 = gender_c1_optional.get();
            extra_info_c1.method_10852(gender_c1);
        }
        if (diffOwnerRender) {
            extra_info_c1 = this.createC1WithColor((class_2561)extra_info_c1, 1464486474);
        }
        this.renderDogText(dog, (class_2561)extra_info_c1, 0.12f, 0.01f, stack, renderContext_1_21_9, diffOwnerRender, isDiffOwner);
    }

    private void renderSecondaryInfoDogText(Dog dog, class_2561 text, class_4587 stack, RenderUtil_1_21_9.RenderContext_1_21_9 renderContext_1_21_9, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        if (d0 > 25.0) {
            return;
        }
        class_1297 camera_entity = this.field_4676.field_4686.method_19331();
        if (!camera_entity.method_5715()) {
            return;
        }
        if (dog.method_35057() == camera_entity) {
            return;
        }
        class_2561 ownerC0 = dog.getOwnersName().orElseGet(() -> this.getNameUnknown(dog));
        if (diffOwnerRender) {
            ownerC0 = this.createC1WithColor(ownerC0, 1464486474);
        }
        this.renderDogText(dog, ownerC0, -0.25, 0.01f, stack, renderContext_1_21_9, diffOwnerRender, isDiffOwner);
    }

    private Optional<class_2561> getHungerC1(Dog dog, boolean renderHealthInNameActivated) {
        boolean hightlight_red;
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue() && !dog.isDefeated()) {
            return Optional.empty();
        }
        String hunger_format = (String)ConfigHandler.CLIENT.DOG_INFO_HUNGER_FORMAT.get();
        int hunger = 0;
        hunger = dog.isDefeated() ? -dog.getDogIncapValue() : class_3532.method_15386((float)dog.getDogHunger());
        class_5250 hunger_c1 = class_2561.method_43470((String)String.format(Locale.ROOT, hunger_format, hunger));
        boolean bl = hightlight_red = dog.getDogHunger() <= 10.0f && renderHealthInNameActivated || dog.isDefeated();
        if (hightlight_red) {
            hunger_c1.method_27696(class_2583.field_24360.method_36139(0xFF3636));
        }
        return Optional.of(hunger_c1);
    }

    private Optional<class_2561> getGenderC1(Dog dog) {
        if (((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER)).booleanValue()) {
            return Optional.empty();
        }
        class_5250 ret = class_2561.method_43471((String)dog.getGender().getUnlocalisedTip());
        return Optional.of(ret);
    }

    private class_2561 modifyMainText(Dog dog, class_2561 text, boolean diffOwnerRender, boolean renderDogOnDuty) {
        boolean renderHealthInNameActive;
        if (diffOwnerRender) {
            text = this.createC1WithColor(text, 1464486474);
            return text;
        }
        if (renderDogOnDuty) {
            if (dog.dogOnDuty()) {
                text = this.createC1WithColor(text, -61191);
            }
            return text;
        }
        if (ClientEventHandler.shouldRenderAnimDebugNametag(dog)) {
            text = this.createC1WithColor(text, -3299584);
            return text;
        }
        boolean bl = renderHealthInNameActive = this.field_4676.field_4686.method_19331().method_5715() && (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_HEALTH_IN_NAME) != false;
        if (renderHealthInNameActive) {
            text = this.colorTextWithHealth(dog, text);
        }
        return text;
    }

    private class_2561 colorTextWithHealth(Dog dog, class_2561 text) {
        int noCharsInName = text.getString().length();
        float healthPercentage = dog.method_6032() / dog.method_6063();
        healthPercentage = class_3532.method_15363((float)healthPercentage, (float)0.0f, (float)1.0f);
        int noCharHighlighted = class_3532.method_15386((float)((float)noCharsInName * healthPercentage));
        noCharHighlighted = class_3532.method_15340((int)noCharHighlighted, (int)0, (int)noCharsInName);
        String hlPart = text.getString().substring(0, noCharHighlighted);
        String nonHlPart = "";
        if (noCharHighlighted <= noCharsInName) {
            nonHlPart = text.getString().substring(noCharHighlighted, noCharsInName);
        }
        int color = 0xFF3636;
        if ((double)healthPercentage >= 0.7) {
            color = 720707;
        } else if ((double)healthPercentage >= 0.3) {
            color = 15727189;
        }
        class_5250 newTxt = this.createC1WithColor(hlPart, color);
        class_5250 restTxt = this.createC1WithColor(nonHlPart, 0x4A4A4A);
        newTxt.method_10852((class_2561)restTxt);
        text = newTxt;
        return text;
    }

    private class_5250 createC1WithColor(String str, int color) {
        return class_2561.method_43470((String)str).method_27696(class_2583.field_24360.method_36139(color));
    }

    private class_5250 createC1WithColor(class_2561 c1, int color) {
        return this.createC1WithColor(c1.getString(), color);
    }

    public DogRenderState_21_3 createRenderState() {
        return new DogRenderState_21_3();
    }

    public void extractRenderState(Dog dog, DogRenderState_21_3 extract_to, float p_ticks) {
        super.method_62355((class_1309)dog, (class_10042)extract_to, p_ticks);
        extract_to.dog = dog;
        this.scaleDog(dog, extract_to, p_ticks);
        this.extractRightHandItemModelForDog(dog, extract_to);
        extract_to.partialTick = p_ticks;
    }

    private void extractRightHandItemModelForDog(Dog dog, DogRenderState_21_3 extract_to) {
    }

    protected float getShadowRadius(DogRenderState_21_3 p_365066_) {
        return this.field_4673;
    }

    public static int getOverlayCoords(Dog dog, float p_115340_) {
        return class_4608.method_23625((int)class_4608.method_23210((float)p_115340_), (int)class_4608.method_23212((dog.field_6235 > 0 || dog.field_6213 > 0 ? 1 : 0) != 0));
    }
}

