/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.DoggyItems;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.WhisltleEditHotKeyData;
import doggytalents.common.network.packet.data.WhistleRequestModeData;
import doggytalents.common.util.ItemUtil;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_746;

public class WhistleScreen
extends StringEntrySelectScreen {
    private final List<WhistleItem.WhistleMode> modeList;
    private boolean settingKeysMode = false;
    private int pKey = 0;
    private int[] hotkeysModeArr = new int[]{-1, -1, -1, -1};
    private boolean showModeHelp;
    private boolean dogOnDutyOnly;

    public WhistleScreen() {
        super((class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.title"));
        this.modeList = Arrays.stream(WhistleItem.WhistleMode.VALUES).collect(Collectors.toList());
        this.updateEntries(this.modeList.stream().map(x -> class_1074.method_4662((String)x.getUnlocalisedTitle(), (Object[])new Object[0])).collect(Collectors.toList()));
    }

    public static void open(class_1799 whistle_stack) {
        class_310 mc = class_310.method_1551();
        WhistleScreen screen = new WhistleScreen();
        screen.dogOnDutyOnly = WhistleItem.isDogOnDutyOnly(whistle_stack);
        mc.method_1507((class_437)screen);
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.field_22789 / 2;
        int mY = this.field_22790 / 2;
        int pY = mY - 100;
        FlatButton setKey = new FlatButton(mX - 100 - 60 - 2, pY, 60, 20, (class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.screen.set_hotkey"), b -> {
            if (this.settingKeysMode) {
                this.settingKeysMode = false;
                b.method_25355((class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.screen.set_hotkey"));
            } else {
                this.settingKeysMode = true;
                b.method_25355((class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.screen.use_whistle"));
            }
        }){

            @Override
            public void method_48579(class_332 graphics, int mouseX, int mouseY, float pTicks) {
                super.method_48579(graphics, mouseX, mouseY, pTicks);
                if (!this.field_22762) {
                    return;
                }
                ArrayList<class_2561> list = new ArrayList<class_2561>();
                list.add((class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.screen.set_hotkey").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true))));
                String str = class_1074.method_4662((String)"doggytalents.screen.whistler.screen.set_hotkey.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, WhistleScreen.this.field_22793));
                ScreenUtil.renderComponentTooltip_21_5(graphics, WhistleScreen.this.field_22793, list, mouseX, mouseY);
            }
        };
        FlatButton onDuty = new FlatButton(mX - 100 - 60 - 2, pY += setKey.method_25364() + 2, 60, 20, (class_2561)(this.dogOnDutyOnly ? class_2561.method_43471((String)"doggytalents.screen.whistler.target.on_duty") : class_2561.method_43471((String)"doggytalents.screen.whistler.target.all")), b -> {
            if (this.dogOnDutyOnly) {
                this.dogOnDutyOnly = false;
                b.method_25355((class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.target.all"));
            } else {
                this.dogOnDutyOnly = true;
                b.method_25355((class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.target.on_duty"));
            }
        }){

            @Override
            public void method_48579(class_332 graphics, int mouseX, int mouseY, float pTicks) {
                super.method_48579(graphics, mouseX, mouseY, pTicks);
                if (!this.field_22762) {
                    return;
                }
                ArrayList<class_2561> list = new ArrayList<class_2561>();
                class_5250 title = class_2561.method_43471((String)"doggytalents.screen.whistler.target.title").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
                list.add((class_2561)title);
                String str = class_1074.method_4662((String)"doggytalents.screen.whistler.target.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, WhistleScreen.this.field_22793));
                ScreenUtil.renderComponentTooltip_21_5(graphics, WhistleScreen.this.field_22793, list, mouseX, mouseY);
            }
        };
        FlatButton help = new FlatButton(mX - 100 - 20 - 2, pY += onDuty.method_25364() + 2, 20, 20, (class_2561)class_2561.method_43470((String)"?"), b -> {}){

            @Override
            public void method_48579(class_332 graphics, int mouseX, int mouseY, float pTicks) {
                super.method_48579(graphics, mouseX, mouseY, pTicks);
                if (!this.field_22762) {
                    return;
                }
                ArrayList<class_2561> list = new ArrayList<class_2561>();
                list.add((class_2561)class_2561.method_43471((String)"doggytalents.screen.whistler.screen.help_title").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true))));
                String str = class_1074.method_4662((String)"doggytalents.screen.general.entry_select.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, WhistleScreen.this.field_22793));
                ScreenUtil.renderComponentTooltip_21_5(graphics, WhistleScreen.this.field_22793, list, mouseX, mouseY);
            }
        };
        this.method_37063((class_364)help);
        this.method_37063((class_364)setKey);
        this.method_37063((class_364)onDuty);
        int pY_right = mY - 100;
        String mode_help_str_id = "doggytalents.screen.whistler.mode_help";
        class_5250 initial_mode_help_str = this.showModeHelp ? class_2561.method_43471((String)mode_help_str_id).method_27696(class_2583.field_24360.method_36139(this.getHightlightSelectedColor())) : class_2561.method_43471((String)mode_help_str_id);
        FlatButton show_whistle_help = new FlatButton(mX + 100 + 2, pY_right, 60, 20, (class_2561)initial_mode_help_str, b -> {
            boolean bl = this.showModeHelp = !this.showModeHelp;
            if (this.showModeHelp) {
                b.method_25355((class_2561)class_2561.method_43471((String)mode_help_str_id).method_27696(class_2583.field_24360.method_36139(this.getHightlightSelectedColor())));
            } else {
                b.method_25355((class_2561)class_2561.method_43471((String)mode_help_str_id));
            }
        });
        this.method_37063((class_364)show_whistle_help);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.mayRenderModeHelp(graphics, mouseX, mouseY, partialTicks);
    }

    private void mayRenderModeHelp(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.showModeHelp) {
            return;
        }
        Optional<Integer> hover_entry_optional = this.getHoveredEntry(mouseX, mouseY);
        if (!hover_entry_optional.isPresent()) {
            return;
        }
        int entry_id = hover_entry_optional.get();
        WhistleItem.WhistleMode mode = this.modeList.get(entry_id);
        class_5250 mode_help_c1 = class_2561.method_43471((String)mode.getHelpMsg());
        if (this.field_22790 >= 338) {
            int mX = this.field_22789 / 2;
            int mY = this.field_22790 / 2;
            List splited_c1 = this.field_22793.method_1728((class_5348)mode_help_c1, 300);
            int tY = mY + this.getSelectAreaSize() / 2 + 23;
            for (class_5481 str : splited_c1) {
                int uuid_width = this.field_22793.method_30880(str);
                int tX = mX - uuid_width / 2;
                graphics.method_35720(this.field_22793, str, tX, tY, -1);
                Objects.requireNonNull(this.field_22793);
                tY += 9 + 2;
            }
        } else {
            class_5250 mode_name = class_2561.method_43471((String)mode.getUnlocalisedTitle()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
            ScreenUtil.renderComponentTooltip_21_5(graphics, this.field_22793, List.of(mode_name, mode_help_c1), mouseX, mouseY);
        }
    }

    @Override
    protected void drawEntry(class_332 graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        if (this.settingKeysMode) {
            this.drawSetMode(graphics, entry_x, entry_y, entry_id, is_selected);
        } else {
            this.drawNonSetMode(graphics, entry_x, entry_y, entry_id, is_selected);
        }
    }

    private void drawNonSetMode(class_332 graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        int color = -1;
        if (is_selected) {
            color = this.getHightlightSelectedColor();
        }
        class_5250 text = class_2561.method_43471((String)this.modeList.get(entry_id).getUnlocalisedTitle());
        text.method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_36139(color));
        graphics.method_27535(this.field_22793, (class_2561)text, entry_x, entry_y, color);
    }

    private void drawSetMode(class_332 graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        class_5250 text;
        int color = -1;
        if (is_selected) {
            color = this.getHightlightSelectedColor();
        }
        WhistleItem.WhistleMode mode = this.modeList.get(entry_id);
        int hotkey_indx = this.findHotkeyForMode(mode.getIndex());
        int prefix_color = 0xFF6F00;
        if (is_selected) {
            boolean remove = false;
            prefix_color = 720707;
            if (hotkey_indx >= 0) {
                prefix_color = 0xFF3636;
                remove = true;
            }
            text = class_2561.method_43470((String)(remove ? "- " : this.pKey + 1 + " "));
        } else if (hotkey_indx >= 0) {
            prefix_color = 0xFF6F00;
            text = class_2561.method_43470((String)(hotkey_indx + 1 + " "));
        } else {
            text = class_2561.method_43470((String)"  ");
        }
        text.method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(prefix_color));
        class_5250 title = class_2561.method_43471((String)mode.getUnlocalisedTitle());
        title.method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_36139(color));
        text.method_10852((class_2561)title);
        graphics.method_27535(this.field_22793, (class_2561)text, entry_x, entry_y, color);
    }

    public void method_25393() {
        this.updateCurrentHotKeys();
        this.pKey = this.findEmptyHotkey();
    }

    private void updateCurrentHotKeys() {
        for (int i = 0; i < this.hotkeysModeArr.length; ++i) {
            this.hotkeysModeArr[i] = -1;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        class_1799 stack = player.method_6047();
        if (stack == null) {
            return;
        }
        if (stack.method_7909() != DoggyItems.WHISTLE.get()) {
            return;
        }
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (tag == null) {
            return;
        }
        int[] list = tag.getIntArray("hotkey_modes");
        if (list == null) {
            return;
        }
        for (int i = 0; i < this.hotkeysModeArr.length && i < list.length; ++i) {
            this.hotkeysModeArr[i] = list[i];
        }
    }

    private int findEmptyHotkey() {
        for (int i = 0; i < this.hotkeysModeArr.length; ++i) {
            if (this.hotkeysModeArr[i] >= 0) continue;
            return i;
        }
        return 3;
    }

    private int findHotkeyForMode(int mode_id) {
        for (int i = 0; i < this.hotkeysModeArr.length; ++i) {
            if (this.hotkeysModeArr[i] != mode_id) continue;
            return i;
        }
        return -1;
    }

    private void sendHotKeyEdits(int hotkey_id, int mode_id) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new WhisltleEditHotKeyData(hotkey_id, mode_id));
    }

    @Override
    protected void onEntrySelected(int id) {
        this.proccessSelectIndx(id);
    }

    private void proccessSelectIndx(int indx) {
        if (this.settingKeysMode) {
            int new_mode_id = this.modeList.get(indx).getIndex();
            int send_key = this.pKey;
            int occupied_key = this.findHotkeyForMode(new_mode_id);
            if (occupied_key >= 0) {
                new_mode_id = -1;
                send_key = occupied_key;
            }
            this.sendHotKeyEdits(send_key, new_mode_id);
        } else {
            this.requestMode(this.modeList.get(indx).getIndex());
            class_310.method_1551().method_1507(null);
        }
    }

    private void requestMode(int id) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new WhistleRequestModeData(id, this.dogOnDutyOnly));
    }

    @Override
    public boolean method_25421() {
        return false;
    }
}

