/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.DogSounds;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.LangUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_6010;
import net.minecraft.class_6012;
import org.apache.commons.lang3.tuple.Pair;

public class DogMoodManager {
    private final Dog dog;
    private int happiness = 0;
    private int toUpdateTimestamp = 0;
    private static final List<Supplier<class_3414>> minor_ambient = List.of(DogSounds.ANGRY_BARK3, DogSounds.ANGRY_BARK2, DogSounds.ANGRY_BARK1, DogSounds.CUTE_GROWL1, DogSounds.CUTE_GROWL3, DogSounds.PUGLIN_GROWL3, DogSounds.CUTE_PANTING);
    private static final List<Supplier<class_3414>> perfect_neutral_ambient = List.of(DogSounds.CLASSIC_BARK1, DogSounds.CLASSIC_BARK2, DogSounds.CLASSIC_BARK3, DogSounds.CLASSIC_PANTING);
    private static final class_6012<Supplier<class_3414>> augmented_neutral_ambient = class_6012.method_34989((class_6010[])new class_6010[]{new class_6010(DogSounds.GRUMPY_BARK2, 6), new class_6010(DogSounds.GRUMPY_BARK3, 6), new class_6010(DogSounds.CUTE_BARK1, 4), new class_6010(DogSounds.CUTE_BARK3, 4), new class_6010(DogSounds.PUGLIN_BARK2, 1)});
    private static final List<Supplier<class_3414>> major_ambient = List.of(DogSounds.SAD_BARK1, DogSounds.PUGLIN_BARK2, DogSounds.PUGLIN_BARK3, DogSounds.GRUMPY_BARK1, DogSounds.CUTE_BARK2, DogSounds.CUTE_BARK1, DogSounds.CUTE_BARK3, DogSounds.GRUMPY_BARK2, DogSounds.GRUMPY_BARK3);
    private float recordedHealth = 0.0f;
    private int lastHurt = 0;
    private boolean chainHurt = false;
    private static final List<Supplier<class_3414>> forte_hurt = List.of(DogSounds.ANGRY_HURT3, DogSounds.ANGRY_HURT2, DogSounds.GRUMPY_HURT1, DogSounds.CLASSIC_HURT1, DogSounds.CLASSIC_HURT2, DogSounds.CLASSIC_HURT3, DogSounds.BIG_HURT3, DogSounds.CUTE_HURT3);
    private static final List<Supplier<class_3414>> piano_hurt = List.of(DogSounds.BIG_HURT1, DogSounds.SAD_HURT1, DogSounds.PUGLIN_HURT1, DogSounds.PUGLIN_HURT2);
    private static final List<Supplier<class_3414>> tremolo_hurt = List.of(DogSounds.CLASSIC_HURT1, DogSounds.CLASSIC_HURT2, DogSounds.CLASSIC_HURT3, DogSounds.CUTE_HURT3);
    private static final List<Supplier<class_3414>> death_sounds_non_tremolo = List.of(DogSounds.ANGRY_HURT1, DogSounds.CLASSIC_DEATH, DogSounds.SAD_DEATH);
    private static final List<Supplier<class_3414>> death_sounds = List.of(DogSounds.CLASSIC_DEATH, DogSounds.SAD_DEATH);
    private static final List<Supplier<class_3414>> injured_ambient = List.of(DogSounds.CLASSIC_WHINE, DogSounds.SAD_WHINE, DogSounds.CUTE_PANTING);
    private static final List<Supplier<class_3414>> serious_growl = List.of(DogSounds.ANGRY_GROWL2, DogSounds.ANGRY_GROWL3, DogSounds.PUGLIN_GROWL1, DogSounds.GRUMPY_GROWL3);
    private static final List<Supplier<class_3414>> sneeze_sounds = List.of(DogSounds.SAD_BARK3, DogSounds.SAD_HURT3_ALT);
    private static final class_6012<Supplier<class_3414>> greet_whine = class_6012.method_34989((class_6010[])new class_6010[]{new class_6010(DogSounds.CLASSIC_WHINE, 3), new class_6010(DogSounds.SAD_WHINE, 3), new class_6010(DogSounds.PUGLIN_WHINE, 1), new class_6010(DogSounds.CUTE_WHINE, 1)});
    private static final List<Supplier<class_3414>> jealous_sound = List.of(DogSounds.CUTE_WHINE, DogSounds.ANGRY_WHINE, DogSounds.BIG_WHINE);
    private static final List<Supplier<class_3414>> down_the_hole = List.of(DogSounds.CUTE_BARK1, DogSounds.GRUMPY_BARK1, DogSounds.SAD_BARK1);
    private static final List<Supplier<class_3414>> aww_sound = List.of(DogSounds.CUTE_HURT1_ALT, DogSounds.CLASSIC_WHINE, DogSounds.SAD_HURT2_ALT);
    private static final List<Supplier<class_3414>> whine_attention = List.of(DogSounds.PUGLIN_WHINE, DogSounds.SAD_WHINE, DogSounds.ANGRY_WHINE);
    private static final List<Supplier<class_3414>> protest_sound = List.of(DogSounds.GRUMPY_GROWL1, DogSounds.CUTE_GROWL2, DogSounds.GRUMPY_WHINE, DogSounds.CUTE_WHINE);
    private static final List<Supplier<class_3414>> petting_ambient = List.of(DogSounds.BIG_WHINE, DogSounds.BIG_PANTING, DogSounds.ANGRY_PANTING, DogSounds.CLASSIC_PANTING);
    private static final List<Supplier<class_3414>> sniffer_dog_forte = List.of(DogSounds.SAD_GROWL2, DogSounds.GRUMPY_HURT2_ALT);
    private static final List<Supplier<class_3414>> sniffer_dog_piano = List.of(DogSounds.CLASSIC_BARK1, DogSounds.CLASSIC_BARK2, DogSounds.CLASSIC_BARK3);
    private static Set<class_3414> force_interruptible_sounds = null;

    public DogMoodManager(Dog dog) {
        this.dog = dog;
    }

    public void tickServer() {
        if (this.dog.field_6012 >= this.toUpdateTimestamp) {
            this.toUpdateTimestamp = this.dog.field_6012 + this.getUpdateInterval();
            this.happiness = this.getNextMood();
        }
    }

    private int getNextMood() {
        float away_from_normal = 0.04f;
        int ret = 0;
        if (this.dog.method_59922().method_43057() <= 0.04f) {
            ret = this.dog.method_59922().method_43056() ? 1 : -1;
            int non_normal_time = this.getUpdateInterval() * this.getNonNormalTime();
            this.toUpdateTimestamp = this.dog.field_6012 + non_normal_time;
        }
        return ret;
    }

    public int getNonNormalTime() {
        float split = 0.8f;
        int split_map = 6;
        int max_time = 15;
        float r = this.dog.method_59922().method_43057();
        if (r < 0.8f) {
            int ret = class_3532.method_15375((float)(r / 0.8f * 6.0f));
            return 1 + class_3532.method_15340((int)ret, (int)0, (int)15);
        }
        int ret = 6 + class_3532.method_15375((float)((r - 0.8f) / 0.19999999f * 9.0f));
        return 1 + class_3532.method_15340((int)ret, (int)0, (int)15);
    }

    public int getHappiness() {
        return this.happiness;
    }

    public int getUpdateInterval() {
        return 400;
    }

    public class_3414 getAmbientSound() {
        boolean is_aug;
        if (this.dog.method_73183().field_9236) {
            return DogSounds.CLASSIC_BARK1.get();
        }
        int current_diff = this.happiness;
        List<Supplier<class_3414>> selected_list = perfect_neutral_ambient;
        if (current_diff != 0) {
            float non_neutral_chance = current_diff < 0 ? 0.5f : 0.9f;
            float r = this.dog.method_59922().method_43057();
            if (r < non_neutral_chance) {
                selected_list = current_diff > 0 ? major_ambient : minor_ambient;
            }
        }
        float aug_chance = 0.1f;
        if (this.happiness < 0) {
            aug_chance = 0.01f;
        } else if (this.happiness > 0) {
            aug_chance = 0.5f;
        }
        boolean bl = is_aug = selected_list == perfect_neutral_ambient && this.dog.method_59922().method_43057() <= aug_chance;
        if (is_aug) {
            return (class_3414)((Supplier)augmented_neutral_ambient.method_34992(this.dog.method_59922()).get()).get();
        }
        return LangUtil.getRandomItem(this.dog.method_59922(), selected_list).get().get();
    }

    public void onStartHurting(float current_health) {
        this.recordedHealth = this.dog.method_6032();
        this.chainHurt = this.dog.field_6012 - this.lastHurt <= 16;
        this.lastHurt = this.dog.field_6012;
    }

    public class_3414 getHurtSound(class_1282 source) {
        boolean chain_hurt;
        List<Supplier<class_3414>> hurt_list = piano_hurt;
        if (this.recordedHealth - this.dog.method_6032() >= 4.0f) {
            hurt_list = forte_hurt;
        }
        if (chain_hurt = this.chainHurt) {
            hurt_list = tremolo_hurt;
        }
        return LangUtil.getRandomItem(this.dog.method_59922(), hurt_list).get().get();
    }

    public class_3414 getLowHealthWhine() {
        return DogSounds.CLASSIC_WHINE.get();
    }

    public class_3414 getDeathSound() {
        return LangUtil.getRandomItem(this.dog.method_59922(), this.chainHurt ? death_sounds : death_sounds_non_tremolo).get().get();
    }

    public class_3414 getInjuredAmbient() {
        return LangUtil.getRandomItem(this.dog.method_59922(), injured_ambient).get().get();
    }

    public class_3414 getSeriousGrowl() {
        return LangUtil.getRandomItem(this.dog.method_59922(), serious_growl).get().get();
    }

    public class_3414 getSniffSound() {
        return DogSounds.SAD_PANTING.get();
    }

    public class_3414 getSneezeSound() {
        return LangUtil.getRandomItem(this.dog.method_59922(), sneeze_sounds).get().get();
    }

    public class_3414 getGreetWhine() {
        return (class_3414)((Supplier)greet_whine.method_34992(this.dog.method_59922()).get()).get();
    }

    public class_3414 getJealousSound() {
        return LangUtil.getRandomItem(this.dog.method_59922(), jealous_sound).get().get();
    }

    public class_3414 getDownTheHoleSound() {
        return LangUtil.getRandomItem(this.dog.method_59922(), down_the_hole).get().get();
    }

    public class_3414 getAwwSound() {
        return LangUtil.getRandomItem(this.dog.method_59922(), aww_sound).get().get();
    }

    public class_3414 getWhineAttentionSound() {
        return LangUtil.getRandomItem(this.dog.method_59922(), whine_attention).get().get();
    }

    public class_3414 getProtestSound() {
        return LangUtil.getRandomItem(this.dog.method_59922(), protest_sound).get().get();
    }

    public Pair<class_3414, Boolean> getPettingAmbient() {
        float r = this.dog.method_59922().method_43057();
        class_3414 sound = null;
        sound = r <= 0.2f ? DogSounds.CLASSIC_WHINE.get() : LangUtil.getRandomItem(this.dog.method_59922(), petting_ambient).get().get();
        boolean is_classic = sound == DogSounds.CLASSIC_PANTING.get() || sound == DogSounds.CLASSIC_WHINE.get();
        return Pair.of((Object)sound, (Object)is_classic);
    }

    public class_3414 getSnifferDogForteSound() {
        return LangUtil.getRandomItem(this.dog.method_59922(), sniffer_dog_forte).get().get();
    }

    public class_3414 getSnifferDogPianoSound() {
        return LangUtil.getRandomItem(this.dog.method_59922(), sniffer_dog_piano).get().get();
    }

    public boolean isForceInteruptibleSound(class_3414 sound) {
        if (force_interruptible_sounds == null) {
            force_interruptible_sounds = new HashSet<class_3414>(List.of(DogSounds.CUTE_PANTING.get(), DogSounds.SAD_WHINE.get()));
        }
        return force_interruptible_sounds.contains(sound);
    }
}

