/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogSleepOnManager;
import doggytalents.common.entity.anim.DogPose;
import java.util.EnumSet;
import net.minecraft.class_1352;

public class DogAllowSleepOnGoal
extends class_1352 {
    private final Dog dog;
    private int timeout = 60;
    private int sitUpTime = 0;
    private boolean isRestingPeriod = false;

    public DogAllowSleepOnGoal(Dog dog) {
        this.dog = dog;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        DogSleepOnManager.PerDog sleep_on_manger = this.dog.sleepOnManager;
        if (!sleep_on_manger.isSleepOnRequested()) {
            return false;
        }
        if (this.dog.isDefeated()) {
            return false;
        }
        if (!this.dog.method_24345()) {
            return false;
        }
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.method_5809()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (!this.dog.method_24828()) {
            return false;
        }
        return DogSleepOnManager.getServer(this.dog.method_73183()).isSleepCondition(this.dog).ok();
    }

    public boolean method_6266() {
        if (this.dog.isDefeated()) {
            return false;
        }
        if (!this.dog.method_24345()) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (!this.dog.method_6172()) {
            return false;
        }
        if (!this.dog.method_24828()) {
            return false;
        }
        if (!DogSleepOnManager.getServer(this.dog.method_73183()).isSleepCondition(this.dog).ok()) {
            return false;
        }
        return this.sitUpTime >= 0;
    }

    public void method_6269() {
        this.timeout = DogAnimation.LIE_SIDEWAY_LOOP.getLengthTicks() * 3;
        this.isRestingPeriod = true;
        this.sitUpTime = DogAnimation.LIE_SIDEWAY_END.getLengthTicks();
        this.dog.setAnimForIdle(DogAnimation.LIE_SIDEWAY_START);
        this.dog.sleepOnManager.setSleepOnReady(true);
    }

    public void method_6270() {
        DogAnimation anim = this.dog.getAnim();
        if (!anim.interupting()) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        DogSleepOnManager.onSleepGoalStop(this.dog);
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        if (this.isRestingPeriod) {
            if (this.dog.getAnim() == DogAnimation.LIE_SIDEWAY_START && this.dog.animationManager.isHolding() || this.dog.getAnim() == DogAnimation.NONE) {
                this.dog.setAnim(DogAnimation.LIE_SIDEWAY_LOOP);
            }
        } else {
            --this.sitUpTime;
        }
        if (this.isRestingPeriod) {
            this.updateRestingPeriod();
        }
    }

    private void updateRestingPeriod() {
        boolean finished;
        boolean is_sleeping_on = this.dog.getSleepOnState().is_sleeping();
        this.timeout = !is_sleeping_on ? Math.max(0, this.timeout - 1) : 60;
        boolean bl = finished = !is_sleeping_on && this.timeout <= 0;
        if (finished) {
            this.isRestingPeriod = false;
            this.dog.setAnim(DogAnimation.LIE_SIDEWAY_END);
            this.dog.sleepOnManager.onSleepOnGoalStop();
            return;
        }
    }
}

