/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.RingSearchIterator;
import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3486;

public class DogFindWaterGoal
extends class_1352 {
    private static final int SEARCH_RANGE = 6;
    private Dog dog;
    private int searchAgainAt;
    private int holdTime;
    private class_2338 waterPos;
    private class_11 tempPath;

    public DogFindWaterGoal(Dog dog) {
        this.dog = dog;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.dog.method_5753()) {
            return false;
        }
        if (this.dog.shouldDogNotAfraidOfFire()) {
            return false;
        }
        if (!this.dog.method_24828()) {
            return false;
        }
        if (!this.dog.method_5809()) {
            return false;
        }
        this.waterPos = null;
        if (this.dog.field_6012 >= this.searchAgainAt) {
            this.searchAgainAt = this.dog.field_6012 + 10;
            this.waterPos = this.searchForWaterPos();
        }
        if (this.waterPos == null) {
            return false;
        }
        class_11 path = this.dog.method_5942().method_6348(this.waterPos, 1);
        if (path == null || !DogUtil.canPathReachTargetBlock(this.dog, path, this.waterPos, 1, 1)) {
            this.searchAgainAt = this.dog.field_6012 + 20;
            return false;
        }
        this.tempPath = path;
        return true;
    }

    public boolean method_6266() {
        if (!this.dog.method_5809()) {
            return false;
        }
        if (this.waterPos == null) {
            return false;
        }
        return this.holdTime > 0;
    }

    public void method_6269() {
        this.dog.method_5942().method_6334(this.tempPath, (double)this.dog.getUrgentSpeedModifier());
        this.tempPath = null;
        this.holdTime = 5;
    }

    public void method_6270() {
        this.tempPath = null;
        this.waterPos = null;
    }

    public void method_6268() {
        class_1408 nav = this.dog.method_5942();
        if (this.waterPos != null && !this.isWaterPos(this.waterPos)) {
            this.waterPos = null;
        }
        if (nav.method_6357()) {
            if (this.holdTime == 5 && this.waterPos != null && nav.method_6357() && this.dog.method_24515().method_10262((class_2382)this.waterPos) <= 1.0) {
                this.dog.method_5962().method_6239((double)this.waterPos.method_10263() + 0.5, (double)this.waterPos.method_10264(), (double)this.waterPos.method_10260() + 0.5, 1.0);
            }
            --this.holdTime;
        }
    }

    private class_2338 searchForWaterPos() {
        for (class_2338 pos : RingSearchIterator.createWithRandom(this.dog.method_24515(), 4, 6, true, this.dog.method_59922())) {
            if (!this.isWaterPos(pos)) continue;
            return pos;
        }
        return null;
    }

    private boolean isWaterPos(class_2338 pos) {
        if (pos == null) {
            return false;
        }
        if (this.dog.method_73183().method_8316(pos).method_15767(class_3486.field_15517)) {
            return true;
        }
        return this.dog.method_73183().method_8520(pos);
    }
}

