/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.CachedSearchUtil.DogGreedyFireSafeSearchPath;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_7;
import net.minecraft.class_9;

public class DogGoAwayFromFireGoal
extends class_1352 {
    private Dog dog;
    private int tickUntilSearch;
    private int lastGoAwayTimestamp;
    private int walkableUntilStop = 1;
    private DogGreedyFireSafeSearchPath path;

    public DogGoAwayFromFireGoal(Dog dog) {
        this.dog = dog;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.dog.method_5753()) {
            return false;
        }
        if (this.dog.shouldDogNotAfraidOfFire()) {
            return false;
        }
        int dangerSpot = -1;
        if (--this.tickUntilSearch <= 0) {
            this.tickUntilSearch = 3;
            dangerSpot = this.isDogInDangerSpot(this.dog.method_73189());
        }
        if (dangerSpot == -1) {
            return false;
        }
        this.path = DogGreedyFireSafeSearchPath.create(this.dog, 10);
        if (this.path == null || !this.checkCanReplaceCurrentPath(this.dog, this.path)) {
            this.tickUntilSearch = 5;
            this.path = null;
            return false;
        }
        return true;
    }

    private boolean checkCanReplaceCurrentPath(Dog dog, DogGreedyFireSafeSearchPath new_path) {
        class_11 current_path = this.dog.method_5942().method_6345();
        if (current_path == null) {
            return true;
        }
        if (current_path.method_46()) {
            return true;
        }
        class_9 current_next_node = current_path.method_29301();
        float current_next_malus = dog.method_5944(current_next_node.field_41);
        float new_next_malus = dog.method_5944(new_path.method_40((int)0).field_41);
        return new_next_malus < current_next_malus;
    }

    public boolean method_6266() {
        boolean is_safe;
        if (this.path == null) {
            return false;
        }
        if (this.dog.method_5942().method_6357()) {
            return false;
        }
        boolean bl = is_safe = this.path.getWalkableCount() >= this.walkableUntilStop && this.checkAboveForFallingLava(this.dog.method_24515());
        return !is_safe;
    }

    public void method_6269() {
        if (this.path == null) {
            return;
        }
        class_1408 nav = this.dog.method_5942();
        nav.method_6340();
        nav.method_6334((class_11)this.path, (double)this.dog.getUrgentSpeedModifier());
        class_2338 b0 = this.path.method_40(0).method_22879();
        DogUtil.stopAndForceLook(this.dog, b0.method_46558());
        this.dog.method_5962().method_6239((double)((float)b0.method_10263() + 0.5f), (double)b0.method_10264(), (double)((float)b0.method_10260() + 0.5f), (double)this.dog.getUrgentSpeedModifier());
        this.dog.setDogForcePushAvoid(true);
        int tick_since_last = this.dog.field_6012 - this.lastGoAwayTimestamp;
        this.walkableUntilStop = tick_since_last >= 20 ? 1 : 2;
    }

    public void method_6270() {
        this.dog.setDogForcePushAvoid(false);
        this.tickUntilSearch = 5;
        this.lastGoAwayTimestamp = this.dog.field_6012;
        this.proccessEndNode();
        this.dog.method_5942().method_6340();
    }

    private void proccessEndNode() {
        if (this.path == null) {
            return;
        }
        class_9 end_node = this.path.method_45();
        if (end_node == null) {
            return;
        }
        class_2338 b0 = end_node.method_22879();
        this.dog.method_5962().method_6239((double)((float)b0.method_10263() + 0.5f), (double)b0.method_10264(), (double)((float)b0.method_10260() + 0.5f), (double)this.dog.getUrgentSpeedModifier());
        if (end_node.field_41 != class_7.field_12) {
            this.tickUntilSearch = 20 + this.dog.method_59922().method_43048(3) * 10;
        }
    }

    private byte isDogInDangerSpot(class_243 pos) {
        double FLUID_BB_DEFLATE = 0.001;
        double half_bbw = 0.5 * (double)this.dog.method_17681() - 0.001;
        int min_x = class_3532.method_15357((double)(pos.field_1352 - half_bbw)) - 1;
        int min_y = class_3532.method_15357((double)pos.field_1351);
        int min_z = class_3532.method_15357((double)(pos.field_1350 - half_bbw)) - 1;
        int max_x = class_3532.method_15357((double)(pos.field_1352 + half_bbw)) + 1;
        int max_y = class_3532.method_15357((double)(pos.field_1351 + 1.0));
        int max_z = class_3532.method_15357((double)(pos.field_1350 + half_bbw)) + 1;
        byte ret = -1;
        for (class_2338 check_pos : class_2338.method_10094((int)min_x, (int)min_y, (int)min_z, (int)max_x, (int)max_y, (int)max_z)) {
            boolean is_corner;
            boolean bl = is_corner = !(check_pos.method_10263() != min_x && check_pos.method_10263() != max_x || check_pos.method_10260() != min_z && check_pos.method_10260() != max_z);
            if (is_corner) continue;
            class_238 dog_bb = this.dog.method_5829();
            boolean above_outside = check_pos.method_10264() > min_y && !dog_bb.method_994(new class_238(new class_2338(check_pos.method_10263(), min_y, check_pos.method_10260())));
            if (above_outside) continue;
            class_2680 state = this.dog.method_73183().method_8320(check_pos);
            if (state.method_26227().method_15767(class_3486.field_15518)) {
                return 1;
            }
            class_238 check_pos_bb = new class_238(check_pos);
            boolean pos_within_dog_bb = this.dog.method_5829().method_994(check_pos_bb);
            if (!pos_within_dog_bb) continue;
            boolean is_burning = class_14.method_57082((class_2680)state);
            if (is_burning) {
                return 1;
            }
            if (check_pos.method_10264() != min_y) continue;
            class_2338 pos_below = DogUtil.getSurfaceStandingInPos(this.dog, check_pos.method_10263(), check_pos.method_10260()).method_10074();
            class_2680 state_below = this.dog.method_73183().method_8320(pos_below);
            boolean full_collision_burning_block = class_14.method_57082((class_2680)state_below) && state_below.method_26234((class_1922)this.dog.method_73183(), pos_below);
            if (!full_collision_burning_block) continue;
            return 1;
        }
        return ret;
    }

    private boolean checkAboveForFallingLava(class_2338 pos) {
        class_2338 pos_above = pos.method_10084();
        class_2680 state_above = this.dog.method_73183().method_8320(pos_above);
        return !state_above.method_27852(class_2246.field_10164);
    }

    public boolean method_38846() {
        return true;
    }
}

