/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTalents;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.CompoundTag_1_21_7;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11979;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.class_9381;

public class DogArrow
extends class_1665 {
    private static final int NULL_COLOR = -1;
    private static final class_2940<Integer> EFFECT_COLOR = class_2945.method_12791(DogArrow.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_SPECTRAL = class_2945.method_12791(DogArrow.class, (class_2941)class_2943.field_13323);
    private Optional<UUID> dogOwnerUUID = Optional.empty();

    public DogArrow(class_1299<DogArrow> p_36858_, class_1937 p_36859_) {
        super(p_36858_, p_36859_);
    }

    public DogArrow(class_1937 p_36861_, AbstractDog dog, class_1799 stack, class_1799 proj_stack) {
        super(DoggyEntityTypes.DOG_ARROW_PROJ.get(), (class_1309)dog, p_36861_, stack, proj_stack);
        class_1309 owner;
        this.updateColor();
        if (stack.method_31574(class_1802.field_8236)) {
            this.field_6011.method_12778(IS_SPECTRAL, (Object)true);
        }
        if ((owner = dog.method_35057()) != null) {
            this.dogOwnerUUID = Optional.ofNullable(owner.method_5667());
        }
    }

    protected void method_5693(class_2945.class_9222 p_326324_) {
        super.method_5693(p_326324_);
        p_326324_.method_56912(EFFECT_COLOR, (Object)-1);
        p_326324_.method_56912(IS_SPECTRAL, (Object)false);
    }

    private class_1844 getPotionContents() {
        return (class_1844)this.method_54759().method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
    }

    private boolean hasPotionContents() {
        class_1844 data = this.getPotionContents();
        return data != class_1844.field_49274;
    }

    private void clearPotionContents() {
        this.method_57313(new class_1799((class_1935)class_1802.field_8107));
    }

    protected void method_57313(class_1799 p_331667_) {
        super.method_57313(p_331667_);
        this.updateColor();
    }

    private void updateColor() {
        int update_color = -1;
        if (this.hasPotionContents()) {
            update_color = this.getPotionContents().method_8064();
        }
        this.field_6011.method_12778(EFFECT_COLOR, (Object)update_color);
    }

    public void method_5773() {
        super.method_5773();
        if (this.isDogSpectralArrow()) {
            this.updateSpectralArrow();
        } else if (this.method_73183().field_9236) {
            this.makeClientArrowParticle();
        } else {
            this.updateEffectTimeout();
        }
    }

    private void makeClientArrowParticle() {
        int color = this.getColor();
        if (this.method_65059()) {
            if (this.field_7576 % 5 == 0) {
                this.makeParticle(1, color);
            }
        } else {
            this.makeParticle(2, color);
        }
    }

    private void updateEffectTimeout() {
        boolean effect_expired;
        boolean bl = effect_expired = this.method_65059() && this.field_7576 >= 600 && this.hasPotionContents();
        if (effect_expired) {
            this.clearPotionContents();
        }
    }

    private void updateSpectralArrow() {
        if (this.method_73183().field_9236 && !this.method_65059()) {
            this.method_73183().method_8406((class_2394)class_11979.method_74419((class_2396)class_2398.field_11245, (int)-1, (float)1.0f), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    private void makeParticle(int amount, int color) {
        if (color == -1 || amount <= 0) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            this.method_73183().method_8406((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)color), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
        }
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(EFFECT_COLOR);
    }

    public boolean isDogSpectralArrow() {
        return (Boolean)this.field_6011.method_12789(IS_SPECTRAL);
    }

    protected void method_7450(class_1309 target) {
        super.method_7450(target);
        if (this.isDogSpectralArrow()) {
            this.doDogSpectralArrowEffectHurt(target);
        } else {
            this.doNormalDogArrowEffectHurt(target);
        }
        this.killCreeperIfCreeperSweeper(target);
    }

    private void doNormalDogArrowEffectHurt(class_1309 target) {
        class_1297 effect_source = this.method_37225();
        class_1844 potion_contents = this.getPotionContents();
        if (potion_contents.comp_2378().isPresent()) {
            for (class_1293 effect_inst : ((class_1842)((class_6880)potion_contents.comp_2378().get()).comp_349()).method_8049()) {
                target.method_37222(new class_1293(effect_inst.method_5579(), Math.max(effect_inst.method_48558(x -> x / 8), 1), effect_inst.method_5578(), effect_inst.method_5591(), effect_inst.method_5581()), effect_source);
            }
        }
        for (class_1293 custom_effect_inst : potion_contents.comp_2380()) {
            target.method_37222(custom_effect_inst, effect_source);
        }
    }

    private void doDogSpectralArrowEffectHurt(class_1309 target) {
        class_1293 glow_inst = new class_1293(class_1294.field_5912, 200, 0);
        target.method_37222(glow_inst, this.method_37225());
    }

    private void killCreeperIfCreeperSweeper(class_1309 target) {
        class_1297 owner = this.method_24921();
        if (!(owner instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)owner;
        if (dog.getDogLevel(DoggyTalents.CREEPER_SWEEPER) < 5) {
            return;
        }
        if (!(target instanceof class_1548)) {
            return;
        }
        class_1548 creeper = (class_1548)target;
        creeper.method_6033(0.0f);
        creeper.method_6078(dog.method_48923().method_48812((class_1309)dog));
    }

    protected class_1799 method_57314() {
        return new class_1799((class_1935)class_1802.field_8107);
    }

    protected boolean method_34713(class_1657 picker) {
        if (this.shouldDogArrowBlockPickup(picker)) {
            return false;
        }
        return super.method_34713(picker);
    }

    private boolean shouldDogArrowBlockPickup(class_1657 picker) {
        if (picker.method_68878()) {
            return false;
        }
        if (!this.dogOwnerUUID.isPresent()) {
            return false;
        }
        return !this.dogOwnerUUID.get().equals(picker.method_5667());
    }

    public void method_5652(class_11372 tag) {
        super.method_5652(tag);
        this.dogOwnerUUID.ifPresent(x -> CompoundTag_1_21_7.wrap(tag).putUUID("dtn_dog_owner_id", (UUID)x));
    }

    public void method_5749(class_11368 tag) {
        super.method_5749(tag);
        if (CompoundTag_1_21_5.wrap(tag).hasUUID("dtn_dog_owner_id")) {
            UUID uuid = CompoundTag_1_21_5.wrap(tag).getUUID("dtn_dog_owner_id");
            this.dogOwnerUUID = Optional.ofNullable(uuid);
        }
    }
}

