/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.api.feature.DogMode;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogAttackManager;
import doggytalents.common.util.PlayerUtil;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2945;
import net.minecraft.class_3966;

public class DoggyBeamEntity
extends class_1682 {
    public DoggyBeamEntity(class_1299<? extends class_1682> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    public DoggyBeamEntity(class_1937 worldIn, class_1309 livingEntityIn) {
        super(DoggyEntityTypes.DOG_BEAM.get(), livingEntityIn.method_23317(), livingEntityIn.method_23320() - (double)0.1f, livingEntityIn.method_23321(), worldIn);
        this.method_7432((class_1297)livingEntityIn);
    }

    protected void method_7488(class_239 result) {
        if (result.method_17783() == class_239.class_240.field_1331) {
            if (!this.method_73183().field_9236) {
                this.mayTriggerNearbyDogs((class_3966)result);
            } else {
                for (int j = 0; j < 8; ++j) {
                    this.method_73183().method_8406((class_2394)class_2398.field_11230, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                }
            }
        }
        if (!this.method_73183().field_9236) {
            this.method_31472();
        }
    }

    private void mayTriggerNearbyDogs(class_3966 hitResult) {
        class_1297 class_12972 = hitResult.method_17782();
        if (!(class_12972 instanceof class_1309)) {
            return;
        }
        class_1309 hit = (class_1309)class_12972;
        class_1297 class_12973 = this.method_24921();
        if (!(class_12973 instanceof class_1657)) {
            return;
        }
        class_1657 thrower = (class_1657)class_12973;
        boolean do_cooldown = false;
        class_238 trigger_bb = thrower.method_5829().method_1009(16.0, 8.0, 16.0);
        List trigger_list = this.method_73183().method_8390(Dog.class, trigger_bb, filter_dog -> this.isEligibleDog((Dog)filter_dog, hit, (class_1309)thrower));
        do_cooldown = !trigger_list.isEmpty();
        int trigger_limit = (Integer)ConfigHandler.SERVER.TACTICAL_LIMIT.get();
        if (trigger_limit > 0 && trigger_list.size() > trigger_limit) {
            Collections.shuffle(trigger_list);
            trigger_list = trigger_list.subList(0, trigger_limit);
        }
        for (Dog dog : trigger_list) {
            DogAttackManager attack_manager = dog.dogAttackManager;
            attack_manager.setDogTaticalTarget(hit);
        }
        if (do_cooldown) {
            PlayerUtil.addCooldown(thrower, DoggyItems.WHISTLE.get(), 40);
        }
    }

    private boolean isEligibleDog(Dog dog, class_1309 target, class_1309 thrower) {
        if (dog == target) {
            return false;
        }
        if (dog.method_24345()) {
            return false;
        }
        UUID dog_owner_id = dog.getOwnerUUID();
        UUID thrower_id = thrower.method_5667();
        if (dog_owner_id == null) {
            return false;
        }
        if (!dog_owner_id.equals(thrower_id)) {
            return false;
        }
        if (!dog.method_6178(target, thrower)) {
            return false;
        }
        double target_dist_sqr = dog.method_5858((class_1297)target);
        DogAttackManager attack_manager = dog.dogAttackManager;
        double range_far = attack_manager.getFarFollowRange();
        boolean tactical_condition = dog.getMode() == DogMode.TACTICAL && target_dist_sqr < range_far * range_far;
        return tactical_condition;
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }
}

