/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.container;

import doggytalents.DoggyContainerTypes;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.inventory.container.slot.DogInventorySlot;
import doggytalents.common.talent.PackPuppyTalent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_3915;

public class DogInventoriesContainer
extends class_1703 {
    private class_1937 level;
    private class_1657 player;
    private class_3915 slotViewOffset;
    private final List<Dog> chestDogs;
    private final List<DogInventorySlot> dogSlots = new ArrayList<DogInventorySlot>();
    private int totalDogColsCount = 0;
    public static final int VIEW_OFFSET_DATA_ID = 0;
    private int dogSlotsStartsAt = 0;

    public DogInventoriesContainer(int windowId, class_1661 playerInventory, List<Dog> chestDogs) {
        super(DoggyContainerTypes.DOG_INVENTORIES.get(), windowId);
        this.level = playerInventory.field_7546.method_73183();
        this.player = playerInventory.field_7546;
        this.slotViewOffset = class_3915.method_17403();
        this.method_17362(this.slotViewOffset);
        this.chestDogs = chestDogs;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)playerInventory, col, 8 + col * 18, 142));
        }
        this.dogSlotsStartsAt = this.field_7761.size();
        this.addDogSlots();
    }

    public void addDogSlots() {
        int VIEWPORT_COLS = 9;
        int view_offset = this.slotViewOffset.method_17407();
        int current_col = 0;
        for (Dog dog : this.chestDogs) {
            PackPuppyItemHandler packInventory = dog.getTalent(DoggyTalents.PACK_PUPPY).map(inst -> inst.cast(PackPuppyTalent.class).inventory()).orElse(null);
            if (packInventory == null) continue;
            int dog_total_cols = class_3532.method_15340((int)dog.getDogLevel(DoggyTalents.PACK_PUPPY), (int)0, (int)5);
            for (int col = 0; col < dog_total_cols; ++col) {
                for (int row = 0; row < 3; ++row) {
                    boolean inside_of_viewport;
                    int slot_indx = col * 3 + row;
                    int abs_col = current_col + col;
                    int viewX = 8 + 18 * (current_col + col - view_offset);
                    int viewY = 18 * row + 18;
                    DogInventorySlot slot = new DogInventorySlot(dog, this.player, packInventory, abs_col, row, col, slot_indx, viewX, viewY);
                    this.addDogSlot(slot);
                    int viewport_col = slot.getAbsoluteCol() - view_offset;
                    boolean bl = inside_of_viewport = viewport_col >= 0 && viewport_col < 9;
                    if (inside_of_viewport) continue;
                    slot.setEnabled(false);
                }
            }
            this.totalDogColsCount += dog_total_cols;
            current_col += dog_total_cols;
        }
    }

    public void method_7606(int id, int data) {
        super.method_7606(id, data);
        if (id == 0) {
            this.reDrawDogSlots(data);
        }
    }

    private void reDrawDogSlots(int newViewOffset) {
        for (int i = 0; i < this.dogSlots.size(); ++i) {
            DogInventorySlot slot0 = this.dogSlots.get(i);
            DogInventorySlot new_slot = new DogInventorySlot(slot0, 8 + 18 * (slot0.getAbsoluteCol() - newViewOffset));
            this.replaceDogSlot(i, new_slot);
            int viewport_col = slot0.getAbsoluteCol() - newViewOffset;
            if (viewport_col >= 0 && viewport_col < 9) continue;
            new_slot.setEnabled(false);
        }
    }

    private void addDogSlot(DogInventorySlot slotIn) {
        this.method_7621(slotIn);
        this.dogSlots.add(slotIn);
    }

    private void replaceDogSlot(int i, DogInventorySlot slotIn) {
        this.dogSlots.set(i, slotIn);
        DogInventorySlot s = slotIn;
        this.field_7761.set(s.field_7874, (Object)slotIn);
    }

    public int getTotalNumColumns() {
        return this.totalDogColsCount;
    }

    public int getViewOffset() {
        return this.slotViewOffset.method_17407();
    }

    public void setViewOffset(int offset) {
        this.method_7606(0, offset);
    }

    public List<DogInventorySlot> getSlots() {
        return this.dogSlots;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public class_1799 method_7601(class_1657 player, int i) {
        class_1735 slot = (class_1735)this.field_7761.get(i);
        if (slot == null || !slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 moveStack0 = class_1799.field_8037;
        class_1799 moveStack = slot.method_7677();
        moveStack0 = moveStack.method_7972();
        boolean moveResult = false;
        boolean clickedDogSlot = i >= this.dogSlotsStartsAt && i < this.field_7761.size();
        moveResult = clickedDogSlot ? this.method_7616(moveStack, 0, this.dogSlotsStartsAt, true) : this.method_7616(moveStack, this.dogSlotsStartsAt, this.field_7761.size(), false);
        if (!moveResult) {
            return class_1799.field_8037;
        }
        if (moveStack.method_7960()) {
            slot.method_7673(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        if (moveStack.method_7947() == moveStack0.method_7947()) {
            return class_1799.field_8037;
        }
        return moveStack0;
    }
}

