/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.PlayerUtil;
import doggytalents.common.util.RandomUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class TreatItem
extends class_1792
implements IDogItem {
    private final int maxLevel;
    private final DogLevel.Type type;

    public TreatItem(int maxLevel, DogLevel.Type typeIn, class_1792.class_1793 properties) {
        super(properties);
        this.maxLevel = maxLevel;
        this.type = typeIn;
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dog, class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        if (!dog.method_6181() || !dog.canInteract((class_1309)playerIn)) {
            return DogInteractionResult.FAIL;
        }
        if (this.handleKamiBypass(dog, worldIn, playerIn, handIn).shouldSwing()) {
            return DogInteractionResult.SUCCESS;
        }
        return this.handleTreatTrain(dog, worldIn, playerIn, handIn);
    }

    private DogInteractionResult handleKamiBypass(AbstractDog dog, class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        if (this.type != DogLevel.Type.KAMI) {
            return DogInteractionResult.PASS;
        }
        if (!playerIn.method_68878()) {
            return DogInteractionResult.PASS;
        }
        DogLevel dog_level = dog.getDogLevel();
        if (dog_level.canIncrease(DogLevel.Type.KAMI)) {
            return DogInteractionResult.PASS;
        }
        if (!(dog instanceof Dog)) {
            return DogInteractionResult.PASS;
        }
        Dog actual_dog = (Dog)dog;
        if (!dog.method_73183().field_9236) {
            actual_dog.setLevel(DogLevel.kamiReady());
            PlayerUtil.addCooldown(playerIn, this, 40);
        }
        this.playKamiBypassEffect(actual_dog);
        return DogInteractionResult.SUCCESS;
    }

    private void playKamiBypassEffect(Dog dog) {
        class_1937 level = dog.method_73183();
        if (!level.field_9236) {
            return;
        }
        class_243 dog_pos = dog.method_73189();
        level.method_8486(dog_pos.field_1352, dog_pos.field_1351, dog_pos.field_1350, (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15245, 4.0f, (1.0f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.2f) * 0.7f, false);
        level.method_8406((class_2394)class_2398.field_11236, dog_pos.field_1352, dog_pos.field_1351, dog_pos.field_1350, 1.0, 0.0, 0.0);
        level.method_8406((class_2394)class_2398.field_11221, dog_pos.field_1352, dog_pos.field_1351, dog_pos.field_1350, 1.0, 0.0, 0.0);
        for (int i = 0; i <= 30; ++i) {
            float f1 = RandomUtil.nextFloatRemapped(dog.method_59922()) * dog.method_17681() * 1.0f;
            float f2 = RandomUtil.nextFloatRemapped(dog.method_59922()) * dog.method_17681() * 1.0f;
            double dx = level.method_8409().method_43059() * 0.3;
            double dy = level.method_8409().method_43059() * 0.3;
            double dz = level.method_8409().method_43059() * 0.3;
            dog.method_73183().method_8406((class_2394)class_2398.field_11214, dog.method_23317() + (double)f1, dog.method_23318(), dog.method_23321() + (double)f2, dx, dy, dz);
        }
    }

    private DogInteractionResult handleTreatTrain(AbstractDog dog, class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        if (dog.method_5618() < 0) {
            this.treatFailPrompt(dog, worldIn, playerIn, (class_2561)class_2561.method_43471((String)("treat." + this.type.getName() + ".too_young")));
            return DogInteractionResult.CONSUME;
        }
        DogLevel dogLevel = dog.getDogLevel();
        if (!dogLevel.canIncrease(this.type)) {
            this.treatFailPrompt(dog, worldIn, playerIn, (class_2561)class_2561.method_43471((String)("treat." + this.type.getName() + ".low_level")));
            return DogInteractionResult.CONSUME;
        }
        if (dogLevel.getLevel(this.type) >= this.maxLevel) {
            this.treatFailPrompt(dog, worldIn, playerIn, (class_2561)class_2561.method_43471((String)("treat." + this.type.getName() + ".max_level")));
            return DogInteractionResult.CONSUME;
        }
        if (!playerIn.method_73183().field_9236) {
            if (!playerIn.method_31549().field_7477) {
                playerIn.method_5998(handIn).method_7934(1);
            }
            dog.increaseLevel(this.type);
            dog.method_24346(true);
        }
        this.treatSuccessPrompt(dog, worldIn, playerIn);
        return DogInteractionResult.SUCCESS;
    }

    private void treatFailPrompt(AbstractDog dog, class_1937 worldIn, class_1657 playerIn, class_2561 msg) {
        if (!worldIn.field_9236) {
            worldIn.method_8421((class_1297)dog, (byte)6);
            PlayerUtil.sendSystemMessage((class_1309)playerIn, msg);
        }
    }

    private void treatSuccessPrompt(AbstractDog dog, class_1937 worldIn, class_1657 playerIn) {
        if (!worldIn.field_9236) {
            worldIn.method_8421((class_1297)dog, (byte)7);
            PlayerUtil.sendSystemMessage((class_1309)playerIn, (class_2561)class_2561.method_43471((String)("treat." + this.type.getName() + ".level_up")));
        }
    }
}

