/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogDeTrainData;
import doggytalents.common.util.NetworkUtil;
import doggytalents.common.util.PlayerUtil;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class DogDeTrainPacket
extends DogPacket<DogDeTrainData> {
    @Override
    public void encode(DogDeTrainData data, class_2540 buf) {
        super.encode(data, buf);
        NetworkUtil.writeTalentToBuf(buf, data.talent);
    }

    @Override
    public DogDeTrainData decode(class_2540 buf) {
        int entityId = buf.readInt();
        Talent talent = NetworkUtil.readTalentFromBuf(buf);
        return new DogDeTrainData(entityId, talent);
    }

    @Override
    public void handleDog(Dog dog, DogDeTrainData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        boolean talent_allow_detrain;
        class_3222 sender = ctx.get().getSender();
        class_1799 stack = sender.method_6047();
        if (stack.method_7909() != DoggyItems.AMNESIA_BONE.get()) {
            return;
        }
        if (PlayerUtil.isOnCooldown((class_1657)sender, DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID ownerUUID = dog.getOwnerUUID();
        if (ownerUUID == null) {
            return;
        }
        if (!ownerUUID.equals(sender.method_5667())) {
            return;
        }
        Talent talent = data.talent;
        Optional<TalentInstance> talent_inst_optional = dog.getTalent(talent);
        if (!talent_inst_optional.isPresent()) {
            return;
        }
        TalentInstance talent_inst = talent_inst_optional.get();
        int dog_level = talent_inst.level();
        if (dog_level <= 0) {
            return;
        }
        boolean bl = talent_allow_detrain = sender.method_64475(4) || talent_inst.allowDetrain(dog);
        if (!talent_allow_detrain) {
            return;
        }
        int xp_cost = talent.getDeTrainXPCost(dog_level);
        if (sender.field_7520 < xp_cost) {
            return;
        }
        dog.setTalentLevel(talent, 0);
        dog.clearTriggerableAction();
        PlayerUtil.addCooldown((class_1657)sender, DoggyItems.AMNESIA_BONE.get(), 20);
        sender.method_7316(-xp_cost);
    }
}

