/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.Screens;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.OpenDogScreenData;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.util.EntityUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class OpenDogScreenPacket
implements IPacket<OpenDogScreenData> {
    @Override
    public OpenDogScreenData decode(class_2540 buf) {
        OpenDogScreenData.ScreenType type = OpenDogScreenData.ScreenType.byId(buf.readInt());
        int dogId = buf.readInt();
        return new OpenDogScreenData(type, dogId);
    }

    @Override
    public void encode(OpenDogScreenData data, class_2540 buf) {
        buf.method_53002(data.type.getId());
        buf.method_53002(data.dogId);
    }

    @Override
    public void handle(OpenDogScreenData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                class_3222 player = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                this.selectAndOpenDogScreen(data, player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void selectAndOpenDogScreen(OpenDogScreenData data, class_3222 player) {
        switch (data.type) {
            case TOOL: {
                class_1297 e = player.method_51469().method_8469(data.dogId);
                if (!(e instanceof Dog)) break;
                Dog dog2 = (Dog)e;
                Screens.openDoggyToolsScreen(player, dog2);
                break;
            }
            case ARMOR: {
                class_1297 e = player.method_51469().method_8469(data.dogId);
                if (!(e instanceof Dog)) break;
                Dog dog3 = (Dog)e;
                Screens.openArmorScreen(player, dog3);
                break;
            }
            case INVENTORY_SINGLE: {
                class_1297 e = player.method_51469().method_8469(data.dogId);
                if (!(e instanceof Dog)) break;
                Dog dog4 = (Dog)e;
                Screens.openPackPuppyScreen(player, dog4);
                break;
            }
            default: {
                List<Dog> dogs = player.method_51469().method_8390(Dog.class, player.method_5829().method_1009(12.0, 12.0, 12.0), dog -> dog.canInteract((class_1309)player) && PackPuppyTalent.hasInventory(dog));
                Collections.sort(dogs, new EntityUtil.Sorter(player.method_73189()));
                if (dogs.size() > 8) {
                    dogs = dogs.subList(0, 8);
                }
                if (dogs.isEmpty()) break;
                Screens.openDogInventoriesScreen(player, dogs);
                break;
            }
        }
    }
}

