/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyItems;
import doggytalents.DoggyTalents;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogSleepOnManager;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.PlayerUtil;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public class BedDogTalent
extends TalentInstance {
    private long cooldownDealine = 0L;

    public BedDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    public void onSuccessfulSleep(AbstractDog dog) {
        float base_threshold;
        class_1937 level = dog.method_73183();
        this.cooldownDealine = level.method_8532() + (long)this.getCooldownTicks();
        float set_hunger = dog.getDogHunger();
        if (set_hunger > (base_threshold = (float)this.getBaseMinHungerForSleep()) && (set_hunger -= (float)this.getHungerCostPerSleep()) < base_threshold) {
            set_hunger = base_threshold;
        }
        dog.setDogHunger(set_hunger);
    }

    public boolean isOnCooldown(AbstractDog dog) {
        class_1937 level = dog.method_73183();
        return level.method_8532() < this.cooldownDealine;
    }

    public int getCooldownDaysLeft(AbstractDog dog) {
        class_1937 level = dog.method_73183();
        long time_till = this.cooldownDealine - level.method_8532();
        if (time_till <= 0L) {
            return 0;
        }
        return class_3532.method_15386((float)((float)time_till / 24000.0f));
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        this.cooldownDealine = compound.getLong("cooldown_end");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        compound.method_10544("cooldown_end", this.cooldownDealine);
    }

    @Override
    public boolean allowDetrain(AbstractDog dog) {
        return !this.isOnCooldown(dog);
    }

    public static void useBedDog(class_1937 level, class_1657 player) {
        if (level.field_9236) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30, filter_dog -> filter_dog.isDoingFine());
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        if (dog.getDogLevel(DoggyTalents.BED_DOG) <= 0) {
            return;
        }
        DogSleepOnManager.StartSleepOnDogResult result = DogSleepOnManager.getServer(level.method_8503()).setOrRequestSleepOn(dog, player);
        BedDogTalent.proccessResult(result, dog, player);
        if (result.isFailMsg(DogSleepOnManager.DogSleepOnFailMessage.NO_POS)) {
            PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 10);
        }
    }

    private static void proccessResult(DogSleepOnManager.StartSleepOnDogResult result, Dog dog, class_1657 player) {
        if (result.ok() || result.other()) {
            return;
        }
        if (result.isFailMsg(DogSleepOnManager.DogSleepOnFailMessage.COOLDOWN)) {
            BedDogTalent.sendCooldownMsg(dog, player);
            return;
        }
        PlayerUtil.sendSystemMessage((class_1309)player, result.failMsg().getMsg(dog));
    }

    private static void sendCooldownMsg(Dog dog, class_1657 player) {
        Optional<BedDogTalent> inst_optional = dog.getTalent(DoggyTalents.BED_DOG.get(), BedDogTalent.class);
        if (!inst_optional.isPresent()) {
            return;
        }
        BedDogTalent inst = inst_optional.get();
        PlayerUtil.sendSystemMessage((class_1309)player, (class_2561)class_2561.method_43469((String)"talent.doggytalents.bed_dog.fail.cooldown", (Object[])new Object[]{dog.method_5477().getString(), Integer.toString(inst.getCooldownDaysLeft(dog))}));
    }

    public static DogSleepOnManager.StartSleepOnDogResult isSleepCondition(Dog dog, BedDogTalent inst) {
        if (dog.getDogHunger() < (float)inst.getMinHungerForSleep()) {
            return DogSleepOnManager.DogSleepOnFailMessage.DOG_LOW_HUNGER.asResult();
        }
        if (inst.isOnCooldown(dog)) {
            return DogSleepOnManager.DogSleepOnFailMessage.COOLDOWN.asResult();
        }
        return DogSleepOnManager.StartSleepOnDogResult.OK;
    }

    public int getHungerCostPerSleep() {
        int level = this.level();
        if (level <= 3) {
            return 40;
        }
        if (level == 4) {
            return 30;
        }
        return 0;
    }

    public int getMinHungerForSleep() {
        return this.getHungerCostPerSleep() + this.getBaseMinHungerForSleep();
    }

    public int getBaseMinHungerForSleep() {
        return 20;
    }

    public int getCooldownTicks() {
        int level = this.level();
        if (level <= 3) {
            return 72000;
        }
        if (level == 4) {
            return 48000;
        }
        return 0;
    }
}

