/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import com.mojang.serialization.DynamicOps;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.backward_imitate.EntityUtil_1_21_5;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4081;
import net.minecraft.class_6880;

public class ChemiCanineTalent
extends TalentInstance {
    private final ArrayList<class_1293> storedEffects = new ArrayList();
    private final int SEARCH_RADIUS = 12;
    private int absorbEffectCooldown;
    private int tickTillSearch;
    private int tickTillEffectDecay = 0;

    public ChemiCanineTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        if (abstractDog.method_73183().field_9236) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        if (this.tickTillEffectDecay > 0) {
            --this.tickTillEffectDecay;
            if (this.tickTillEffectDecay <= 0 && !this.storedEffects.isEmpty()) {
                this.storedEffects.remove(0);
            }
        }
        if (this.absorbEffectCooldown > 0) {
            --this.absorbEffectCooldown;
            return;
        }
        if (dog.readyForNonTrivialAction() && !dog.method_24345() && --this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            class_1309 target = this.findTargetToAbsorb(abstractDog);
            if (target != null && this.stillValidTarget(dog, target)) {
                this.triggerAbsorbAction(dog, target);
            }
        }
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        if (!compound.contains("DTN_ChemiCanine", 10)) {
            return;
        }
        CompoundTag_1_21_5 tg0 = compound.getCompound("DTN_ChemiCanine");
        this.tickTillEffectDecay = tg0.getInt("tickTillEffectDecay");
        if (!tg0.contains("effects", 9)) {
            return;
        }
        ListTag_1_21_5 effectTags = tg0.getList("effects", 10);
        for (int i = 0; i < effectTags.size(); ++i) {
            try {
                CompoundTag_1_21_5 effectTag = effectTags.getCompound(i);
                class_1293 effectInst = (class_1293)class_1293.field_48821.parse((DynamicOps)class_2509.field_11560, (Object)effectTag.wrapped()).getOrThrow();
                if (effectInst == null) continue;
                this.storedEffects.add(effectInst);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        class_2487 tg0 = new class_2487();
        tg0.method_10569("tickTillEffectDecay", this.tickTillEffectDecay);
        class_2499 effectTags = new class_2499();
        for (class_1293 effect : this.storedEffects) {
            effectTags.add((Object)EntityUtil_1_21_5.tryEncodeEffect(effect));
        }
        tg0.method_10566("effects", (class_2520)effectTags);
        compound.method_10566("DTN_ChemiCanine", (class_2520)tg0);
    }

    private void triggerAbsorbAction(Dog dog, @Nonnull class_1309 target) {
        dog.triggerAction(new AbsorbAction(dog, this, target));
    }

    private class_1309 findTargetToAbsorb(AbstractDog dog) {
        List teamPlayers;
        Dog ddog;
        List wolves;
        List dogs;
        ArrayList<class_1309> absorbTargets = new ArrayList<class_1309>();
        Predicate<class_1309> harmfulEffectAndWitness = e -> this.isTargetHaveNegativeEffect(dog, (class_1309)e) && dog.method_5985().method_6369((class_1297)e);
        class_1309 owner = dog.method_35057();
        if (owner == null) {
            return null;
        }
        if (harmfulEffectAndWitness.test(owner)) {
            absorbTargets.add(owner);
        }
        if (!(dogs = dog.method_73183().method_8390(AbstractDog.class, dog.method_5829().method_1009(12.0, 4.0, 12.0), d -> d.method_35057() == owner && harmfulEffectAndWitness.test((class_1309)d))).isEmpty()) {
            absorbTargets.addAll(dogs);
        }
        if (!(wolves = dog.method_73183().method_8390(class_1493.class, dog.method_5829().method_1009(12.0, 4.0, 12.0), w -> w.method_35057() == owner && harmfulEffectAndWitness.test((class_1309)w))).isEmpty()) {
            absorbTargets.addAll(wolves);
        }
        if (dog instanceof Dog && (ddog = (Dog)dog).regardTeamPlayers() && !(teamPlayers = dog.method_73183().method_8390(class_1657.class, dog.method_5829().method_1009(12.0, 4.0, 12.0), p -> p.method_5722((class_1297)owner) && harmfulEffectAndWitness.test((class_1309)p))).isEmpty()) {
            absorbTargets.addAll(teamPlayers);
        }
        return this.selectAbsorbTarget(dog, absorbTargets);
    }

    private boolean isTargetHaveNegativeEffect(AbstractDog dog, class_1309 e) {
        for (class_1293 effectInst : e.method_6026()) {
            if (!this.isHarmfulEffect(effectInst)) continue;
            return true;
        }
        return false;
    }

    private boolean isHarmfulEffect(class_1293 effectInst) {
        return ((class_1291)effectInst.method_5579().comp_349()).method_18792() == class_4081.field_18272;
    }

    private class_1309 selectAbsorbTarget(AbstractDog dog, ArrayList<class_1309> absorbTargets) {
        if (absorbTargets.isEmpty()) {
            return null;
        }
        class_1309 target = absorbTargets.get(0);
        double mindistanceSqr = target.method_5858((class_1297)dog);
        class_1309 owner = dog.method_35057();
        for (class_1309 i : absorbTargets) {
            if (owner == i) {
                return i;
            }
            double d = i.method_5858((class_1297)dog);
            if (!(d < mindistanceSqr)) continue;
            target = i;
            mindistanceSqr = d;
        }
        return target;
    }

    public int absorbCost(AbstractDog dog, class_1309 target) {
        int cost = this.level() >= 5 ? 10 : 20;
        return cost;
    }

    public int getMaxAbsorbSize() {
        return this.level() * 2;
    }

    private boolean canAffordToAbsorbTarget(AbstractDog dog, class_1309 e) {
        return dog.getDogHunger() - 10.0f >= (float)this.absorbCost(dog, e) && this.storedEffects.size() < this.getMaxAbsorbSize();
    }

    private boolean stillValidTarget(Dog dog, class_1309 target) {
        Dog d;
        if (!target.method_5805()) {
            return false;
        }
        if (!this.isTargetHaveNegativeEffect(dog, target)) {
            return false;
        }
        if (!this.canAffordToAbsorbTarget(dog, target)) {
            return false;
        }
        if (dog.method_5858((class_1297)target) > 400.0) {
            return false;
        }
        return !(target instanceof Dog) || !(d = (Dog)target).isDefeated();
    }

    private boolean canAbsorbTarget(AbstractDog dog, class_1309 e) {
        return dog.method_5858((class_1297)e) <= 5.0 && dog.method_5985().method_6369((class_1297)e);
    }

    private void absorb(AbstractDog dog, class_1309 e) {
        if (this.absorbEffectCooldown > 0) {
            return;
        }
        class_6880 removeEffect = null;
        for (class_1293 effectInst : e.method_6026()) {
            if (!this.isHarmfulEffect(effectInst)) continue;
            removeEffect = effectInst.method_5579();
            break;
        }
        if (removeEffect == null) {
            return;
        }
        class_1293 effectInst = e.method_6112(removeEffect);
        if (effectInst == null) {
            return;
        }
        if (this.storedEffects.size() >= this.getMaxAbsorbSize()) {
            return;
        }
        if (!e.method_6016(removeEffect)) {
            return;
        }
        this.storedEffects.add(effectInst);
        dog.setDogHunger(dog.getDogHunger() - (float)this.absorbCost(dog, e));
        if (dog.method_73183() instanceof class_3218) {
            ((class_3218)dog.method_73183()).method_65096((class_2394)class_2398.field_11249, e.method_23317(), e.method_23318(), e.method_23321(), 30, (double)e.method_17681(), (double)0.8f, (double)e.method_17681(), 0.1);
        }
        this.absorbEffectCooldown = dog.method_59922().method_43048(3) * 20;
        this.tickTillEffectDecay = 24000;
    }

    @Override
    public DogInteractionResult isPotionApplicable(AbstractDog dogIn, class_1293 effectIn) {
        if (this.level() >= 5 && ((class_1291)effectIn.method_5579().comp_349()).method_18792() == class_4081.field_18272) {
            return DogInteractionResult.FAIL;
        }
        return DogInteractionResult.PASS;
    }

    @Override
    public void doAdditionalAttackEffects(AbstractDog dogIn, class_1297 target) {
        class_1309 e;
        if (!target.method_5805()) {
            return;
        }
        if (this.storedEffects.isEmpty()) {
            return;
        }
        class_1293 effectAdding = this.storedEffects.get(0);
        if (target instanceof class_1309 && !(e = (class_1309)target).method_6059(effectAdding.method_5579())) {
            e.method_6092(effectAdding);
            this.storedEffects.remove(effectAdding);
        }
    }

    public static class AbsorbAction
    extends TriggerableAction {
        private ChemiCanineTalent talentInst;
        @Nonnull
        private class_1309 target;
        private int ticksUntilPathRecalc = 0;
        private final int stopDist = 2;

        public AbsorbAction(Dog dog, ChemiCanineTalent talentInst, @Nonnull class_1309 target) {
            super(dog, false, true);
            this.talentInst = talentInst;
            this.target = target;
        }

        @Override
        public void onStart() {
            this.ticksUntilPathRecalc = 0;
        }

        @Override
        public boolean shouldStopAndFollowOwner() {
            return true;
        }

        @Override
        public float getDistanceForFollowOwner() {
            return 20.0f;
        }

        @Override
        public void tick() {
            if (!this.talentInst.stillValidTarget(this.dog, this.target)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.method_5858((class_1297)this.target) > 4.0) {
                this.dog.method_5988().method_6226((class_1297)this.target, 10.0f, (float)this.dog.method_5978());
                if (--this.ticksUntilPathRecalc <= 0) {
                    this.ticksUntilPathRecalc = 10;
                    if (!this.dog.method_60953() && !this.dog.method_5765()) {
                        this.dog.method_5942().method_6335((class_1297)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else if (this.talentInst.canAbsorbTarget(this.dog, this.target)) {
                this.talentInst.absorb(this.dog, this.target);
            }
        }

        @Override
        public void onStop() {
        }
    }
}

