/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.anim.DogAnimation;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import net.minecraft.class_1282;
import net.minecraft.class_2338;
import net.minecraft.class_2358;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_8111;

public class FireDrillTalent
extends TalentInstance {
    private int rollCooldown = 0;
    private boolean fireExtinguished = false;
    private boolean isInFire = false;
    private boolean isRolling = false;
    private int tickTillUpdateInFire = 10;

    public FireDrillTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void livingTick(AbstractDog dogIn) {
        if (dogIn.method_73183().field_9236) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (this.rollCooldown > 0) {
            --this.rollCooldown;
        }
        if (dog.method_20802() >= 20 || this.isRolling) {
            this.updateInFire(dog);
            if (this.canRoll(dog)) {
                dog.triggerAction(new DogStopDropRollAction(dog, this));
                this.rollCooldown = 40;
            }
        }
    }

    private void updateInFire(Dog dog) {
        if (--this.tickTillUpdateInFire > 0) {
            return;
        }
        this.tickTillUpdateInFire = 10;
        this.isInFire = true;
        class_238 bb = dog.method_5829();
        class_2338 startPos = class_2338.method_49637((double)bb.field_1323, (double)bb.field_1322, (double)bb.field_1321);
        class_2338 endPos = class_2338.method_49637((double)bb.field_1320, (double)bb.field_1325, (double)bb.field_1324);
        for (class_2338 pos : class_2338.method_10097((class_2338)startPos, (class_2338)endPos)) {
            class_2680 state = dog.method_73183().method_8320(pos);
            if (!(state.method_26204() instanceof class_2358)) continue;
            return;
        }
        this.isInFire = false;
    }

    private boolean canRoll(Dog dog) {
        if (this.rollCooldown > 0) {
            return false;
        }
        if (this.isInFire) {
            return false;
        }
        if (!dog.method_24828()) {
            return false;
        }
        if (dog.method_6172()) {
            return false;
        }
        if (!dog.canDoIdileAnim()) {
            return false;
        }
        if (!dog.readyForNonTrivialAction()) {
            return false;
        }
        return dog.method_5968() == null;
    }

    private boolean canContinueToRoll(Dog dog) {
        if (this.isInFire) {
            return false;
        }
        if (!dog.method_24828()) {
            return false;
        }
        if (dog.method_6172()) {
            return false;
        }
        if (!dog.canContinueDoIdileAnim()) {
            return false;
        }
        return !this.fireExtinguished || !dog.method_5809();
    }

    @Override
    public DogInteractionResult stillIdleOrSitWhenHurt(AbstractDog dog, class_1282 source, float amount) {
        if (this.isRolling && source.method_49708(class_8111.field_42337)) {
            return DogInteractionResult.SUCCESS;
        }
        return DogInteractionResult.PASS;
    }

    public static class DogStopDropRollAction
    extends TriggerableAction {
        private int stopTick;
        private int tickTillExtinguish = 60;
        private FireDrillTalent talentInst;

        public DogStopDropRollAction(Dog dog, FireDrillTalent talentInst) {
            super(dog, false, false);
            this.talentInst = talentInst;
        }

        @Override
        public void onStart() {
            this.stopTick = this.dog.field_6012 + DogAnimation.STOP_DROP_ROLL.getLengthTicks();
            this.dog.setAnimForIdle(DogAnimation.STOP_DROP_ROLL);
            this.talentInst.fireExtinguished = false;
            this.talentInst.isRolling = true;
        }

        @Override
        public void tick() {
            if (this.dog.getAnim() != DogAnimation.STOP_DROP_ROLL) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.field_6012 >= this.stopTick) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.talentInst.canContinueToRoll(this.dog)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            --this.tickTillExtinguish;
            if (this.tickTillExtinguish == 0 && this.dog.method_5809()) {
                this.dog.method_5646();
                this.dog.method_5783(class_3417.field_15102, 0.5f, 2.6f + this.dog.method_59922().method_43057() - this.dog.method_59922().method_43057() * 0.8f);
                this.talentInst.fireExtinguished = true;
            }
        }

        @Override
        public void onStop() {
            if (this.dog.getAnim() == DogAnimation.STOP_DROP_ROLL) {
                this.dog.setAnim(DogAnimation.NONE);
            }
            this.talentInst.rollCooldown = 40;
            this.talentInst.isRolling = false;
        }

        @Override
        public boolean canOverrideSit() {
            return true;
        }

        @Override
        public boolean canPreventSit() {
            return true;
        }
    }
}

