/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.TalentsOptions;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogFlyingMoveControl;
import doggytalents.common.entity.ai.nav.DogFlyingNavigation;
import doggytalents.common.util.Util;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class FlyingFurballTalent
extends TalentInstance {
    private static class_2960 FLYING_FURBALL_BOOST_UUID = Util.getResource("flying_furball_boost");
    private static class_2960 FLYING_FURBALL_GRAVITY_UUID = Util.getResource("flying_furball_gravity");
    private DogFlyingMoveControl moveControl;
    private DogFlyingNavigation navigation;
    private boolean startedGliding = false;
    private boolean wasFlying = false;
    private int flyHoldTick = 0;
    private boolean allowFlying = true;

    public FlyingFurballTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dog) {
        if (dog.method_73183().field_9236) {
            return;
        }
        if (!(dog instanceof Dog)) {
            return;
        }
        Dog d = (Dog)dog;
        d.setAttributeModifier((class_6880<class_1320>)class_5134.field_23720, FLYING_FURBALL_BOOST_UUID, this::createSpeedModifier);
        this.moveControl = new DogFlyingMoveControl(d, this);
        this.navigation = new DogFlyingNavigation(d, dog.method_73183());
    }

    @Override
    public void set(AbstractDog dogIn, int level) {
        dogIn.setAttributeModifier((class_6880<class_1320>)class_5134.field_23720, FLYING_FURBALL_BOOST_UUID, this::createSpeedModifier);
    }

    @Override
    public void remove(AbstractDog dogIn) {
        Dog d;
        if (dogIn.method_73183().field_9236) {
            return;
        }
        dogIn.removeAttributeModifier((class_6880<class_1320>)class_5134.field_23720, FLYING_FURBALL_BOOST_UUID);
        dogIn.resetMoveControl();
        dogIn.resetNavigation();
        dogIn.setDogFlying(false);
        this.stopGliding(dogIn);
        dogIn.method_5875(false);
        if (dogIn instanceof Dog && (d = (Dog)dogIn).getAnim() == DogAnimation.FLY_AIR_BOURNE) {
            d.setAnim(DogAnimation.NONE);
        }
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.method_73183().field_9236) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        dog.field_6017 = 0.0;
        if (this.flyHoldTick > 0) {
            --this.flyHoldTick;
        }
        boolean isDogFlying = dog.isDogFlying();
        if (dog.method_5942() != this.navigation && this.shouldSwitchToFlying(dog)) {
            dog.setMoveControl((class_1335)this.moveControl);
            dog.setNavigation((class_1408)this.navigation);
            this.startGliding(dog);
        } else if (dog.method_5942() == this.navigation && this.shouldSwitchAwayFromFlying(dog)) {
            dog.resetMoveControl();
            dog.resetNavigation();
            this.stopGliding(dog);
        }
        if (isDogFlying && this.shouldStopFlying(dog)) {
            dog.setDogFlying(false);
            dog.method_5875(false);
        }
        if (!isDogFlying && this.canBeginFlying(dog)) {
            dog.setDogFlying(true);
            this.flyHoldTick = 15;
        }
        if (isDogFlying = dog.isDogFlying()) {
            if (this.wasFlying) {
                if (dog.getAnim() == DogAnimation.NONE && !dog.forcedWhenNoneAnim()) {
                    dog.setAnim(DogAnimation.FLY_AIR_BOURNE);
                }
            } else {
                dog.setAnim(DogAnimation.FLY_JUMP_START);
                this.wasFlying = true;
            }
        }
        if (!isDogFlying) {
            DogAnimation anim = dog.getAnim();
            if (anim == DogAnimation.FLY_AIR_BOURNE || anim == DogAnimation.FLY_JUMP_START || this.wasFlying && anim == DogAnimation.NONE && !dog.forcedWhenNoneAnim()) {
                dog.setAnim(DogAnimation.FLY_LANDING);
            }
            this.wasFlying = false;
        }
    }

    private boolean canBeginFlying(AbstractDog dog) {
        return dog.getAnim() == DogAnimation.NONE && !dog.forcedWhenNoneAnim() && this.shouldBeFlying(dog);
    }

    private boolean shouldStopFlying(AbstractDog dog) {
        return !this.shouldBeFlying(dog);
    }

    private boolean shouldBeFlying(AbstractDog dog) {
        if (this.flyHoldTick > 0) {
            return true;
        }
        if (!dog.isDoingFine() && dog instanceof Dog) {
            Dog ddog = (Dog)dog;
            if (!ddog.incapacitatedMananger.canMove()) {
                return false;
            }
        }
        return this.allowFlying() && !dog.method_24828() && !dog.method_6172() && !dog.method_5765() && !dog.method_5799() && dog.method_5942() == this.navigation;
    }

    private boolean shouldSwitchToFlying(AbstractDog dog) {
        return this.allowFlying() && !dog.method_6172() && !dog.method_5765() && !dog.method_5799();
    }

    private boolean shouldSwitchAwayFromFlying(AbstractDog dog) {
        return !this.allowFlying();
    }

    public class_1322 createSpeedModifier(AbstractDog dogIn, class_2960 uuidIn) {
        if (this.level() > 0) {
            double speed = (double)(this.level() - 1) * 0.1;
            return new class_1322(uuidIn, speed, class_1322.class_1323.field_6328);
        }
        return null;
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setCanFly().setWillFly(this::allowFlying).setFallImmune();
    }

    public void startGliding(AbstractDog dog) {
        this.startedGliding = true;
        dog.setAttributeModifier((class_6880<class_1320>)class_5134.field_49078, FLYING_FURBALL_GRAVITY_UUID, this::createGravityModifier);
    }

    public void stopGliding(AbstractDog dog) {
        if (!this.startedGliding) {
            return;
        }
        this.startedGliding = false;
        dog.removeAttributeModifier((class_6880<class_1320>)class_5134.field_49078, FLYING_FURBALL_GRAVITY_UUID);
    }

    public class_1322 createGravityModifier(AbstractDog dogIn, class_2960 uuidIn) {
        return new class_1322(uuidIn, -0.8, class_1322.class_1323.field_6330);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        this.allowFlying = compound.getBoolean("allowFlying");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        compound.method_10556("allowFlying", this.allowFlying);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.FLYING_FURBALL_ALLOW.get()) {
            return this.allowFlying;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.FLYING_FURBALL_ALLOW.get()) {
            this.allowFlying = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.FLYING_FURBALL_ALLOW.get());
    }

    public boolean allowFlying() {
        return this.allowFlying;
    }

    public void setAllowFlying(boolean val) {
        this.allowFlying = val;
    }
}

