/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.InteractionResultHolder;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.EntityUtil;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_8103;
import net.minecraft.class_8111;

public class HellHoundTalent
extends TalentInstance {
    private final int SEARCH_RANGE = 3;
    private int tickUntilSearch = 0;
    private int fireResistTickLeft = 60;
    private int fireResistHealCooldown = 0;
    private int meltCooldown = 30;
    private int meltingModeDuration = 0;

    public HellHoundTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public InteractionResultHolder<Float> calculateFallDistance(AbstractDog dogIn, float distance) {
        if (this.level() >= 5 && dogIn.method_5771()) {
            return InteractionResultHolder.success(Float.valueOf(0.0f));
        }
        return super.calculateFallDistance(dogIn, distance);
    }

    @Override
    public InteractionResultHolder<Integer> setFire(AbstractDog dogIn, int ticks) {
        if (dogIn.method_5809()) {
            return InteractionResultHolder.pass(ticks);
        }
        return InteractionResultHolder.success(class_3532.method_15375((float)((float)ticks * this.getFireDecreasePercentage())));
    }

    private float getFireDecreasePercentage() {
        if (this.level() <= 0 || this.level() >= 5) {
            return 1.0f;
        }
        switch (this.level()) {
            default: {
                return 1.0f;
            }
            case 1: {
                return 0.9f;
            }
            case 2: {
                return 0.8f;
            }
            case 3: {
                return 0.5f;
            }
            case 4: 
        }
        return 0.25f;
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        if (this.level() >= 5) {
            props.setFireImmune();
        }
    }

    @Override
    public DogInteractionResult isInvulnerableTo(AbstractDog dogIn, class_1282 source) {
        if (source.method_48789(class_8103.field_42246)) {
            return this.level() >= 5 ? DogInteractionResult.SUCCESS : DogInteractionResult.PASS;
        }
        if (source.method_48789(class_8103.field_42252)) {
            return this.level() >= 5 ? DogInteractionResult.SUCCESS : DogInteractionResult.PASS;
        }
        return DogInteractionResult.PASS;
    }

    @Override
    public void doInitialAttackEffects(AbstractDog dogIn, class_1297 entity) {
        if (this.level() >= 5) {
            EntityUtil.setSecondsOnFire(entity, 15);
        } else if (this.level() >= 4) {
            EntityUtil.setSecondsOnFire(entity, 4);
        }
    }

    @Override
    public DogInteractionResult canResistPushFromFluidType() {
        if (this.level() >= 5) {
            return DogInteractionResult.SUCCESS;
        }
        return DogInteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<Float> gettingAttackedFrom(AbstractDog dog, class_1282 source, float damage) {
        if (!source.method_48789(class_8103.field_42246)) {
            return InteractionResultHolder.pass(Float.valueOf(damage));
        }
        int resistValue = this.getResistValue(source);
        this.fireResistHealCooldown = 80;
        this.fireResistTickLeft = Math.min(this.fireResistTickLeft, resistValue);
        if (this.fireResistTickLeft > 0) {
            return InteractionResultHolder.fail(Float.valueOf(0.0f));
        }
        this.fireResistTickLeft = resistValue;
        return InteractionResultHolder.pass(Float.valueOf(this.getFireDamageReduced(source, damage)));
    }

    private float getFireDamageReduced(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42338)) {
            if (this.level() >= 4) {
                return 1.0f;
            }
            if (this.level() >= 3) {
                return 2.0f;
            }
            return Math.max(0.0f, 1.0f - (float)this.level() * 0.25f) * amount;
        }
        return 1.0f;
    }

    private int getMaxAccumulate() {
        if (this.level() <= 2) {
            return this.level() + 1;
        }
        if (this.level() <= 3) {
            return this.level() + 3;
        }
        return this.level() + 10;
    }

    private int getResistValue(class_1282 source) {
        if (this.level() >= 4) {
            return this.getMaxAccumulate() * 20;
        }
        if (source.method_49708(class_8111.field_42338)) {
            return this.getMaxAccumulate() * 10;
        }
        if (source.method_49708(class_8111.field_42335)) {
            return this.getMaxAccumulate() * 15;
        }
        return this.getMaxAccumulate() * 20;
    }

    public boolean canGenerateHeat() {
        return this.level() >= 4;
    }

    @Override
    public DogInteractionResult shouldNotAfraidOfFire(AbstractDog dog) {
        if (this.level() < 3) {
            return DogInteractionResult.PASS;
        }
        return DogInteractionResult.SUCCESS;
    }

    @Override
    public DogInteractionResult stillIdleOrSitWhenHurt(AbstractDog dog, class_1282 source, float amount) {
        if (this.level() >= 4 && source.method_48789(class_8103.field_42246)) {
            return DogInteractionResult.SUCCESS;
        }
        if (source.method_49708(class_8111.field_42337)) {
            return DogInteractionResult.SUCCESS;
        }
        return DogInteractionResult.PASS;
    }

    @Override
    public void tick(AbstractDog d) {
        if (d.method_73183().field_9236) {
            return;
        }
        if (this.level() < 5) {
            this.updateResistValues();
            return;
        }
        if (!(d instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)d;
        if (dog != null && dog.isShakingLava() && (double)dog.getTimeDogIsShaking() > 0.8 && --this.tickUntilSearch <= 0) {
            this.tickUntilSearch = 10;
            this.fireSpreadToEnermies(dog);
        }
        this.meltPoweredSnowIfFreeze(dog);
    }

    private void updateResistValues() {
        if (this.fireResistHealCooldown > 0) {
            --this.fireResistHealCooldown;
        }
        if (this.fireResistHealCooldown <= 0) {
            this.fireResistTickLeft = 60;
            return;
        }
        if (this.fireResistTickLeft > 0) {
            --this.fireResistTickLeft;
        }
    }

    private void fireSpreadToEnermies(AbstractDog dog) {
        List targets = dog.method_73183().method_18467(class_1309.class, dog.method_5829().method_1009(3.0, 2.0, 3.0));
        for (class_1309 x : targets) {
            if (!(x instanceof class_1569)) continue;
            EntityUtil.setSecondsOnFire((class_1297)x, 5);
        }
    }

    private void meltPoweredSnowIfFreeze(AbstractDog dog) {
        if (this.meltCooldown > 0) {
            --this.meltCooldown;
        }
        if (dog.field_27857) {
            this.meltingModeDuration = 100;
        } else if (this.meltingModeDuration > 0) {
            --this.meltingModeDuration;
        }
        if (!dog.field_27857 && this.meltingModeDuration <= 0) {
            return;
        }
        if (dog.method_5782()) {
            return;
        }
        if (this.meltCooldown > 0) {
            return;
        }
        this.meltCooldown = 30;
        class_238 bb = dog.method_5829().method_1014(1.0);
        Iterable block_itr = class_2338.method_10097((class_2338)class_2338.method_49637((double)bb.field_1323, (double)bb.field_1322, (double)bb.field_1321), (class_2338)class_2338.method_49637((double)bb.field_1320, (double)bb.field_1325, (double)bb.field_1324));
        boolean melted = false;
        for (class_2338 pos : block_itr) {
            class_2680 state = dog.method_73183().method_8320(pos);
            if (!state.method_27852(class_2246.field_27879)) continue;
            melted = true;
            dog.method_73183().method_8501(pos, class_2246.field_10124.method_9564());
        }
        if (melted) {
            dog.method_5783(class_3417.field_15102, 0.5f, 2.6f + dog.method_59922().method_43057() - dog.method_59922().method_43057() * 0.8f);
            class_1937 class_19372 = dog.method_73183();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                serverLevel.method_65096((class_2394)class_2398.field_11251, dog.method_23317(), dog.method_23318(), dog.method_23321(), 30, (double)dog.method_17681(), (double)0.8f, (double)dog.method_17681(), 0.1);
            }
        }
    }
}

