/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools;

import doggytalents.DoggyTalents;
import doggytalents.api.forge_imitate.inventory.ItemStackHandler;
import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.misc.DogArrow;
import doggytalents.common.entity.misc.DogThrownTrident;
import doggytalents.common.talent.doggy_tools.DoggyToolsRangedAttack;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1744;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_238;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;

public interface ShootHandler {
    public static final ShootHandler NONE = new ShootHandler(){

        @Override
        public boolean updateUsingWeapon(DoggyToolsRangedAttack ranged_manager, IDogRangedAttackManager.UsingWeaponContext ctx) {
            return false;
        }
    };
    public static final ShootHandler BOW = new BowlikeShootHandler(){

        @Override
        public boolean isToolReadyToShoot(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, int tick_using) {
            return tick_using >= 20;
        }

        @Override
        public void shoot(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, class_1309 target, int tick_using) {
            this.shootFromBow(ranged_manager, dog, target, class_1753.method_7722((int)tick_using));
        }

        private void shootFromBow(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, class_1309 target, float damage) {
            Optional<class_1665> arrowOptional = this.getAndConsumeDogArrow(dog, damage);
            if (!arrowOptional.isPresent()) {
                return;
            }
            class_1665 arrow = arrowOptional.get();
            ranged_manager.shootProjectile(dog, (class_1676)arrow, target, class_3417.field_14633);
        }

        public Optional<class_1665> getAndConsumeDogArrow(AbstractDog dog, float damage) {
            Optional<class_1665> projArrowOptional;
            class_1799 bowStack = dog.method_6047();
            if (!(bowStack.method_7909() instanceof class_1753)) {
                return Optional.empty();
            }
            Optional<Pair<ItemStackHandler, Integer>> arrowInvOptional = DoggyToolsRangedAttack.findArrowsInInventory(dog);
            ItemStackHandler inv = null;
            int id = -1;
            if (arrowInvOptional.isPresent()) {
                inv = (ItemStackHandler)((Object)arrowInvOptional.get().getLeft());
                id = (Integer)arrowInvOptional.get().getRight();
            }
            class_1799 arrow_stack = class_1799.field_8037;
            if (inv != null && id >= 0) {
                arrow_stack = inv.getStackInSlot(id).method_7972();
            }
            if (!(projArrowOptional = this.getArrowFromBow(dog, bowStack, arrow_stack, damage)).isPresent()) {
                return Optional.empty();
            }
            this.consumeArrow(dog, bowStack, arrow_stack);
            if (inv != null && id >= 0) {
                inv.setStackInSlot(id, arrow_stack);
            }
            bowStack.method_7970(1, (class_1309)dog, class_1304.field_6173);
            return projArrowOptional;
        }

        private Optional<class_1665> getArrowFromBow(AbstractDog dog, class_1799 bow_stack, class_1799 arrowStack, float power) {
            boolean flaming_arrow;
            class_1792 class_17922;
            class_1792 class_17923 = bow_stack.method_7909();
            if (!(class_17923 instanceof class_1753)) {
                return Optional.empty();
            }
            class_1753 bow = (class_1753)class_17923;
            boolean is_infinity_bow = DoggyToolsRangedAttack.isInfinityBow(bow_stack, dog);
            class_1799 select_arrowStack = null;
            class_1792 select_arrow = null;
            if (is_infinity_bow) {
                select_arrow = class_1802.field_8107;
                select_arrowStack = new class_1799((class_1935)select_arrow);
            }
            if ((class_17922 = arrowStack.method_7909()) instanceof class_1744) {
                class_1744 arrowItem = (class_1744)class_17922;
                select_arrow = arrowItem;
                select_arrowStack = arrowStack;
            }
            if (select_arrowStack == null || select_arrowStack.method_7960()) {
                return Optional.empty();
            }
            if (!(select_arrow instanceof class_1744)) {
                return Optional.empty();
            }
            class_1744 arrow = (class_1744)select_arrow;
            arrowStack = select_arrowStack;
            class_1665 arrow_proj = this.createDogArrow(dog, arrow, arrowStack, bow_stack);
            if (arrow_proj == null) {
                return Optional.empty();
            }
            if (power >= 1.0f) {
                arrow_proj.method_7439(true);
            }
            boolean bl = flaming_arrow = dog.getDogLevel(DoggyTalents.HELL_HOUND) >= 5;
            if (flaming_arrow) {
                EntityUtil.setSecondsOnFire((class_1297)arrow_proj, 100);
            }
            arrow_proj.field_7572 = is_infinity_bow ? class_1665.class_1666.field_7594 : class_1665.class_1666.field_7593;
            return Optional.of(arrow_proj);
        }

        private class_1665 createDogArrow(AbstractDog dog, class_1744 arrow_item, class_1799 arrow_stack, class_1799 bow_stack) {
            if (((Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_BOW_VANILLA_PROJ.get()).booleanValue()) {
                return arrow_item.method_7702(dog.method_73183(), arrow_stack, (class_1309)dog, bow_stack);
            }
            return new DogArrow(dog.method_73183(), dog, arrow_stack.method_46651(1), bow_stack.method_46651(1));
        }

        private void consumeArrow(AbstractDog dog, class_1799 bow_stack, class_1799 arrowStack) {
            boolean is_infinity_bow = DoggyToolsRangedAttack.isInfinityBow(bow_stack, dog);
            if (!is_infinity_bow) {
                arrowStack.method_7934(1);
            }
        }
    };
    public static final ShootHandler TRIDENT = new BowlikeShootHandler(){

        @Override
        public boolean isToolReadyToShoot(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, int tick_using) {
            return tick_using >= 20 && !ranged_manager.hasAwaitingTrident();
        }

        @Override
        public void shoot(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, class_1309 target, int tick_using) {
            this.shootFromTrident(ranged_manager, dog, target);
        }

        private void shootFromTrident(DoggyToolsRangedAttack ranged_manager, AbstractDog ddog, class_1309 target) {
            boolean flaming_trident;
            if (!(ddog instanceof Dog)) {
                return;
            }
            Dog dog = (Dog)ddog;
            Optional<DogThrownTrident> tridentOptional = this.getAndConsumeDogTrident(dog);
            if (!tridentOptional.isPresent()) {
                return;
            }
            DogThrownTrident trident = tridentOptional.get();
            boolean bl = flaming_trident = dog.getDogLevel(DoggyTalents.HELL_HOUND) >= 5;
            if (flaming_trident) {
                EntityUtil.setSecondsOnFire((class_1297)trident, 100);
            }
            ranged_manager.shootProjectile(dog, (class_1676)trident, target, (class_3414)class_3417.field_15001.comp_349());
            ranged_manager.setAwaitingTrident(trident);
        }

        private Optional<DogThrownTrident> getAndConsumeDogTrident(Dog dog) {
            class_1799 trident_stack = dog.method_6047();
            if (!DogUtil.isTrident(trident_stack)) {
                return Optional.empty();
            }
            DogThrownTrident proj = new DogThrownTrident(dog, trident_stack.method_7972());
            proj.field_7572 = class_1665.class_1666.field_7594;
            trident_stack.method_7970(1, (class_1309)dog, class_1304.field_6173);
            return Optional.of(proj);
        }
    };
    public static final ShootHandler CROSSBOW = new ShootHandler(){

        @Override
        public boolean updateUsingWeapon(DoggyToolsRangedAttack ranged_manager, IDogRangedAttackManager.UsingWeaponContext ctx) {
            AbstractDog dog = ctx.dog;
            class_1799 crossbow_stack = dog.method_6047();
            if (!(crossbow_stack.method_7909() instanceof class_1764)) {
                if (dog.method_6115()) {
                    dog.method_6021();
                }
                return false;
            }
            Optional<Pair<ItemStackHandler, Integer>> arrow_optional = DoggyToolsRangedAttack.findArrowsInInventory(dog);
            if (!arrow_optional.isPresent()) {
                if (dog.method_6115()) {
                    dog.method_6021();
                }
                return false;
            }
            Pair<ItemStackHandler, Integer> arrow_stack = arrow_optional.get();
            boolean attack_result = false;
            if (this.isCrossbowCharged(crossbow_stack)) {
                attack_result = this.updateCrossbowAttack(ranged_manager, dog, ctx.target, crossbow_stack);
            } else {
                this.updateChargeCrossbow(ranged_manager, dog, crossbow_stack, arrow_stack, ctx);
            }
            return attack_result;
        }

        private boolean isCrossbowCharged(class_1799 crossbow_stack) {
            return class_1764.method_7781((class_1799)crossbow_stack);
        }

        private void updateChargeCrossbow(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, class_1799 crossbow_stack, Pair<ItemStackHandler, Integer> arrow_getter, IDogRangedAttackManager.UsingWeaponContext ctx) {
            boolean should_stop_using;
            ranged_manager.setDelayedCrossbowAttack(10);
            if (!dog.method_6115()) {
                this.mayStartUsingWeapon(ctx);
                return;
            }
            boolean bl = should_stop_using = !ctx.canSeeTarget && ctx.seeTime < -60;
            if (should_stop_using) {
                dog.method_6021();
                return;
            }
            int using_tick = dog.method_6048();
            if (using_tick >= class_1764.method_7775((class_1799)crossbow_stack, (class_1309)dog)) {
                dog.method_6021();
                this.chargeCrossbowAndConsumeArrow(dog, crossbow_stack, arrow_getter);
            }
        }

        private void chargeCrossbowAndConsumeArrow(AbstractDog dog, class_1799 crossbow_stack, Pair<ItemStackHandler, Integer> arrow_getter) {
            ItemStackHandler inv = null;
            int id = -1;
            inv = (ItemStackHandler)((Object)arrow_getter.getLeft());
            id = (Integer)arrow_getter.getRight();
            class_1799 arrow_stack = class_1799.field_8037;
            if (inv != null && id >= 0) {
                arrow_stack = inv.getStackInSlot(id).method_7972();
            }
            if (arrow_stack.method_7960()) {
                return;
            }
            boolean is_multishot = ItemUtil.getEnchantmentLevelForItem((class_5321<class_1887>)class_1893.field_9108, dog.method_56673(), crossbow_stack) > 0;
            int shoot_amount = is_multishot ? 3 : 1;
            ArrayList<class_1799> item_list = new ArrayList<class_1799>(shoot_amount);
            for (int i = 0; i < shoot_amount; ++i) {
                item_list.add(arrow_stack.method_46651(1));
            }
            if (item_list.isEmpty()) {
                return;
            }
            crossbow_stack.method_57379(class_9334.field_49649, (Object)class_9278.method_57441(item_list));
            if (inv != null) {
                arrow_stack = arrow_stack.method_7972();
                arrow_stack.method_7934(1);
                inv.setStackInSlot(id, arrow_stack);
            }
            dog.method_5783((class_3414)class_3417.field_14626.comp_349(), 1.0f, 1.0f / (dog.method_59922().method_43057() * 0.5f + 1.0f) + 0.2f);
        }

        private boolean updateCrossbowAttack(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, class_1309 target, class_1799 crossbow_stack) {
            ranged_manager.decDelayedCrossbowAttack();
            if (ranged_manager.getDelayedCrossbowAttack() <= 0) {
                ranged_manager.setDelayedCrossbowAttack(20);
                this.shootViaCrossbow(dog, target, crossbow_stack);
                return true;
            }
            return false;
        }

        private void shootViaCrossbow(AbstractDog dog, class_1309 target, class_1799 crossbow_stack) {
            class_1792 class_17922 = crossbow_stack.method_7909();
            if (!(class_17922 instanceof class_1764)) {
                return;
            }
            class_1764 crossbowitem = (class_1764)class_17922;
            crossbowitem.method_7777(dog.method_73183(), (class_1309)dog, class_1268.field_5808, crossbow_stack, 1.6f, 2.0f, target);
            this.hellHoundSetFireToOwnedArrows(dog);
        }

        private boolean hellHoundSetFireToOwnedArrows(AbstractDog dog) {
            if (!dog.method_5753()) {
                return false;
            }
            Predicate<class_1665> is_target_arrow = e -> {
                if (!e.method_5805()) {
                    return false;
                }
                return e.method_24921() == dog;
            };
            class_238 bb = dog.method_5829().method_1014(1.0);
            List targets = dog.method_73183().method_8390(class_1665.class, bb, is_target_arrow);
            if (targets.isEmpty()) {
                return false;
            }
            for (class_1665 target : targets) {
                EntityUtil.setSecondsOnFire((class_1297)target, 20);
            }
            return true;
        }

        private void mayStartUsingWeapon(IDogRangedAttackManager.UsingWeaponContext ctx) {
            if (ctx.cooldown <= 0 && ctx.seeTime >= -60) {
                ctx.dog.method_6019(class_1268.field_5808);
            }
        }
    };

    public boolean updateUsingWeapon(DoggyToolsRangedAttack var1, IDogRangedAttackManager.UsingWeaponContext var2);

    public static abstract class BowlikeShootHandler
    implements ShootHandler {
        @Override
        public boolean updateUsingWeapon(DoggyToolsRangedAttack ranged_manager, IDogRangedAttackManager.UsingWeaponContext ctx) {
            int using_tick;
            boolean should_stop_using;
            AbstractDog dog = ctx.dog;
            if (!dog.method_6115()) {
                this.mayStartUsingWeapon(ctx);
                return false;
            }
            boolean bl = should_stop_using = !ctx.canSeeTarget && ctx.seeTime < -60;
            if (should_stop_using) {
                dog.method_6021();
                return false;
            }
            if (ctx.canSeeTarget && this.isToolReadyToShoot(ranged_manager, dog, using_tick = dog.method_6048())) {
                dog.method_6021();
                this.shoot(ranged_manager, dog, ctx.target, using_tick);
                return true;
            }
            return false;
        }

        private void mayStartUsingWeapon(IDogRangedAttackManager.UsingWeaponContext ctx) {
            if (ctx.cooldown <= 0 && ctx.seeTime >= -60) {
                ctx.dog.method_6019(class_1268.field_5808);
            }
        }

        public abstract boolean isToolReadyToShoot(DoggyToolsRangedAttack var1, AbstractDog var2, int var3);

        public abstract void shoot(DoggyToolsRangedAttack var1, AbstractDog var2, class_1309 var3, int var4);
    }
}

