/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.dogpromise.promise;

import doggytalents.common.util.dogpromise.chunk.DTNForcedChunkManager;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractPromise {
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents/chunkTask");
    @Nullable
    private class_3222 owner;
    private State state;
    protected String rejectedMsg = "";
    private final Map<class_5321<class_1937>, AccquiredChunks> accquiredChunks = new HashMap<class_5321<class_1937>, AccquiredChunks>();

    public AbstractPromise() {
        this.state = State.PENDING;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public class_3222 getOwner() {
        return this.owner;
    }

    public void setOwner(class_3222 owner) {
        this.owner = owner;
    }

    public abstract void start();

    public abstract void tick();

    public abstract void onFulfilled();

    public abstract void onRejected();

    public void cleanUp() {
    }

    public final void doCleanUp() {
        this.dropAllAccquiredChunk();
        this.cleanUp();
    }

    protected final void accquireChunk(class_3218 level, class_1923 pos) {
        LongSet accquireds = this.accquiredChunks.computeIfAbsent((class_5321<class_1937>)level.method_27983(), k -> new AccquiredChunks(level)).chunks();
        boolean added = accquireds.add(pos.method_8324());
        if (!added) {
            return;
        }
        DTNForcedChunkManager.accquireChunk(level, this, pos);
    }

    protected final void dropAllAccquiredChunk() {
        int drop_count = 0;
        for (Map.Entry<class_5321<class_1937>, AccquiredChunks> entry : this.accquiredChunks.entrySet()) {
            class_3218 source = entry.getValue().source();
            LongSet chunks = entry.getValue().chunks();
            if (chunks.isEmpty()) continue;
            for (Long chunk : chunks) {
                DTNForcedChunkManager.dropChunk(source, this, new class_1923(chunk.longValue()));
                ++drop_count;
            }
        }
        this.accquiredChunks.clear();
    }

    public void forceReject() {
        this.setState(State.REJECTED);
        this.rejectedMsg = "FORCED";
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public static enum State {
        PENDING,
        RUNNING,
        FULFILLED,
        REJECTED;

    }

    private record AccquiredChunks(class_3218 source, LongSet chunks) {
        public AccquiredChunks(class_3218 source) {
            this(source, (LongSet)new LongOpenHashSet());
        }
    }
}

