/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.variant.util;

import doggytalents.DoggyRegistries;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.VanillaToClassicalMapping;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_9346;

public class DogVariantUtil {
    public static DogVariant getDefault() {
        return DogVariant.PALE;
    }

    public static DogVariant getMissing() {
        return DogVariant.MISSING;
    }

    public static DogVariant fromSaveString(String string) {
        return DogVariantUtil.fromSaveString(string, id -> {});
    }

    public static DogVariant fromSaveString(String string, Consumer<class_2960> missingSetter) {
        boolean handle_missing;
        class_2960 id = null;
        try {
            id = class_2960.method_60654((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id == null) {
            return DogVariantUtil.getDefault();
        }
        DogVariant variant = (DogVariant)DoggyRegistries.DOG_VARIANT.get().method_63535(id);
        if (variant == null) {
            return DogVariantUtil.getDefault();
        }
        boolean bl = handle_missing = variant == DogVariantUtil.getMissing() && !id.equals((Object)DogVariantUtil.getMissing().id());
        if (handle_missing) {
            missingSetter.accept(id);
            return DogVariantUtil.getMissing();
        }
        if (variant == DogVariantUtil.getMissing()) {
            variant = DogVariantUtil.getDefault();
        }
        return variant;
    }

    public static String toSaveString(DogVariant variant) {
        return DogVariantUtil.toSaveString(variant, () -> Optional.empty());
    }

    public static String toSaveString(DogVariant variant, Supplier<Optional<class_2960>> missingGetter) {
        if (variant == null) {
            variant = DogVariantUtil.getDefault();
        }
        if (variant == DogVariantUtil.getMissing()) {
            Optional<class_2960> missing = missingGetter.get();
            if (missing.isPresent()) {
                return missing.get().toString();
            }
            return DogVariantUtil.getDefault().id().toString();
        }
        return variant.id().toString();
    }

    public static List<DogVariant> getAll() {
        class_2378<DogVariant> variant_reg = DoggyRegistries.DOG_VARIANT.get();
        List<DogVariant> entries = variant_reg.method_10220().filter(x -> x != DogVariantUtil.getMissing()).collect(Collectors.toList());
        return entries;
    }

    public static List<DogVariant> getAllWithMissing() {
        class_2378<DogVariant> variant_reg = DoggyRegistries.DOG_VARIANT.get();
        List<DogVariant> entries = variant_reg.method_10220().collect(Collectors.toList());
        return entries;
    }

    public static DogVariant getRandom(class_5819 random) {
        List<DogVariant> entries = DogVariantUtil.getAll();
        if (entries.isEmpty()) {
            return DogVariantUtil.getDefault();
        }
        int r = random.method_43048(entries.size());
        return entries.get(r);
    }

    public static DogVariant cycle(DogVariant current) {
        List<DogVariant> entries = DogVariantUtil.getAll();
        if (entries.isEmpty()) {
            return DogVariantUtil.getDefault();
        }
        int current_indx = entries.indexOf(current);
        int next_indx = (current_indx + 1) % entries.size();
        DogVariant next_variant = entries.get(next_indx);
        return next_variant;
    }

    public static DogVariant fromVanila(class_5321<class_9346> variant) {
        return VanillaToClassicalMapping.fromVanilla(variant).get();
    }
}

