/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import doggytalents.client.PettingArmPose;
import doggytalents.client.backward_imitate.GuiUtil_1_21_9;
import doggytalents.client.backward_imitate.PlayerRenderPrep_21_3;
import doggytalents.client.screen.PetSelectScreen;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogPettingManager;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogPettingData;
import doggytalents.common.util.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderArmEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import org.joml.Quaternionfc;

public class DTNClientPettingManager {
    private static DTNClientPettingManager INSTANCE = new DTNClientPettingManager();
    private DogPettingManager.DogPettingType selectedType = null;
    private Dog dog = null;
    private boolean isPetting;
    private float pet_camera_xRot_add = 0.0f;
    private float pet_camera_yRot_add = 0.0f;
    private float pet_camera_xRot0_add = 0.0f;
    private float pet_camera_yRot0_add = 0.0f;
    private final Map<UUID, Dog> petterMap = Maps.newHashMap();
    private final List<UUID> toRemoveForPetter = new ArrayList<UUID>();

    public static DTNClientPettingManager get() {
        return INSTANCE;
    }

    public void setPetMode(DogPettingManager.DogPettingType type) {
        this.selectedType = type;
    }

    public DogPettingManager.DogPettingType getPetMode() {
        return this.selectedType;
    }

    public void setPetting(Dog dog) {
        this.isPetting = dog != null;
        this.dog = dog;
        if (!this.isPetting) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        player.yBodyRot = player.yHeadRot;
        this.pet_camera_xRot_add = 0.0f;
        this.pet_camera_yRot_add = 0.0f;
        this.pet_camera_xRot0_add = 0.0f;
        this.pet_camera_yRot0_add = 0.0f;
    }

    @SubscribeEvent
    public void tickClient(ClientTickEvent.Post event) {
        if (this.isPetting) {
            this.updatePetCameraRotation();
        }
        this.invalidatePetterCache();
    }

    @SubscribeEvent
    public void onPlayerLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        this.clearPetterMap();
    }

    public void invalidatePetterCache() {
        if (this.petterMap.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, Dog> entry : this.petterMap.entrySet()) {
            Dog dog = entry.getValue();
            if (dog.isAlive()) continue;
            this.toRemoveForPetter.add(entry.getKey());
        }
        if (this.toRemoveForPetter.isEmpty()) {
            return;
        }
        for (UUID player : this.toRemoveForPetter) {
            this.removePetterFromMap(player);
        }
        this.toRemoveForPetter.clear();
    }

    private void updatePetCameraRotation() {
        Minecraft mc = Minecraft.getInstance();
        Options options = mc.options;
        CameraType view_type = options.getCameraType();
        if (view_type.isFirstPerson()) {
            return;
        }
        this.pet_camera_xRot0_add = this.pet_camera_xRot_add;
        this.pet_camera_yRot0_add = this.pet_camera_yRot_add;
        float add_amount = 3.0f;
        if (options.keyUp.isDown()) {
            this.pet_camera_xRot_add += 3.0f;
        } else if (options.keyDown.isDown()) {
            this.pet_camera_xRot_add -= 3.0f;
        } else if (options.keyLeft.isDown()) {
            this.pet_camera_yRot_add += 3.0f;
        } else if (options.keyRight.isDown()) {
            this.pet_camera_yRot_add -= 3.0f;
        }
        this.pet_camera_xRot_add = Mth.clamp((float)this.pet_camera_xRot_add, (float)-50.0f, (float)50.0f);
        float y_rot_change = this.pet_camera_yRot_add - this.pet_camera_yRot0_add;
        this.pet_camera_yRot_add = Mth.wrapDegrees((float)this.pet_camera_yRot_add);
        this.pet_camera_yRot0_add = this.pet_camera_yRot_add - y_rot_change;
    }

    @SubscribeEvent
    public void onRenderHand(RenderArmEvent event) {
        if (event.getArm() != HumanoidArm.RIGHT) {
            return;
        }
        if (!this.isPetting) {
            return;
        }
        PoseStack stack = event.getPoseStack();
        Minecraft mc = Minecraft.getInstance();
        float pTicks = mc.getDeltaTracker().getGameTimeDeltaPartialTick(true);
        AbstractClientPlayer player = event.getPlayer();
        float anim_timeline = ((float)(player.tickCount + player.getId()) + pTicks) * 0.04f;
        float occill = Mth.sin((float)(anim_timeline * 2.0f * (float)Math.PI));
        float rotating_x = -15.0f * occill;
        DogPettingManager.DogPettingType petting_type = this.getPettingTypeFor((LivingEntity)player);
        if (petting_type == DogPettingManager.DogPettingType.HUG || petting_type == DogPettingManager.DogPettingType.BACK_HUG) {
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-20.0f));
            stack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(0.0f));
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(60.0f));
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-10.0f + rotating_x));
            stack.translate(0.0, 0.2, -0.6);
        } else {
            stack.translate(0.0, 0.4, 0.0);
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-57.0f));
            stack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(0.0f));
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-30.0f));
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(rotating_x));
        }
    }

    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseButton.Pre event) {
        if (this.selectedType == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        int button = event.getButton();
        if (!GuiUtil_1_21_9.matchesMouse(mc.options.keyUse, button)) {
            return;
        }
        if (mc.screen != null || mc.getOverlay() != null || mc.player == null) {
            return;
        }
        int action = event.getAction();
        if (this.handleStopPetting(action)) {
            event.setCanceled(true);
            return;
        }
        Optional<Dog> dog_optional = this.getLookingDog();
        if (!dog_optional.isPresent()) {
            return;
        }
        if (this.handleStartPetting(action, dog_optional.get(), (Player)mc.player)) {
            event.setCanceled(true);
            return;
        }
        if (this.handleOpenPettingScreen(action, dog_optional.get(), (Player)mc.player)) {
            event.setCanceled(true);
            return;
        }
    }

    private boolean handleStopPetting(int action) {
        if (!this.isPetting) {
            return false;
        }
        if (action == 1) {
            return false;
        }
        if (this.dog != null) {
            this.requestPetting(this.dog, false);
        } else {
            this.setPetting(null);
        }
        return true;
    }

    private boolean handleStartPetting(int action, Dog dog, Player player) {
        if (this.isPetting) {
            return false;
        }
        if (action != 1) {
            return false;
        }
        if (!player.isShiftKeyDown()) {
            return false;
        }
        if (!dog.pettingManager.canPet(player)) {
            return false;
        }
        this.requestPetting(dog, true);
        return true;
    }

    private boolean handleOpenPettingScreen(int action, Dog dog, Player player) {
        if (this.isPetting) {
            return false;
        }
        if (action != 1) {
            return false;
        }
        if (player.isShiftKeyDown()) {
            return false;
        }
        if (!dog.pettingManager.isInPetDistance(dog, player)) {
            return false;
        }
        if (!EntityUtil.allHandEmpty((LivingEntity)player)) {
            return false;
        }
        PetSelectScreen.open();
        return true;
    }

    private Optional<Dog> getLookingDog() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return Optional.empty();
        }
        HitResult hitResult = mc.hitResult;
        if (hitResult == null) {
            return Optional.empty();
        }
        if (!(hitResult instanceof EntityHitResult)) {
            return Optional.empty();
        }
        EntityHitResult entityHit = (EntityHitResult)hitResult;
        Entity entity = entityHit.getEntity();
        if (!(entity instanceof Dog)) {
            return Optional.empty();
        }
        Dog dog = (Dog)entity;
        return Optional.of(dog);
    }

    private DogPettingManager.DogPettingType getPettingTypeFor(LivingEntity player) {
        UUID id = player.getUUID();
        Dog dog = this.petterMap.get(id);
        if (dog == null) {
            return DogPettingManager.DogPettingType.FACERUB;
        }
        return dog.getPettingState().type();
    }

    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (PlayerRenderPrep_21_3.player == null) {
            return;
        }
        if (!this.isPettingPlayer(PlayerRenderPrep_21_3.player)) {
            return;
        }
        AvatarRenderer renderer = event.getRenderer();
        EntityModel model = renderer.getModel();
        PettingArmPose.activeLeft_1_21_5 = true;
        PettingArmPose.activeRight_1_21_5 = true;
    }

    private boolean isPettingPlayer(Player player) {
        if (this.petterMap.isEmpty()) {
            return false;
        }
        Dog dog = this.petterMap.get(player.getUUID());
        return dog != null && dog.pettingManager.isInPetDistance(dog, player);
    }

    public void applyTransform(HumanoidModel<?> model, LivingEntity player, HumanoidArm arm) {
        Minecraft mc = Minecraft.getInstance();
        float pTicks = mc.getDeltaTracker().getGameTimeDeltaPartialTick(true);
        float anim_timeline = ((float)(player.getId() + player.tickCount) + pTicks) * 0.04f;
        DogPettingManager.DogPettingType petting_type = this.getPettingTypeFor(player);
        if (petting_type == DogPettingManager.DogPettingType.HUG || petting_type == DogPettingManager.DogPettingType.BACK_HUG) {
            if (arm == HumanoidArm.RIGHT) {
                float occill = Mth.sin((float)(anim_timeline * 12.0f));
                float rotating_x = 15.0f * occill;
                model.rightArm.xRot = -1.3089969f;
                model.rightArm.xRot += rotating_x * ((float)Math.PI / 180);
                model.rightArm.yRot = -0.06981317f;
            } else if (arm == HumanoidArm.LEFT) {
                float occill = Mth.sin((float)((float)Math.PI + anim_timeline * 12.0f));
                float rotating_x = 15.0f * occill;
                model.leftArm.xRot = -1.3089969f;
                model.leftArm.xRot += rotating_x * ((float)Math.PI / 180);
                model.leftArm.yRot = 0.06981317f;
            }
        } else if (petting_type == DogPettingManager.DogPettingType.BELLY_RUB) {
            if (arm == HumanoidArm.RIGHT) {
                float occill = Mth.sin((float)(anim_timeline * 12.0f));
                float rotating_x = 15.0f * occill;
                model.rightArm.xRot = -1.0471976f;
                model.rightArm.xRot += rotating_x * ((float)Math.PI / 180);
                model.rightArm.yRot = -0.34906584f;
            } else if (arm == HumanoidArm.LEFT) {
                float occill = Mth.sin((float)((float)Math.PI + anim_timeline * 12.0f));
                float rotating_x = 15.0f * occill;
                model.leftArm.xRot = -1.0471976f;
                model.leftArm.xRot += rotating_x * ((float)Math.PI / 180);
                model.leftArm.yRot = 0.34906584f;
            }
        } else if (arm == HumanoidArm.RIGHT) {
            float occill = Mth.sin((float)(anim_timeline * 12.0f));
            float rotating_x = 15.0f * occill;
            model.rightArm.xRot = -2.0071287f;
            model.rightArm.yRot = -0.5235988f;
            model.rightArm.yRot += rotating_x * ((float)Math.PI / 180);
        }
    }

    @SubscribeEvent
    public void modifyCameraAngle(ViewportEvent.ComputeCameraAngles event) {
        if (!this.isPetting) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        CameraType view_type = mc.options.getCameraType();
        if (view_type.isFirstPerson()) {
            return;
        }
        double pTicks = event.getPartialTick();
        float camera_xRot = (float)Mth.lerp((double)pTicks, (double)this.pet_camera_xRot0_add, (double)this.pet_camera_xRot_add);
        camera_xRot = Mth.clamp((float)camera_xRot, (float)-75.0f, (float)75.0f);
        event.setPitch(camera_xRot);
        event.setYaw(event.getYaw() + (float)Mth.lerp((double)pTicks, (double)this.pet_camera_yRot0_add, (double)this.pet_camera_yRot_add));
    }

    @SubscribeEvent
    public void onMovementInput(MovementInputUpdateEvent event) {
        if (!this.isPetting) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Options options = mc.options;
        CameraType view_type = options.getCameraType();
        if (view_type.isFirstPerson()) {
            return;
        }
        ClientInput input = event.getInput();
        Input input_21_3_old = input.keyPresses;
        input.keyPresses = new Input(false, false, false, false, input_21_3_old.jump(), input_21_3_old.shift(), input_21_3_old.sprint());
        input.moveVector = Vec2.ZERO;
    }

    public void onPettingUpdate(Dog dog, DogPettingManager.DogPettingState state) {
        if (!state.is_petting()) {
            this.clearPettingFor(dog);
            return;
        }
        UUID petter_id = state.petting_id();
        this.addPetterToMap(petter_id, dog);
    }

    private void clearPettingFor(Dog dog) {
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, Dog> entry : this.petterMap.entrySet()) {
            if (entry.getValue() != dog) continue;
            toRemove.add(entry.getKey());
        }
        for (UUID key : toRemove) {
            this.removePetterFromMap(key);
        }
    }

    private void addPetterToMap(UUID petter, Dog dog) {
        if (dog == null || petter == null) {
            return;
        }
        this.petterMap.put(petter, dog);
        if (this.isSelfUUID(petter)) {
            this.setPetting(dog);
        }
    }

    private void removePetterFromMap(UUID petter) {
        if (petter == null) {
            return;
        }
        this.petterMap.remove(petter);
        if (this.isSelfUUID(petter)) {
            this.setPetting(null);
        }
    }

    private void clearPetterMap() {
        this.petterMap.clear();
        this.setPetting(null);
    }

    private boolean isSelfUUID(UUID petter) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        return player != null && Objects.equal((Object)player.getUUID(), (Object)petter);
    }

    private void requestPetting(Dog dog, boolean pet) {
        if (pet) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogPettingData(dog.getId(), true, this.selectedType));
        } else {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogPettingData(dog.getId(), false, null));
        }
    }
}

