/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.backward_imitate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import doggytalents.common.item.DoubleDyableAccessoryItem;
import doggytalents.common.util.Util;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class DoubleDyableTint_1_21_5 {
    public static final MapCodec<Fg> FG_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ExtraCodecs.RGB_COLOR_CODEC.fieldOf("default").forGetter(Fg::defaultColor)).apply((Applicative)builder, Fg::new));
    public static final MapCodec<Bg> BG_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ExtraCodecs.RGB_COLOR_CODEC.fieldOf("default").forGetter(Bg::defaultColor)).apply((Applicative)builder, Bg::new));

    public static Fg fg(DoubleDyableAccessoryItem item) {
        return new Fg(item.getDefaultFgColor());
    }

    public static Bg bg(DoubleDyableAccessoryItem item) {
        return new Bg(item.getDefaultBgColor());
    }

    public static void registerTints(RegisterColorHandlersEvent.ItemTintSources event) {
        event.register(Util.getResource("double_dyable_fg"), FG_CODEC);
        event.register(Util.getResource("double_dyable_bg"), BG_CODEC);
    }

    public record Fg(int defaultColor) implements ItemTintSource
    {
        public int calculate(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
            Item item = stack.getItem();
            if (!(item instanceof DoubleDyableAccessoryItem)) {
                return -1;
            }
            DoubleDyableAccessoryItem dyable = (DoubleDyableAccessoryItem)item;
            return dyable.getFgColor(stack);
        }

        public MapCodec<Fg> type() {
            return FG_CODEC;
        }
    }

    public record Bg(int defaultColor) implements ItemTintSource
    {
        public int calculate(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
            Item item = stack.getItem();
            if (!(item instanceof DoubleDyableAccessoryItem)) {
                return -1;
            }
            DoubleDyableAccessoryItem dyable = (DoubleDyableAccessoryItem)item;
            return dyable.getBgColor(stack);
        }

        public MapCodec<Bg> type() {
            return BG_CODEC;
        }
    }
}

