/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.dog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.backward_imitate.DogRenderState_21_3;
import doggytalents.client.backward_imitate.IBaseDogModel_21_3;
import doggytalents.client.backward_imitate.ModelUtil_1_21_9;
import doggytalents.client.entity.model.animation.DogAnimationRegistry;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.client.entity.model.dog.DogPoseSetups;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.entity.anim.DogAnimationState;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.util.Util;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class DogModel
extends EntityModel<DogRenderState_21_3>
implements IBaseDogModel_21_3 {
    public static final float[] MANE_LYING_OFF = new float[]{0.0f, 6.0f, 1.0f};
    public static final float[] MANE_SITTING_OFF = new float[]{0.0f, 2.0f, 0.0f};
    public static final float[] TAIL_LYING_OFF = new float[]{0.0f, 6.0f, 0.0f};
    public static final float[] TAIL_SITTING_OFF = new float[]{0.0f, 9.0f, -2.0f};
    public static final Vector3f DEFAULT_ROOT_PIVOT = new Vector3f(0.0f, 15.0f, 0.0f);
    public ModelPart head;
    public ModelPart realHead;
    public ModelPart body;
    public ModelPart mane;
    public ModelPart legBackRight;
    public ModelPart legBackLeft;
    public ModelPart legFrontRight;
    public ModelPart legFrontLeft;
    public ModelPart tail;
    public ModelPart realTail;
    public ModelPart root;
    public Optional<ModelPart> earLeft;
    public Optional<ModelPart> earRight;
    Vector3f vecObj = new Vector3f();
    private float headXRot0 = 0.0f;
    private float headYRot0 = 0.0f;
    private float realHeadZRot0 = 0.0f;
    private AccessoryState accessoryState = AccessoryState.HAVE_NOT_TESTED;
    protected float wetShade = 1.0f;
    public boolean young;

    public DogModel(ModelPart box) {
        super(box);
        this.initDogModel(box);
    }

    public DogModel(ModelPart box, Function<ResourceLocation, RenderType> renderType) {
        super(box, renderType);
        this.initDogModel(box);
    }

    protected void initDogModel(ModelPart box) {
        this.populateMandatoryParts(box);
        this.addOptionalParts(box);
        this.correctInitalPose();
    }

    private final void populateMandatoryParts(ModelPart box) {
        this.root = box;
        this.head = box.getChild("head");
        this.realHead = this.head.getChild("real_head");
        this.body = box.getChild("body");
        this.mane = box.getChild("upper_body");
        this.legBackRight = box.getChild("right_hind_leg");
        this.legBackLeft = box.getChild("left_hind_leg");
        this.legFrontRight = box.getChild("right_front_leg");
        this.legFrontLeft = box.getChild("left_front_leg");
        this.tail = box.getChild("tail");
        this.realTail = this.tail.getChild("real_tail");
    }

    protected void addOptionalParts(ModelPart box) {
        this.earLeft = this.getChildIfPresent(this.realHead, "left_ear");
        this.earRight = this.getChildIfPresent(this.realHead, "right_ear");
    }

    protected Optional<ModelPart> getChildIfPresent(ModelPart box, String name) {
        if (!box.hasChild(name)) {
            return Optional.empty();
        }
        return Optional.of(box.getChild(name));
    }

    protected void correctInitalPose() {
        PartPose tailPose = this.tail.getInitialPose();
        float tailX = tailPose.x();
        float tailY = tailPose.y();
        float tailZ = tailPose.z();
        this.tail.setInitialPose(PartPose.offset((float)tailX, (float)tailY, (float)tailZ));
    }

    public static LayerDefinition createBodyLayer() {
        return DogModel.createBodyLayerInternal(CubeDeformation.NONE);
    }

    private static LayerDefinition createBodyLayerInternal(CubeDeformation scale) {
        MeshDefinition var0 = new MeshDefinition();
        PartDefinition var1 = var0.getRoot();
        float var2 = 13.5f;
        PartDefinition var3 = var1.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.5f, (float)-7.0f));
        PartDefinition real_head = var3.addOrReplaceChild("real_head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, scale).texOffs(0, 10).addBox(-1.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, scale), PartPose.ZERO);
        real_head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(16, 14).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-3.0f, (float)0.5f));
        real_head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(16, 14).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-3.0f, (float)0.5f));
        var1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 14).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, scale), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        var1.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(21, 0).addBox(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, scale), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder var4 = CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale);
        var1.addOrReplaceChild("right_hind_leg", var4, PartPose.offset((float)-1.5f, (float)16.0f, (float)7.0f));
        var1.addOrReplaceChild("left_hind_leg", var4, PartPose.offset((float)1.5f, (float)16.0f, (float)7.0f));
        var1.addOrReplaceChild("right_front_leg", var4, PartPose.offset((float)-1.5f, (float)16.0f, (float)-4.0f));
        var1.addOrReplaceChild("left_front_leg", var4, PartPose.offset((float)1.5f, (float)16.0f, (float)-4.0f));
        PartDefinition var5 = var1.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        var5.addOrReplaceChild("real_tail", CubeListBuilder.create().texOffs(9, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)var0, (int)64, (int)32);
    }

    public void prepareMobModel(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        boolean stand_pose;
        this.resetAllPose();
        DogPose pose = dog.getDogPose();
        DogAnimation anim = dog.getAnim();
        if (anim != DogAnimation.NONE) {
            if (anim.freeHead() && pose.canBeg) {
                this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
            }
            return;
        }
        boolean bl = stand_pose = !DogPoseSetups.setupPose(pose, this, dog, limbSwing, limbSwingAmount, partialTickTime);
        if (stand_pose) {
            this.setUpStandPose(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
        if (pose.canShake) {
            this.translateShakingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
        if (pose.canBeg) {
            this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
    }

    public void setUpStandPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.animateStandWalking(dog, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void animateStandWalking(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        float w = Mth.cos((float)(limbSwing * 0.6662f));
        float w1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI));
        float swing = Mth.clamp((float)limbSwingAmount, (float)0.0f, (float)1.0f);
        float modifier = 2.5f;
        this.body.xRot += this.getAnimateWalkingValue(w, swing, modifier * -5.0f * ((float)Math.PI / 180));
        this.body.y += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.body.z += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.mane.xRot += this.getAnimateWalkingValue(w, swing, modifier * 2.5f * ((float)Math.PI / 180));
        this.mane.y += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.head.y += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.tail.y += this.getAnimateWalkingValue(w, swing, 0.5f * modifier);
        this.tail.z += this.getAnimateWalkingValue(w, swing, -0.5f * modifier);
        if (this.earRight.isPresent()) {
            this.earRight.get().xRot += this.getAnimateWalkingValue(w, swing, -0.6981317f);
            this.earRight.get().zRot += this.getAnimateWalkingValue(w, swing, -0.47996554f);
            this.earRight.get().y += this.getAnimateWalkingValue(w, swing, 0.5f);
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().xRot += this.getAnimateWalkingValue(w, swing, -0.6981317f);
            this.earLeft.get().zRot += this.getAnimateWalkingValue(w, swing, 0.47996554f);
            this.earLeft.get().y += this.getAnimateWalkingValue(w, swing, 0.5f);
        }
        this.legBackRight.xRot += w * 1.4f * limbSwingAmount;
        this.legBackLeft.xRot += w1 * 1.4f * limbSwingAmount;
        this.legFrontRight.xRot += w1 * 1.4f * limbSwingAmount;
        this.legFrontLeft.xRot += w * 1.4f * limbSwingAmount;
    }

    private float getAnimateWalkingValue(float w, float swingAmount, float amplitude) {
        int sign = Mth.sign((double)amplitude);
        amplitude = Math.abs(amplitude);
        return (float)sign * Math.abs(amplitude * swingAmount * w);
    }

    public void translateShakingDog(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.mane.zRot = dog.getShakeAngle(partialTickTime, -0.08f);
        this.body.zRot = dog.getShakeAngle(partialTickTime, -0.16f);
        this.realTail.zRot = dog.getShakeAngle(partialTickTime, -0.2f);
    }

    public void translateBeggingDog(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.realHead.zRot = dog.getInterestedAngle(partialTickTime) + dog.getShakeAngle(partialTickTime, 0.0f);
    }

    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        DogPose pose = dog.getDogPose();
        DogAnimationManager animationManager = dog.animationManager;
        if (dog.isDogInAnimDebug() && dog.getAnim().isNone()) {
            this.setDogUpDebugAnim(dog);
            return;
        }
        if (pose.freeHead) {
            this.head.xRot += headPitch * ((float)Math.PI / 180);
            this.head.yRot = this.head.yRot + netHeadYaw * (dog.isInSittingPose() && dog.isLying() ? 0.005f : (float)Math.PI / 180);
        }
        if (pose.freeTail) {
            this.tail.xRot = dog.getTailRotation();
            this.tail.yRot = dog.getWagAngle(limbSwing, limbSwingAmount, ageInTicks);
        }
        DogAnimationState animState = animationManager.animationState;
        DogAnimation anim = dog.getAnim();
        if (anim == DogAnimation.NONE) {
            return;
        }
        AnimationDefinition sequence = this.getAnimationSequence(anim);
        if (sequence == null) {
            return;
        }
        if (pose.freeHead && anim.freeHead()) {
            this.headXRot0 = this.head.xRot;
            this.headYRot0 = this.head.yRot;
            this.realHeadZRot0 = this.realHead.zRot;
        } else if (pose.freeHead && anim.freeHeadXRotOnly()) {
            this.headXRot0 = this.head.xRot;
        }
        anim.rootRotation().ifPresent(x -> this.root.yRot += x.floatValue() * ((float)Math.PI / 180));
        if (animState.isStarted()) {
            animState.updateTime(ageInTicks, anim.getSpeedModifier());
            DogKeyframeAnimations.animate(this, dog, sequence, animState.getAccumulatedTimeMillis(), 1.0f, this.vecObj);
        }
    }

    private void setDogUpDebugAnim(Dog dog) {
        this.resetAllPose();
        DogAnimationManager.DogAnimDebugState debug_state = dog.getDogAnimDebugState();
        DogAnimation dog_anim = debug_state.anim();
        AnimationDefinition sequence = DogAnimationRegistry.getSequence(dog_anim);
        if (sequence == null) {
            return;
        }
        long timestamp_millis = Util.tickMayWithPartialToMillis(debug_state.timestamp());
        DogKeyframeAnimations.animate(this, dog, sequence, timestamp_millis, 1.0f, this.vecObj);
    }

    protected AnimationDefinition getAnimationSequence(DogAnimation anim) {
        return DogAnimationRegistry.getSequence(anim);
    }

    public void resetAllPose() {
        this.root.getAllParts().forEach(x -> x.resetPose());
        this.realHead.resetPose();
        this.realTail.resetPose();
        this.earLeft.ifPresent(ear -> ear.resetPose());
        this.earRight.ifPresent(ear -> ear.resetPose());
    }

    public void copyFrom(DogModel dogModel) {
        ModelUtil_1_21_9.copyModelPartFrom(this.root, dogModel.root);
        ModelUtil_1_21_9.copyModelPartFrom(this.head, dogModel.head);
        ModelUtil_1_21_9.copyModelPartFrom(this.realHead, dogModel.realHead);
        ModelUtil_1_21_9.copyModelPartFrom(this.body, dogModel.body);
        ModelUtil_1_21_9.copyModelPartFrom(this.mane, dogModel.mane);
        ModelUtil_1_21_9.copyModelPartFrom(this.legBackRight, dogModel.legBackRight);
        ModelUtil_1_21_9.copyModelPartFrom(this.legBackLeft, dogModel.legBackLeft);
        ModelUtil_1_21_9.copyModelPartFrom(this.legFrontRight, dogModel.legFrontRight);
        ModelUtil_1_21_9.copyModelPartFrom(this.legFrontLeft, dogModel.legFrontLeft);
        ModelUtil_1_21_9.copyModelPartFrom(this.tail, dogModel.tail);
        ModelUtil_1_21_9.copyModelPartFrom(this.realTail, dogModel.realTail);
    }

    public void resetPart(ModelPart part, Dog dog) {
        if (part == this.tail && dog.getAnim().freeTail()) {
            this.tail.resetPose();
            this.tail.xRot = dog.getTailRotation();
            return;
        }
        if (part == this.head && dog.getAnim().freeHead() && dog.getDogPose().freeHead) {
            this.head.resetPose();
            this.head.xRot = this.headXRot0;
            this.head.yRot = this.headYRot0;
            this.realHead.resetPose();
            this.realHead.zRot = this.realHeadZRot0;
            return;
        }
        if (part == this.head && dog.getAnim().convertHeadZRot()) {
            this.head.resetPose();
            this.head.xRot = this.headXRot0;
            return;
        }
        part.resetPose();
    }

    public void adjustAnimatedPart(ModelPart part, Dog dog) {
        if (part == this.tail && dog.getAnim().freeTail() && part.xRot > 3.0f) {
            part.xRot = 3.0f;
        }
        if (part == this.head && part.zRot != 0.0f && dog.getAnim().convertHeadZRot()) {
            this.realHead.zRot = part.zRot;
            part.zRot = 0.0f;
        }
    }

    public Optional<ModelPart> searchForPartWithName(String name) {
        return DogKeyframeAnimations.searchForPartWithName(this.root, name);
    }

    public boolean useDefaultModelForAccessories() {
        return false;
    }

    public boolean acessoryShouldRender(Dog dog, AccessoryInstance inst) {
        return true;
    }

    public boolean armorShouldRender(Dog dog) {
        return true;
    }

    public boolean incapShouldRender(Dog dog) {
        return true;
    }

    public boolean scaleBabyDog() {
        return true;
    }

    public boolean renderDogWetShade() {
        return true;
    }

    public boolean warnAccessory(Dog dog, Accessory inst) {
        return false;
    }

    @Nullable
    public Vector3f getCustomRootPivotPoint() {
        return null;
    }

    public boolean hasDefaultScale() {
        return false;
    }

    public float getDefaultScale() {
        return 1.0f;
    }

    public AccessoryState getAccessoryState() {
        return this.accessoryState;
    }

    public DogModel setAccessoryState(AccessoryState state) {
        if (state == null) {
            state = AccessoryState.HAVE_NOT_TESTED;
        }
        this.accessoryState = state;
        return this;
    }

    public void setVisible(boolean visible) {
        this.head.visible = visible;
        this.body.visible = visible;
        this.legBackRight.visible = visible;
        this.legBackLeft.visible = visible;
        this.legFrontRight.visible = visible;
        this.legFrontLeft.visible = visible;
        this.tail.visible = visible;
        this.mane.visible = visible;
    }

    @Override
    public void copyPropertiesTo(IBaseDogModel_21_3 model) {
        IBaseDogModel_21_3.super.copyPropertiesTo(model);
        if (!this.scaleBabyDog()) {
            model.setDogYoung(false);
        }
    }

    public void setWetShade(float shade) {
        this.wetShade = shade;
    }

    public void resetWetShade() {
        this.wetShade = 1.0f;
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer vertex_consumer, int light, int overlay, int color_overlay) {
        if (this.renderDogWetShade()) {
            int wet_color = ARGB.colorFromFloat((float)1.0f, (float)this.wetShade, (float)this.wetShade, (float)this.wetShade);
            color_overlay = ARGB.multiply((int)color_overlay, (int)wet_color);
        }
        DogModelRenderContext ctx = DogModelRenderContext.forDogModelRendering(this, vertex_consumer, light, overlay, color_overlay, this.getDogModelAdditionalHeadRenderer());
        DogModel.renderDogModelFromRootWithPivot(stack, ctx);
    }

    protected Optional<AddtionalHeadRenderer> getDogModelAdditionalHeadRenderer() {
        return Optional.empty();
    }

    private Optional<ModelPart> getDogModelBabyHead() {
        return this.doScaleBabyHead() ? Optional.of(this.head) : Optional.empty();
    }

    protected boolean doScaleBabyHead() {
        return this.young && this.scaleBabyDog();
    }

    public static void renderDogModelFromRootWithPivot(PoseStack stack, DogModelRenderContext ctx) {
        ModelPart root = ctx.root();
        Vector3f pivot = ctx.pivot();
        Optional<ModelPart> head_baby = ctx.headBaby();
        DogRenderPartContext part_ctx = ctx.renderPartContext().orElse(null);
        AddtionalHeadRenderer addtional_head = ctx.additionalHeadRenderer().orElse(null);
        stack.pushPose();
        DogModel.applyRootTransformWithPivotedRotation(root, stack, pivot);
        RootRotationTranslationStash stashed_root = RootRotationTranslationStash.stash(root);
        if (head_baby.isPresent()) {
            ModelPart head = head_baby.get();
            boolean headVisible0 = head.visible;
            head.visible = false;
            stack.pushPose();
            if (part_ctx != null) {
                part_ctx.renderPart(stack, root);
            }
            stack.popPose();
            head.visible = headVisible0;
            stack.pushPose();
            stack.scale(2.0f, 2.0f, 2.0f);
            stack.translate(0.0, -0.5, 0.15);
            if (part_ctx != null) {
                part_ctx.renderPart(stack, head);
            }
            if (addtional_head != null) {
                addtional_head.render(stack, ctx.renderPartContext());
            }
            stack.popPose();
        } else {
            if (part_ctx != null) {
                part_ctx.renderPart(stack, root);
            }
            if (addtional_head != null) {
                addtional_head.render(stack, ctx.renderPartContext());
            }
        }
        stack.popPose();
        stashed_root.restore(root);
    }

    private static void applyRootTransformWithPivotedRotation(ModelPart root, PoseStack stack, Vector3f pivot) {
        stack.translate(root.x / 16.0f, root.y / 16.0f, root.z / 16.0f);
        stack.translate(pivot.x / 16.0f, pivot.y / 16.0f, pivot.z / 16.0f);
        if (root.xRot != 0.0f || root.yRot != 0.0f || root.zRot != 0.0f) {
            stack.mulPose((Quaternionfc)new Quaternionf().rotationZYX(root.zRot, root.yRot, root.xRot));
        }
        stack.translate(-pivot.x / 16.0f, -pivot.y / 16.0f, -pivot.z / 16.0f);
    }

    public void setupAnim(DogRenderState_21_3 render_state) {
        Dog dog = render_state.dog;
        float walk_anim_time = render_state.walkAnimationPos;
        float walk_anim_speed = render_state.walkAnimationSpeed;
        float yrot = render_state.yRot;
        float xrot = render_state.xRot;
        float ticks_with_partial = render_state.ageInTicks;
        this.young = dog.isBaby();
        render_state.runDefferedSetupAndInvalidate_1_21_9();
        this.prepareMobModel(dog, walk_anim_time, walk_anim_speed, render_state.partialTick);
        this.setupAnim(dog, walk_anim_time, walk_anim_speed, ticks_with_partial, yrot, xrot);
    }

    @Override
    public void setDogYoung(boolean val) {
        this.young = val;
    }

    @Override
    public boolean getDogYoung() {
        return this.young;
    }

    public static enum AccessoryState {
        NON_COMPATIBLE,
        SOME_WILL_FIT,
        HAVE_NOT_TESTED,
        RECOMMENDED,
        MODEL_ONLY;

    }

    public record DogModelRenderContext(ModelPart root, Vector3f pivot, Optional<ModelPart> headBaby, Optional<DogRenderPartContext> renderPartContext, Optional<AddtionalHeadRenderer> additionalHeadRenderer) {
        public static DogModelRenderContext forDogModelRendering(DogModel model, VertexConsumer vertex_consumer, int light, int overlay, int color_overlay, Optional<AddtionalHeadRenderer> addtionalHeadRenderer) {
            Vector3f pivot = DEFAULT_ROOT_PIVOT;
            Vector3f custom_pivot = model.getCustomRootPivotPoint();
            if (custom_pivot != null) {
                pivot = custom_pivot;
            }
            DogRenderPartContext render_part_ctx = new DogRenderPartContext(vertex_consumer, light, overlay, color_overlay);
            return new DogModelRenderContext(model.root, pivot, model.getDogModelBabyHead(), Optional.of(render_part_ctx), addtionalHeadRenderer);
        }
    }

    public record DogRenderPartContext(VertexConsumer vertex_consumer, int light, int overlay, int color_overlay) {
        public void renderPart(PoseStack stack, ModelPart part) {
            part.render(stack, this.vertex_consumer(), this.light(), this.overlay(), this.color_overlay());
        }

        public void renderGlowingPart(PoseStack stack, ModelPart part) {
            part.render(stack, this.vertex_consumer(), 0xF000F0, this.overlay(), this.color_overlay());
        }
    }

    @FunctionalInterface
    public static interface AddtionalHeadRenderer {
        public void render(PoseStack var1, Optional<DogRenderPartContext> var2);
    }

    private record RootRotationTranslationStash(float x, float y, float z, float xRot, float yRot, float zRot) {
        public static RootRotationTranslationStash stash(ModelPart root) {
            RootRotationTranslationStash ret = new RootRotationTranslationStash(root.x, root.y, root.z, root.xRot, root.yRot, root.zRot);
            root.x = 0.0f;
            root.y = 0.0f;
            root.z = 0.0f;
            root.xRot = 0.0f;
            root.yRot = 0.0f;
            root.zRot = 0.0f;
            return ret;
        }

        public void restore(ModelPart root) {
            root.x = this.x;
            root.y = this.y;
            root.z = this.z;
            root.xRot = this.xRot;
            root.yRot = this.yRot;
            root.zRot = this.zRot;
        }
    }
}

