/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.DoggyTalents;
import doggytalents.client.ClientSetup;
import doggytalents.client.backward_imitate.BaseDogModel_21_3;
import doggytalents.client.backward_imitate.DogRenderLayer_21_3;
import doggytalents.client.backward_imitate.DogRenderState_21_3;
import doggytalents.client.entity.model.DogBackpackModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import doggytalents.common.talent.PackPuppyTalent;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;

public class PackPuppyRenderer
extends DogRenderLayer_21_3 {
    private DogBackpackModel model;

    public PackPuppyRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super((RenderLayerParent<DogRenderState_21_3, DogModel>)parentRenderer);
        this.model = new DogBackpackModel(ctx.bakeLayer(ClientSetup.DOG_BACKPACK));
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DogModel model;
        if (dog.isInvisible()) {
            return;
        }
        if (!((Boolean)ConfigHandler.CLIENT.RENDER_CHEST.get()).booleanValue()) {
            return;
        }
        DogSkin dogSkin = dog.getClientSkin();
        if (dogSkin.useCustomModel() && !(model = dogSkin.getCustomModel().getValue()).armorShouldRender(dog)) {
            return;
        }
        Optional<PackPuppyTalent> inst = dog.getTalent(DoggyTalents.PACK_PUPPY).map(x -> x.cast(PackPuppyTalent.class));
        if (inst.isPresent() && inst.get().renderChest()) {
            this.getParentModel().copyPropertiesTo(this.model);
            this.model.prepareMobModel(dog, limbSwing, limbSwingAmount, partialTicks);
            this.model.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.model.sync(this.getParentModel());
            BaseDogModel_21_3.renderColoredCutoutModel(this.model, Resources.TALENT_CHEST, poseStack, buffer, packedLight, dog, -1);
        }
    }
}

