/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.DoggyTalents;
import doggytalents.client.ClientSetup;
import doggytalents.client.backward_imitate.BaseDogModel_21_3;
import doggytalents.client.backward_imitate.DogRenderLayer_21_3;
import doggytalents.client.backward_imitate.DogRenderState_21_3;
import doggytalents.client.entity.model.TorchDogModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import doggytalents.common.talent.DoggyTorchTalent;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;

public class TorchDogRenderer
extends DogRenderLayer_21_3 {
    private TorchDogModel model;

    public TorchDogRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super((RenderLayerParent<DogRenderState_21_3, DogModel>)parentRenderer);
        this.model = new TorchDogModel(ctx.bakeLayer(ClientSetup.DOG_TORCHIE));
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (dog.isInvisible()) {
            return;
        }
        Optional<DoggyTorchTalent> inst = dog.getTalent(DoggyTalents.DOGGY_TORCH).map(x -> x.cast(DoggyTorchTalent.class));
        if (!inst.isPresent()) {
            return;
        }
        if (!inst.get().canRenderTorch()) {
            return;
        }
        if (!inst.get().renderTorch()) {
            return;
        }
        this.getParentModel().copyPropertiesTo(this.model);
        this.model.prepareMobModel(dog, limbSwing, limbSwingAmount, partialTicks);
        this.model.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ResourceLocation res = Resources.TORCH_DOG;
        int renderLight = 0xF000F0;
        if (dog.isDefeated()) {
            res = Resources.TORCH_DOG_UNLIT;
            renderLight = packedLight;
        }
        BaseDogModel_21_3.renderColoredCutoutModel(this.model, res, poseStack, buffer, renderLight, dog, -1);
    }
}

