/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.MainInfoView.view;

import doggytalents.client.DogRandomNameRegistry;
import doggytalents.client.screen.DogNewInfoScreen.element.view.MainInfoView.GroupsListElement;
import doggytalents.client.screen.DogNewInfoScreen.widget.CombatReturnSwitch;
import doggytalents.client.screen.DogNewInfoScreen.widget.LowHealthStrategySwitch;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.framework.ToolTipOverlayManager;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.element.ElementPosition;
import doggytalents.client.screen.framework.element.ScrollView;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.client.screen.framework.widget.FlatCheckbox;
import doggytalents.client.screen.framework.widget.OneLineLimitedTextArea;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.CrossOriginTpData;
import doggytalents.common.network.packet.data.DogAutoMountData;
import doggytalents.common.network.packet.data.DogForceSitData;
import doggytalents.common.network.packet.data.DogNameData;
import doggytalents.common.network.packet.data.DogObeyData;
import doggytalents.common.network.packet.data.DogOnDutyData;
import doggytalents.common.network.packet.data.DogRegardTeamPlayersData;
import doggytalents.common.network.packet.data.FriendlyFireData;
import doggytalents.common.network.packet.data.HideArmorData;
import doggytalents.common.network.packet.data.PatrolTargetLockData;
import doggytalents.common.util.DogUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class EditInfoView
extends AbstractElement {
    static final int PADDING_LEFT = 10;
    static final int PADDING_RIGHT = 30;
    static final int PADDING_TOP = 10;
    static final int LINE_SPACING = 3;
    Dog dog;
    Font font;

    public EditInfoView(AbstractElement parent, Screen screen, Dog dog, Font font) {
        super(parent, screen);
        this.dog = dog;
        this.font = font;
    }

    @Override
    public AbstractElement init() {
        ScrollView scrollView = new ScrollView(this, this.getScreen());
        scrollView.setPosition(ElementPosition.PosType.ABSOLUTE, 0, 0).setSize(1.0f, 1.0f).init();
        this.addChildren((GuiEventListener)scrollView);
        AbstractElement scroll = scrollView.getContainer();
        scroll.addChildren((GuiEventListener)new NewnameEntry(scroll, this.getScreen(), this.dog).init());
        scroll.addChildren((GuiEventListener)new ButtonOptionEntry(scroll, this.getScreen(), (AbstractWidget)new FlatCheckbox(0, 0, -3299584, b -> {
            boolean newVal = !this.dog.canOwnerAttack();
            b.setValue(newVal);
            this.requestFriendlyFire(newVal);
        }).initialValue(this.dog.canOwnerAttack()), I18n.get((String)"doggui.friendlyfire", (Object[])new Object[0])).init());
        scroll.addChildren((GuiEventListener)new ButtonOptionEntry(scroll, this.getScreen(), (AbstractWidget)new FlatCheckbox(0, 0, -3299584, b -> {
            Boolean newVal = !this.dog.willObeyOthers();
            b.setValue(newVal);
            this.requestObeyOthers(newVal);
        }).initialValue(this.dog.willObeyOthers()), I18n.get((String)"doggui.obeyothers", (Object[])new Object[0])).init());
        scroll.addChildren((GuiEventListener)new ButtonOptionEntry(scroll, this.getScreen(), (AbstractWidget)new FlatCheckbox(0, 0, b -> {
            Boolean newVal = !this.dog.regardTeamPlayers();
            b.setValue(newVal);
            this.requestRegardTeamPlayers(newVal);
        }){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (this.isHovered) {
                    ToolTipOverlayManager.get().setComponents(ScreenUtil.splitInto(I18n.get((String)"doggui.regard_team_players.help", (Object[])new Object[0]), 150, EditInfoView.this.font));
                }
            }
        }.initialValue(this.dog.regardTeamPlayers()), I18n.get((String)"doggui.regard_team_players", (Object[])new Object[0])).init());
        scroll.addChildren((GuiEventListener)new ButtonOptionEntry(scroll, this.getScreen(), (AbstractWidget)new FlatCheckbox(0, 0, b -> {
            Boolean newVal = !this.dog.forceSit();
            b.setValue(newVal);
            this.requestForceSit(newVal);
        }){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (this.isHovered) {
                    ToolTipOverlayManager.get().setComponents(ScreenUtil.splitInto(I18n.get((String)"doggui.force_sit.help", (Object[])new Object[0]), 150, EditInfoView.this.font));
                }
            }
        }.initialValue(this.dog.forceSit()), I18n.get((String)"doggui.force_sit", (Object[])new Object[0])).init());
        scroll.addChildren((GuiEventListener)new ButtonOptionEntry(scroll, this.getScreen(), (AbstractWidget)new FlatCheckbox(0, 0, b -> {
            Boolean newVal = !this.dog.crossOriginTp();
            b.setValue(newVal);
            this.requestCrossOriginTp(newVal);
        }){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (this.isHovered) {
                    ToolTipOverlayManager.get().setComponents(ScreenUtil.splitInto(I18n.get((String)"doggui.cross_origin_tp.help", (Object[])new Object[0]), 150, EditInfoView.this.font));
                }
            }
        }.initialValue(this.dog.crossOriginTp()), I18n.get((String)"doggui.cross_origin_tp", (Object[])new Object[0])).init());
        scroll.addChildren((GuiEventListener)new ButtonOptionEntry(scroll, this.getScreen(), (AbstractWidget)new FlatCheckbox(0, 0, b -> {
            Boolean newVal = !this.dog.patrolTargetLock();
            b.setValue(newVal);
            this.requestPatrolTargetLock(newVal);
        }){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (this.isHovered) {
                    ToolTipOverlayManager.get().setComponents(ScreenUtil.splitInto(I18n.get((String)"doggui.patrol_target_lock.help", (Object[])new Object[0]), 150, EditInfoView.this.font));
                }
            }
        }.initialValue(this.dog.patrolTargetLock()), I18n.get((String)"doggui.patrol_target_lock", (Object[])new Object[0])).init());
        scroll.addChildren((GuiEventListener)new ButtonOptionEntry(scroll, this.getScreen(), (AbstractWidget)new FlatCheckbox(0, 0, b -> {
            Boolean newVal = !this.dog.hideArmor();
            b.setValue(newVal);
            this.requestShowArmor(newVal);
        }).initialValue(this.dog.hideArmor()), I18n.get((String)"doggui.hide_armor", (Object[])new Object[0])).init());
        scroll.addChildren((GuiEventListener)new ButtonOptionEntry(scroll, this.getScreen(), (AbstractWidget)new FlatCheckbox(0, 0, b -> {
            Boolean newVal = !this.dog.dogAutoMount();
            b.setValue(newVal);
            this.requestAutoMount(newVal);
        }).initialValue(this.dog.dogAutoMount()), I18n.get((String)"doggui.auto_mount", (Object[])new Object[0])).init());
        scroll.addChildren((GuiEventListener)new ButtonOptionEntry(scroll, this.getScreen(), (AbstractWidget)new FlatCheckbox(0, 0, b -> {
            Boolean newVal = !this.dog.dogOnDuty();
            b.setValue(newVal);
            this.requestDogOnDuty(newVal);
        }){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (this.isHovered) {
                    ToolTipOverlayManager.get().setComponents(ScreenUtil.splitInto(I18n.get((String)"doggui.on_duty.help", (Object[])new Object[0]), 150, EditInfoView.this.font));
                }
            }
        }.initialValue(this.dog.dogOnDuty()), I18n.get((String)"doggui.on_duty", (Object[])new Object[0])).init());
        scroll.addChildren((GuiEventListener)new ButtonOptionEntry(scroll, this.getScreen(), new LowHealthStrategySwitch(0, 0, 100, 20, this.dog, this.font, this.getScreen()), I18n.get((String)"dog.low_health_strategy", (Object[])new Object[0])).init());
        scroll.addChildren((GuiEventListener)new ButtonOptionEntry(scroll, this.getScreen(), new CombatReturnSwitch(0, 0, 100, 20, this.dog, this.font, this.getScreen()), I18n.get((String)"dog.combat_return_strategy", (Object[])new Object[0])).init());
        scroll.addChildren((GuiEventListener)new GroupEntry(scroll, this.getScreen(), this.dog).init());
        return this;
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    private static void requestNameChange(Dog dog, String value) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogNameData(dog.getId(), value));
    }

    private void requestFriendlyFire(boolean val) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new FriendlyFireData(this.dog.getId(), val));
    }

    private void requestObeyOthers(boolean val) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogObeyData(this.dog.getId(), val));
    }

    private void requestRegardTeamPlayers(boolean val) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogRegardTeamPlayersData(this.dog.getId(), val));
    }

    private void requestForceSit(boolean val) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogForceSitData(this.dog.getId(), val));
    }

    private void requestCrossOriginTp(boolean val) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CrossOriginTpData(this.dog.getId(), val));
    }

    private void requestPatrolTargetLock(boolean val) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new PatrolTargetLockData(this.dog.getId(), val));
    }

    private void requestShowArmor(boolean val) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new HideArmorData(this.dog.getId(), val));
    }

    private void requestAutoMount(boolean val) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogAutoMountData(this.dog.getId(), val));
    }

    private void requestDogOnDuty(boolean val) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogOnDutyData(this.dog.getId(), val));
    }

    private static class NewnameEntry
    extends AbstractElement {
        private Font font;
        private Dog dog;
        private EditBox nameEdit;
        private FlatButton applyButton;
        private FlatButton randomButton;
        private String replacingStr = null;

        public NewnameEntry(AbstractElement parent, Screen screen, Dog dog) {
            super(parent, screen);
            this.font = Minecraft.getInstance().font;
            this.dog = dog;
        }

        @Override
        public AbstractElement init() {
            this.setPosition(ElementPosition.PosType.RELATIVE, 0, 0);
            this.setSize(1.0f, 60);
            int startX = this.getRealX() + 10;
            int pY = this.getRealY() + 10;
            Objects.requireNonNull(this.font);
            this.addEditNameBox(startX, pY += 9 + 3, 180, 20);
            this.applyButton = new FlatButton(startX + this.nameEdit.getWidth() + 15, pY, 40, 20, (Component)Component.translatable((String)"doggui.common.apply"), b -> {
                String newName = this.nameEdit.getValue();
                if (this.replacingStr != null) {
                    newName = this.replacingStr;
                    this.nameEdit.setValue(newName);
                }
                EditInfoView.requestNameChange(this.dog, newName);
                b.active = false;
            });
            this.randomButton = new FlatButton(this, startX + this.nameEdit.getWidth() + 15, pY, 20, 20, (Component)Component.empty(), b -> {
                String newName = DogRandomNameRegistry.getInstance().getRandomName(this.dog);
                EditInfoView.requestNameChange(this.dog, newName);
                this.nameEdit.setValue(newName);
                this.applyButton.active = false;
                this.randomButton.active = true;
            }){

                @Override
                public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                    if (!this.active) {
                        return;
                    }
                    if (this.isHovered) {
                        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -2090967715);
                    }
                    ScreenUtil.blit_21_3(graphics, Resources.HAMBURGER, this.getX(), this.getY(), 20, 0, 20, 20);
                }
            };
            this.randomButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"doggui.newname.random.tooltip")));
            this.applyButton.active = false;
            this.randomButton.active = true;
            this.addChildren((GuiEventListener)this.randomButton);
            this.addChildren((GuiEventListener)this.applyButton);
            return this;
        }

        @Override
        public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            int startX = this.getRealX() + 10;
            int pY = this.getRealY() + 10;
            graphics.drawString(this.font, I18n.get((String)"doggui.newname", (Object[])new Object[0]), startX, pY, -1);
            if (this.replacingStr != null) {
                this.renderReplacingStr(graphics, this.replacingStr);
            }
        }

        private void renderReplacingStr(GuiGraphics graphics, String str) {
            Object renderStr = I18n.get((String)"doggui.home.edit_info.substitude_name", (Object[])new Object[]{str});
            int maxLen = this.getSizeX() - 20 - 10;
            int renderStrLen = this.font.width((String)renderStr);
            if (renderStrLen > maxLen) {
                int cutLen = Math.max(0, maxLen - this.font.width(".."));
                renderStr = this.font.plainSubstrByWidth((String)renderStr, cutLen) + "..";
            }
            int tX = this.getRealX() + 10;
            int tY = this.getRealY() + 10 + 37;
            graphics.drawString(this.font, (String)renderStr, tX, tY, -3299584);
        }

        private void addEditNameBox(int x, int y, int w, int h) {
            this.nameEdit = new EditBox(this.font, x, y, w, h, (Component)Component.translatable((String)"dogInfo.enterName"));
            this.nameEdit.setMaxLength(Dog.MAX_NAME_LEN);
            this.nameEdit.setResponder(s -> {
                String dogName;
                this.updateReplacingStr((String)s);
                if (this.applyButton == null) {
                    return;
                }
                if (this.applyButton.active) {
                    return;
                }
                String string = dogName = this.dog.hasCustomName() ? this.dog.getCustomName().getString() : "";
                if (!s.equals(dogName)) {
                    this.applyButton.active = true;
                    this.randomButton.active = false;
                }
            });
            if (this.dog.hasCustomName()) {
                this.nameEdit.setValue(this.dog.getCustomName().getString());
            }
            this.addChildren((GuiEventListener)this.nameEdit);
        }

        private void updateReplacingStr(String newVal) {
            this.replacingStr = null;
            if (newVal == null) {
                return;
            }
            String correctStr = DogUtil.checkAndCorrectInvalidName(newVal);
            if (correctStr != newVal) {
                this.replacingStr = correctStr;
            }
        }
    }

    private static class ButtonOptionEntry
    extends AbstractElement {
        private AbstractWidget button;
        private String label;
        private Font font;
        private boolean newline = false;

        public ButtonOptionEntry(AbstractElement parent, Screen screen, AbstractWidget button, String label) {
            super(parent, screen);
            this.font = Minecraft.getInstance().font;
            this.button = button;
            this.label = label;
        }

        @Override
        public AbstractElement init() {
            this.setPosition(ElementPosition.PosType.RELATIVE, 0, 0);
            this.setSize(1.0f, 23);
            int buttonX_offset = 160;
            int buttonY_offset = this.getSizeY() / 2 - this.button.getHeight() / 2 + 1;
            AbstractElement p = this.getParent();
            if (p != null && buttonX_offset + this.button.getWidth() > p.getSizeX() - 4) {
                this.newline = true;
                buttonX_offset = 10;
                buttonY_offset += 14;
            }
            if (this.newline) {
                this.setSize(1.0f, 37);
            }
            this.button.setX(this.getRealX() + buttonX_offset);
            this.button.setY(this.getRealY() + buttonY_offset);
            this.addChildren((GuiEventListener)this.button);
            OneLineLimitedTextArea labelStr = new OneLineLimitedTextArea(0, 0, 130, (Component)Component.literal((String)this.label));
            labelStr.setX(this.getRealX() + 10);
            if (this.newline) {
                labelStr.setY(this.getRealY() + 3);
            } else {
                int n = this.getRealY() + this.getSizeY() / 2;
                Objects.requireNonNull(this.font);
                labelStr.setY(n - 9 / 2);
            }
            this.addChildren((GuiEventListener)labelStr);
            return this;
        }
    }

    private static class GroupEntry
    extends AbstractElement {
        private Font font;
        private Dog dog;

        public GroupEntry(AbstractElement parent, Screen screen, Dog dog) {
            super(parent, screen);
            this.dog = dog;
            this.font = Minecraft.getInstance().font;
        }

        @Override
        public AbstractElement init() {
            this.setPosition(ElementPosition.PosType.RELATIVE, 0, 0);
            this.setSize(1.0f, 60);
            this.addChildren((GuiEventListener)new GroupsListElement(this, this.getScreen(), this.dog).setPosition(ElementPosition.PosType.ABSOLUTE, 10, 24).setSize(this.getSizeX() - 20, 40).init());
            return this;
        }

        @Override
        public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            int startX = this.getRealX() + 10;
            int pY = this.getRealY() + 10;
            graphics.drawString(this.font, "Groups: ", startX, pY, -1);
        }
    }
}

