/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.widget;

import doggytalents.api.feature.DogMode;
import doggytalents.client.backward_imitate.GuiUtil_1_21_9;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.framework.ToolTipOverlayManager;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogModeData;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ModeSwitch
extends GuiUtil_1_21_9.AbstractWidget_1_21_9 {
    static final int DEFAULT_COLOR = 1214143837;
    static final int DEFAULT_HLCOLOR = -2090967715;
    static final int PADDING_HORIZONTAL = 3;
    static final int TICK_HOVERED_NO_CLK_TILL_SHOW_INFO = 30;
    Dog dog;
    Font font;
    Screen screen;
    boolean localIsHovered = false;
    boolean hoveredLeft = false;
    boolean hoveredRight = false;
    boolean isHolding = false;
    DogMode holdMode = null;
    int timeHoveredWithoutClick = 0;
    boolean stillHovered;
    long tickCount0;

    public ModeSwitch(int x, int y, int width, int height, Dog dog, Font font, Screen screen) {
        super(x, y, width, height, (Component)Component.translatable((String)dog.getMode().getUnlocalisedName()));
        this.dog = dog;
        this.font = font;
        this.screen = screen;
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        this.timeHoveredWithoutClick = 0;
        DogMode mode = this.hoveredLeft ? this.dog.getMode().previousMode() : this.dog.getMode().nextMode();
        if (this.isHolding) {
            if (this.holdMode == null) {
                this.holdMode = mode;
            } else if (this.hoveredLeft) {
                this.holdMode = this.holdMode.previousMode();
            } else if (this.hoveredRight) {
                this.holdMode = this.holdMode.nextMode();
            }
        } else {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogModeData(this.dog.getId(), mode));
        }
        if (this.isHolding && this.holdMode != null) {
            this.setMessage((Component)Component.translatable((String)this.holdMode.getUnlocalisedName()));
        } else {
            this.setMessage((Component)Component.translatable((String)mode.getUnlocalisedName()));
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        if (!this.visible) {
            return;
        }
        int cl = this.isHovered ? -2090967715 : 1214143837;
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, cl);
        this.updateHover(mouseX, mouseY);
        this.hoveredLeft = false;
        this.hoveredRight = false;
        if (this.isHovered) {
            if (mouseX - this.getX() < this.width / 2) {
                this.hoveredLeft = true;
                this.hoveredRight = false;
            } else {
                this.hoveredLeft = false;
                this.hoveredRight = true;
            }
        }
        int mX = this.getX() + this.width / 2;
        int mY = this.getY() + this.height / 2;
        MutableComponent back_c1 = Component.literal((String)"<");
        back_c1.withStyle(Style.EMPTY.withBold(Boolean.valueOf(this.hoveredLeft)));
        int back_tX = this.getX() + 3;
        Objects.requireNonNull(this.font);
        int back_tY = mY - 9 / 2;
        graphics.drawString(this.font, (Component)back_c1, back_tX, back_tY, this.hoveredLeft ? -1 : -1509949441);
        MutableComponent next_c1 = Component.literal((String)">");
        next_c1.withStyle(Style.EMPTY.withBold(Boolean.valueOf(this.hoveredRight)));
        int next_tX = this.getX() + this.width - 3 - this.font.width((FormattedText)next_c1);
        Objects.requireNonNull(this.font);
        int next_tY = mY - 9 / 2;
        graphics.drawString(this.font, (Component)next_c1, next_tX, next_tY, this.hoveredRight ? -1 : -1509949441);
        Component mode_c1 = this.getMessage();
        int acceptedWidth = this.getWidth() - 30;
        boolean needToShowModeName = false;
        if (this.font.width((FormattedText)mode_c1) > acceptedWidth) {
            String posfix = "..";
            String newStr = this.font.plainSubstrByWidth(mode_c1.getString(), acceptedWidth - this.font.width(posfix)) + posfix;
            mode_c1 = Component.literal((String)newStr).withStyle(mode_c1.getStyle());
            needToShowModeName = true;
        }
        int mode_tX = mX - this.font.width((FormattedText)mode_c1) / 2;
        Objects.requireNonNull(this.font);
        int mode_tY = mY - 9 / 2;
        DogMode mode = this.dog.getMode();
        if (mode == DogMode.WANDERING && !this.dog.getBowlPos().isPresent()) {
            mode_c1 = mode_c1.copy().withStyle(Style.EMPTY.withColor(-3299584));
        }
        if (this.isHolding) {
            mode_c1 = mode_c1.copy().withStyle(Style.EMPTY.withColor(-37120));
        }
        graphics.drawString(this.font, mode_c1, mode_tX, mode_tY, -1);
        if (this.stillHovered && (long)this.dog.tickCount - this.tickCount0 >= 1L) {
            ++this.timeHoveredWithoutClick;
            this.tickCount0 = this.dog.tickCount;
        }
        if (this.timeHoveredWithoutClick >= 25) {
            this.setOverlayToolTip(graphics, mouseX, mouseY, needToShowModeName);
        }
    }

    private void updateHover(int mouseX, int mouseY) {
        boolean isHovered0 = this.localIsHovered;
        this.localIsHovered = this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        if (isHovered0 != this.isHovered) {
            this.stillHovered = this.isHovered;
            if (this.isHovered) {
                this.onStartHovering();
            } else {
                this.onStopHovering();
            }
        }
    }

    private void onStartHovering() {
        this.timeHoveredWithoutClick = 0;
    }

    private void onStopHovering() {
        this.timeHoveredWithoutClick = 0;
    }

    public void setOverlayToolTip(GuiGraphics graphics, int mouseX, int mouseY, boolean showMsg) {
        ArrayList<Component> list = new ArrayList<Component>();
        Component msg = this.getMessage();
        if (msg != null) {
            list.add((Component)msg.copy().withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
        }
        String str = I18n.get((String)this.dog.getMode().getUnlocalisedInfo(), (Object[])new Object[0]);
        list.addAll(ScreenUtil.splitInto(str, 150, this.font));
        if (this.dog.getMode() == DogMode.WANDERING) {
            if (this.dog.getBowlPos().isPresent()) {
                double distance = this.dog.blockPosition().distSqr((Vec3i)this.dog.getBowlPos().get());
                if (distance > 256.0) {
                    list.add((Component)Component.translatable((String)"dog.mode.docile.distance", (Object[])new Object[]{(int)Math.sqrt(distance)}).withStyle(Style.EMPTY.withColor(-3299584)));
                } else {
                    list.add((Component)Component.translatable((String)"dog.mode.docile.bowl", (Object[])new Object[]{(int)Math.sqrt(distance)}).withStyle(ChatFormatting.GREEN));
                }
            } else {
                list.add((Component)Component.translatable((String)"dog.mode.docile.nobowl").withStyle(Style.EMPTY.withColor(-3299584)));
            }
        }
        ToolTipOverlayManager.get().setComponents(list);
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public boolean keyPressedGlobal(int keyCode, int scanCode, int modifiers) {
        Minecraft mc = Minecraft.getInstance();
        KeyMapping sneakKey = mc.options.keyShift;
        if (keyCode == sneakKey.getKey().getValue()) {
            this.isHolding = true;
            return true;
        }
        return false;
    }

    public boolean keyReleasedGlobal(int keyCode, int scanCode, int modifiers) {
        if (this.isHolding && this.holdMode != null && this.dog.getMode() != this.holdMode) {
            this.setMessage((Component)Component.translatable((String)this.holdMode.getUnlocalisedName()));
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogModeData(this.dog.getId(), this.holdMode));
        }
        this.isHolding = false;
        this.holdMode = null;
        return false;
    }
}

