/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.screen.ScreenUtil;
import doggytalents.common.inventory.container.FoodBowlContainer;
import doggytalents.common.lib.Resources;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class FoodBowlScreen
extends AbstractContainerScreen<FoodBowlContainer> {
    public FoodBowlScreen(FoodBowlContainer foodBowl, Inventory playerInventory, Component displayName) {
        super((AbstractContainerMenu)foodBowl, playerInventory, displayName);
        this.imageHeight = 127;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        this.renderDogProTip(graphics);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title.getString(), 10, 8, -12566464, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        ScreenUtil.blit_21_3(graphics, Resources.GUI_FOOD_BOWL, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    private void renderDogProTip(GuiGraphics graphics) {
        int mX = this.width / 2;
        MutableComponent title = Component.translatable((String)"block.doggytalents.food_bowl.pro_tip.title").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        MutableComponent desc = Component.translatable((String)"block.doggytalents.food_bowl.pro_tip.desc");
        int max_width = Math.min(360, this.width - 10);
        List desc_lines = this.font.split((FormattedText)desc, max_width);
        int tX = mX - this.font.width((FormattedText)title) / 2;
        int tY = this.height / 2 + 70;
        graphics.drawString(this.font, (Component)title, tX, tY, -1);
        Objects.requireNonNull(this.font);
        tY += 9 + 2;
        for (FormattedCharSequence line : desc_lines) {
            tX = mX - this.font.width(line) / 2;
            graphics.drawString(this.font, line, tX, tY, -1);
            Objects.requireNonNull(this.font);
            tY += 9 + 2;
        }
    }
}

